/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import com.alibaba.fastjson.JSON;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.model.bill.BillSystemParam;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.third.collect.ImmutableMap;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class AttachmentLimitPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(AttachmentLimitPlugin.class);
    private static final String ATTACHMENT_PANEL = "attachmentpanel";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillSystemParam billSystemParam = SystemParamQueryUtil.getBillSystemParam();
        Integer maxCapacity = billSystemParam.getMaxcapacity();
        String attachmentFormat = billSystemParam.getAttachmentFormat();
        int maxUploadNums = billSystemParam.getMaxuploadnums();
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)3);
        ctrl.put("maxatmsize", maxCapacity);
        ctrl.put("maxatmcount", maxUploadNums);
        ctrl.put("ext", attachmentFormat);
        this.getView().updateControlMetadata(ATTACHMENT_PANEL, (Map)ctrl);
        IFormView view = this.getView();
        if (LOG.isInfoEnabled()) {
            LOG.info("AttachmentLimitPlugin_PromptMap:{}", (Object)SerializationUtils.toJsonString(WTCFormUtils.getPromptMap(view)));
        }
        if (WTCFormUtils.getPromptMap(view).get(ATTACHMENT_PANEL) == null) {
            String sourcePage = "wtbs_attachmentprompt";
            String sourceKey = "attachmentpanelap";
            Map<String, Set<String>> controlMap = WTCFormUtils.createControlMap(sourcePage);
            if (LOG.isInfoEnabled()) {
                LOG.info("AttachmentLimitPlugin_afterBindData  controlMap\uff1a {}", (Object)JSON.toJSONString(controlMap));
            }
            DynamicObject dataEntity = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourcePage));
            Map dataMap = ImmutableMap.of((Object)sourcePage, (Object)dataEntity);
            Map keyMap = ImmutableMap.of((Object)sourcePage, (Object)ImmutableMap.of((Object)"attachflex", (Object)sourceKey, (Object)"attflex", (Object)sourceKey, (Object)ATTACHMENT_PANEL, (Object)sourceKey, (Object)"attchmentcontentpanel", (Object)sourceKey));
            Map<String, String> promptMap = WTCFormUtils.getPromptMap(view, controlMap, dataMap, keyMap, null, Boolean.TRUE);
            Map<String, String> promptMap2 = ((Map)keyMap.get(sourcePage)).keySet().stream().filter(key -> promptMap.get(key) != null).collect(Collectors.toMap(key -> key, promptMap::get, (v1, v2) -> v1));
            promptMap2.forEach((key, value) -> promptMap2.put((String)key, MessageFormat.format(value, maxCapacity, maxUploadNums, attachmentFormat)));
            if (LOG.isInfoEnabled()) {
                LOG.info("AttachmentLimitPlugin_afterBindData  promptMap2\uff1a {}", (Object)JSON.toJSONString(promptMap2));
            }
            WTCFormUtils.setTips(view, promptMap2);
        }
    }
}

