/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class WTCApplyTypeEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(WTCApplyTypeEdit.class);

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String applytyperadio = (String)formShowParameter.getCustomParam("applytyperadio");
        Long attfile = (Long)formShowParameter.getCustomParam("attfilebasef7");
        Long attfileBo = (Long)formShowParameter.getCustomParam("attfile");
        Long attperson = (Long)formShowParameter.getCustomParam("personid");
        List idList = (List)formShowParameter.getCustomParam("idList");
        String opType = (String)formShowParameter.getCustomParam("optype");
        if (attperson == null || attperson == 0L) {
            this.setDirectOpenFormParams();
        } else if ("from_ex".equals(opType)) {
            this.setDirectOpenFormParams(attperson);
        } else if (idList != null) {
            this.getModel().setValue("applytyperadio", (Object)applytyperadio);
            if (HRStringUtils.equals((String)applytyperadio, (String)"0")) {
                this.getModel().setValue("personid", (Object)attperson);
                this.getView().setVisible(Boolean.valueOf(idList.size() > 1), new String[]{"lab_changeperson"});
                this.getModel().setValue("attfile", (Object)attfileBo);
                if (attfile != null) {
                    this.getModel().setValue("attfilebasef7", (Object)attfile);
                }
            }
        }
    }

    private void setDirectOpenFormParams() {
        Long attPerson = BillUnifyService.getUserId((IFormView)this.getView());
        this.setDirectOpenFormParams(attPerson);
    }

    private void setDirectOpenFormParams(Long attPerson) {
        if (Objects.nonNull(attPerson) && attPerson != 0L) {
            this.getModel().setValue("applytyperadio", (Object)"0");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appNumber = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            String formId = formShowParameter.getFormId();
            String propKey = "attfilebasef7";
            Object recordDateStr = formShowParameter.getCustomParam("recorddate");
            if (recordDateStr == null) {
                BillUnifyService.initAttFileTopVersion((IFormView)this.getView(), (Long)attPerson, (String)appNumber, (String)formId, (String)propKey);
            } else {
                try {
                    Date recordDate = WTCDateUtils.parseDate((String)((String)recordDateStr), (String)"yyyy-MM-dd HH:mm:ss");
                    BillUnifyService.initAttFileByDate((IFormView)this.getView(), (Long)attPerson, (String)appNumber, (String)formId, (String)propKey, (Date)recordDate);
                }
                catch (Exception ex) {
                    LOG.warn("WTCApplyTypeEdit.setDirectOpenFormParams initAttFileByDate error:{}", (Object)ex.getMessage());
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u672a\u5b8c\u6210\u5165\u804c\uff0c\u8bf7\u5148\u5b8c\u6210\u5165\u804c\u3002", (String)"WTCApplyTypeList_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean sourceWF = BillCommonService.getInstance().sourceWF(this.getView());
        if (sourceWF) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lab_changeperson"});
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        BillUnifyService.isMutex((IFormView)this.getView());
    }

    public void afterLoadData(EventObject e) {
        Long userId;
        super.afterLoadData(e);
        BillOperationStatus billStatus = ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus();
        if ((BillOperationStatus.EDIT == billStatus || BillOperationStatus.ADDNEW == billStatus) && (userId = BillUnifyService.getUserId((IFormView)this.getView())) != null && 0L != userId) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appNumber = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            String formId = formShowParameter.getFormId();
            String propKey = "attfilebasef7";
            List idList = BillUnifyService.getAttFileBoIdByAttPersonId((Long)userId, (String)appNumber, (String)formId, (String)propKey);
            this.getView().setVisible(Boolean.valueOf(idList.size() > 1), new String[]{"lab_changeperson"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit personAddEdit = (BasedataEdit)this.getView().getControl("attfilebasef7");
        personAddEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if ("attfilebasef7".equals(beforeF7SelectEvent.getProperty().getName())) {
            Object attPerson = this.getModel().getValue("personid");
            Long attPersonId = attPerson instanceof DynamicObject ? Long.valueOf(((DynamicObject)attPerson).getLong("id")) : (Long)attPerson;
            if (attPersonId == null) {
                attPersonId = BillUnifyService.getUserId((IFormView)this.getView());
            }
            long personId = 0L;
            if (attPersonId != null) {
                personId = attPersonId;
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            QFilter qFilter = new QFilter("attperson", "=", (Object)personId);
            qFilters.add(qFilter);
            QFilter excludeAttFileLevelFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(null, Long.valueOf(personId), "boid");
            qFilters.add(excludeAttFileLevelFilter);
            beforeF7SelectEvent.setCustomQFilters(qFilters);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("ignoreorgcontrol", (Object)Boolean.TRUE);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        BillUnifyService.handleBeforeClose((IFormView)this.getView());
    }
}

