/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.Date;
import java.util.EventObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class WTCApplyTypeOtherEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(WTCApplyTypeOtherEdit.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BillCommonService.getInstance().getAuthAppIdForFormPlugin(args.getFormShowParameter());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit personAddEdit = (BasedataEdit)this.getView().getControl("attfilebasef7");
        personAddEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String opType = (String)formShowParameter.getCustomParam("optype");
        Long attPerson = (Long)formShowParameter.getCustomParam("personid");
        if ("from_ex".equals(opType)) {
            String appNumber = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            String formId = formShowParameter.getFormId();
            String propKey = "attfilebasef7";
            Object recordDateStr = formShowParameter.getCustomParam("recorddate");
            if (recordDateStr != null) {
                try {
                    Date recordDate = WTCDateUtils.parseDate((String)((String)recordDateStr), (String)"yyyy-MM-dd HH:mm:ss");
                    BillUnifyService.initAttFileByDate((IFormView)this.getView(), (Long)attPerson, (String)appNumber, (String)formId, (String)propKey, (Date)recordDate, (boolean)false);
                }
                catch (Exception ex) {
                    LOG.warn("WTCApplyTypeEdit.setDirectOpenFormParams initAttFileByDate error:{}", (Object)ex.getMessage());
                }
            } else {
                BillUnifyService.initAttFileTopVersion((IFormView)this.getView(), (Long)attPerson, (String)appNumber, (String)formId, (String)propKey, (boolean)false);
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"lab_changeperson"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.setAttFileF7Enable();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        BillUnifyService.isMutex((IFormView)this.getView());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long attPerson;
        if ("attfilebasef7".equals(beforeF7SelectEvent.getProperty().getName()) && (attPerson = BillUnifyService.getUserId((IFormView)this.getView())) != null && attPerson != 0L) {
            QFilter qFilter = new QFilter("attperson.id", "!=", (Object)attPerson);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    private void setAttFileF7Enable() {
        boolean sourceWF = BillCommonService.getInstance().sourceWF(this.getView());
        if (sourceWF) {
            String propKey = "attfilebasef7";
            this.getView().setEnable(Boolean.FALSE, new String[]{propKey});
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        BillUnifyService.handleBeforeClose((IFormView)this.getView());
    }
}

