/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.auth.WTCBizDataPermissionServiceImpl;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.common.enums.bill.BillApplyTypeEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class WTCApplyTypeSelfList
extends HRDataBaseList {
    private static final String UNKONW_ATTFILE_TIP_CHACHE_KEY = "UNKONW_ATTFILE_TIP_CHACHE_KEY";

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        args.getFormShowParameter().setCustomParam("billopenfrom", (Object)"0");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperateOption option;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("viewflowchart".equals(operateKey)) {
            this.handleViewFlowChart(args);
        }
        if ((option = operate.getOption()) != null) {
            option.setVariableValue("BILL_LIST_OP", "BILL_LIST_OP_TRUE");
            BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)option);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        BillUnifyService.refreshListData((IFormView)this.getView(), (OperationResult)operationResult);
    }

    private void handleViewFlowChart(BeforeDoOperationEventArgs args) {
        Object source;
        FormOperate operate;
        String entityId;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] billDys;
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectRowIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(selectRowIds) && selectRowIds.size() > 1) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", selectRowIds);
        ListView view = (ListView)this.getView();
        Tuple tuple = BillUnifyService.opTargetBillForm((BeforeDoOperationEventArgs)args, (IListView)view, (DynamicObject[])(billDys = (serviceHelper = new HRBaseServiceHelper(entityId = (operate = (FormOperate)(source = args.getSource())).getEntityId())).loadDynamicObjectArray(new QFilter[]{qFilter})));
        if (((Boolean)tuple.getKey()).booleanValue()) {
            OperationResult operationResult = (OperationResult)tuple.getValue();
            if (operationResult != null && !operationResult.isSuccess()) {
                view.showOperationResult(operationResult);
            }
            args.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ArrayList orgFields = Lists.newArrayList((Object[])new String[]{"org", "org.id", "org.number", "org.name"});
        for (String orgField : orgFields) {
            CommonFilterColumn orgFilterColumn = (CommonFilterColumn)args.getFilterColumn(orgField);
            if (orgFilterColumn == null) continue;
            ListView listView = (ListView)this.getView();
            String billFormId = listView.getBillFormId();
            if ("wtpm_supsignselfquery".equals(billFormId)) {
                billFormId = "wtpm_supsignself";
            }
            String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin((IFormView)listView);
            long userHasPerOrgId = WTCBizDataPermissionServiceImpl.getInstance().getUserHasPerOrgId(billFormId, appId);
            orgFilterColumn.setDefaultValue(String.valueOf(userHasPerOrgId));
            super.filterContainerInit(args);
            break;
        }
    }

    public void setFilter(SetFilterEvent e) {
        Long userId = BillUnifyService.getUserId((IFormView)this.getView());
        if (Objects.nonNull(userId) && userId != 0L) {
            Tuple batchBillFilter;
            ArrayList<String> status = new ArrayList<String>(4);
            status.add("A");
            status.add("G");
            QFilter qFilter = new QFilter("personid", "=", (Object)userId);
            QFilter applytypeSelf = new QFilter("applytyperadio", "=", (Object)"0");
            QFilter applytypeOhter = new QFilter("applytyperadio", "=", (Object)BillApplyTypeEnum.OTHER.getCode()).and("billstatus", "not in", status);
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String billFormId = formShowParameter.getBillFormId();
            QFilter billFilter = applytypeSelf.or(applytypeOhter);
            if ("wtabm_vaapplyself".equals(billFormId) && (batchBillFilter = BatchBillUnifyService.getInstance().addBatchVaShowFilter(BatchBillUnifyService::batchVaIsShowInList, BatchBillUnifyService::batchVaShowBillStatus)) != null) {
                if (((Boolean)batchBillFilter.getValue()).booleanValue()) {
                    billFilter = billFilter.or((QFilter)batchBillFilter.getKey());
                } else {
                    e.addCustomQFilter((QFilter)batchBillFilter.getKey());
                }
            }
            e.addCustomQFilter(qFilter);
            e.addCustomQFilter(billFilter);
            QFilter excludeDepartFileFilter = BillCommonService.getInstance().getExcludeAttFileLevelFilter(this.getView(), userId, "attfile");
            e.addCustomQFilter(excludeDepartFileFilter);
        } else {
            QFilter qFilter = new QFilter("id", "=", (Object)-1);
            if (HRStringUtils.isBlank((CharSequence)this.getView().getPageCache().get(UNKONW_ATTFILE_TIP_CHACHE_KEY))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u672a\u5b8c\u6210\u5165\u804c\uff0c\u8bf7\u5148\u5b8c\u6210\u5165\u804c\u3002", (String)"WTCApplyTypeList_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                this.getView().getPageCache().put(UNKONW_ATTFILE_TIP_CHACHE_KEY, UNKONW_ATTFILE_TIP_CHACHE_KEY);
            }
            e.addCustomQFilter(qFilter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        BillOperationStatus billStatus = parameter.getBillStatus();
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus)) {
            Long userId = BillUnifyService.getUserId((IFormView)this.getView());
            if (Objects.nonNull(userId) && userId != 0L) {
                String propKey;
                String formId;
                String appNumber = this.getView().getFormShowParameter().getAppId();
                List top1IdList = BillUnifyService.getCurrUserAttFileTop1Ver((Long)userId, (String)appNumber, (String)(formId = parameter.getFormId()), (String)(propKey = "attfilebasef7"));
                if (!CollectionUtils.isEmpty((Collection)top1IdList)) {
                    Long attFileId = (Long)top1IdList.get(top1IdList.size() - 1);
                    parameter.setCustomParam("billopenfrom", this.getView().getFormShowParameter().getCustomParam("billopenfrom"));
                    this.showAddNewForm(parameter, "0", attFileId, userId, top1IdList);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u7ec4\u7ec7\u4e0b\u672a\u521b\u5efa\u8003\u52e4\u6863\u6848\uff0c\u8bf7\u5148\u521b\u5efa\u8003\u52e4\u6863\u6848\u3002", (String)"WTCApplyTypeSelfList_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u672a\u5b8c\u6210\u5165\u804c\uff0c\u8bf7\u5148\u5b8c\u6210\u5165\u804c\u3002", (String)"WTCApplyTypeList_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        } else {
            Object pkId = parameter.getPkId();
            if (pkId != null) {
                IListView view = (IListView)this.getView();
                parameter.setCustomParam("applytyperadio", (Object)"0");
                BillUnifyService.getBillListOpenFromId((IListView)view, (BillShowParameter)parameter, (int)0);
            }
        }
        parameter.setCustomParam("personid_cache", (Object)BillUnifyService.getUserId((IFormView)this.getView()));
    }

    @Deprecated
    public Long getUserId() {
        String userIdStr = this.getView().getPageCache().get("userId");
        if (HRStringUtils.isNotEmpty((String)userIdStr)) {
            return Long.parseLong(userIdStr);
        }
        Long userId = BillUnifyService.getUserId((IFormView)this.getView());
        if (userId != null) {
            this.getView().getPageCache().put("userId", userId.toString());
        }
        return userId;
    }

    private void showAddNewForm(BillShowParameter showParameter, String param, Long attfile, Long personId, List<Long> idList) {
        showParameter.setCustomParam("applytyperadio", (Object)param);
        showParameter.setCustomParam("attfilebasef7", (Object)attfile);
        showParameter.setCustomParam("personid", (Object)personId);
        List boids = AttFileF7Utils.batchQueryAttFileBoidByVid(Collections.singletonList(attfile));
        showParameter.setCustomParam("attfile", boids.get(0));
        showParameter.setCustomParam("idList", idList);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillUnifyService.handleHyperLinkViewFlowChar((IFormView)this.getView(), (HyperLinkClickArgs)args);
    }
}

