/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.SummaryServiceHelper;

public class WTCBaseBillControlPlugin
extends HRCoreBaseBillEdit {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        if (HRStringUtils.isNotEmpty((String)parentFormId) && (HRStringUtils.equals((String)parentFormId, (String)"wf_approvalpage_bac") || parentFormId.contains("wf_approval"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"auditpage"});
        }
        this.setSummary();
    }

    protected String setSummary() {
        String otApplyName = WtbsBusinessUtils.getMainEntityDisplayName((String)this.getView().getFormShowParameter().getFormId());
        return SummaryServiceHelper.showBillDetailSummary((IFormView)this.getView(), (String)otApplyName);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.containsProperty("billstatus")) {
            String billStatus = dataEntity.getString("billstatus");
            this.getPageCache().put("billstatus", billStatus);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String cacheBillStatus;
        String billStatus;
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (dataEntity.containsProperty("billstatus") && HRStringUtils.equals((String)(billStatus = dataEntity.getString("billstatus")), (String)(cacheBillStatus = this.getPageCache().get("billstatus")))) {
            return;
        }
        String summaryPageId = this.getView().getPageCache().get("summaryPageId");
        if (HRStringUtils.isNotEmpty((String)summaryPageId)) {
            IFormView summaryView = this.getView().getViewNoPlugin(summaryPageId);
            if (summaryView != null) {
                String billStatus2 = dataEntity.getString("billstatus");
                String billNo = dataEntity.getString("billno");
                SummaryServiceHelper.updateSummaryBillStatus((IFormView)summaryView, (String)billStatus2, (String)billNo);
                this.getView().sendFormAction(summaryView);
            }
        } else {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult != null && operationResult.isSuccess()) {
                this.setSummary();
            }
        }
    }
}

