/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.param.AppCustomParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.auth.HRAuthService;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.web.WTCBaseBillControlPlugin;

public class WTCBaseBillPlugin
extends WTCBaseBillControlPlugin {
    private static final Log LOG = LogFactory.getLog(WTCBaseBillPlugin.class);
    private boolean isChangeAttFileVersion = false;

    public void preOpenForm(PreOpenFormEventArgs ee) {
        super.preOpenForm(ee);
        FormShowParameter formShowParameter = ee.getFormShowParameter();
        if (formShowParameter instanceof BillShowParameter) {
            BillUnifyService.preOpenForm((BillShowParameter)((BillShowParameter)formShowParameter));
        }
        String authAppIdForFormPlugin = BillCommonService.getInstance().getAuthAppIdForFormPlugin(formShowParameter);
        if (WTCStringUtils.isEmpty((String)formShowParameter.getAppId())) {
            formShowParameter.setAppId(authAppIdForFormPlugin);
            formShowParameter.setCustomParam("checkRightAppId", (Object)authAppIdForFormPlugin);
            formShowParameter.setCustomParam("wtc_auto_add_app", (Object)true);
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        if (HRStringUtils.equals((String)"api", (String)RequestContext.get().getClient())) {
            return;
        }
        if (Boolean.TRUE.equals(this.getModel().getContextVariable("MODEL_INIT_BY_WEBAPI"))) {
            return;
        }
        Object org = this.getModel().getValue("org");
        if (org == null) {
            long orgId = 0L;
            String select_org_id = (String)this.getView().getFormShowParameter().getCustomParam("SELECT_ORG_ID");
            if (HRStringUtils.isNotEmpty((String)select_org_id)) {
                orgId = Long.parseLong(select_org_id);
            } else {
                String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView().getFormShowParameter());
                if (WTCStringUtils.isNotEmpty((String)appId)) {
                    try {
                        orgId = HRAuthService.getInstance().getUserHasPerOrgId(this.getView().getFormShowParameter().getFormId(), appId);
                    }
                    catch (Exception ex) {
                        LOG.warn("\u9ed8\u8ba4\u9009\u4e2dOrgId\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u4e0d\u8d4b\u503c\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7", (Throwable)ex);
                    }
                }
            }
            this.getModel().setValue("org", (Object)orgId);
        }
    }

    private boolean isAutoTip() {
        try {
            AppCustomParam param = new AppCustomParam();
            param.setAppId(AppMetadataCache.getAppInfo((String)"wtp").getId());
            param.setSearchKeySet((Set)Sets.newHashSet((Object[])new String[]{"kd_wtc_wtbs_autotip"}));
            Map paramMap = SystemParamServiceHelper.loadAppCustomParameterFromCache((AppCustomParam)param);
            if (paramMap == null || paramMap.get("kd_wtc_wtbs_autotip") == null) {
                return true;
            }
            String dutyDateBatch = (String)paramMap.get("kd_wtc_wtbs_autotip");
            return HRStringUtils.equals((String)"true", (String)dutyDateBatch);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Boolean autoAdd = (Boolean)formShowParameter.getCustomParam("wtc_auto_add_app");
        String checkRightAppId = formShowParameter.getCheckRightAppId();
        if (Boolean.TRUE.equals(autoAdd) && this.isAutoTip()) {
            String appName = ResManager.loadKDString((String)"\u65e5\u5e38\u8003\u52e4", (String)"WTCBaseBillPlugin_02", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_devportal_bizapp");
            DynamicObject dy = helper.queryOriginalOne("name", new QFilter[]{new QFilter("number", "=", (Object)checkRightAppId)});
            if (dy != null) {
                appName = dy.getString("name");
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6253\u5f00\u5355\u636e\u7f3a\u5c11\u5e94\u7528ID\uff0c\u5df2\u9ed8\u8ba4\u8bbe\u7f6e%1$s\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"WTCBaseBillPlugin_01", (String)"wtc-wtbs-formplugin", (Object[])new Object[]{appName}));
        }
        this.setPersonInfo();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String parentFormId = formShowParameter.getParentFormId();
        BillUnifyService.customBillButton((IFormView)this.getView());
        if (null != parentFormId && parentFormId.contains("wf_approval")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"auditpage"});
        }
        this.updateAttfileId();
    }

    private void updateAttfileId() {
        String billStatus = this.getModel().getDataEntity().getString("billstatus");
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus viewStatus = formShowParameter.getBillStatus();
        ArrayList billStatusNeeds = Lists.newArrayList((Object[])new String[]{"A", "G"});
        if (billStatusNeeds.contains(billStatus) && !viewStatus.equals((Object)BillOperationStatus.ADDNEW)) {
            Long attfileBo = this.getModel().getDataEntity(true).getLong("attfile.id");
            Long attfileId = this.getModel().getDataEntity(true).getLong("attfilebasef7.id");
            BillCommonService service = new BillCommonService();
            UnifyBillApplyAttr unifyBillApplyAttr = new UnifyBillApplyAttr();
            unifyBillApplyAttr.setAttFileF7AuthEntity(this.getView().getEntityId());
            unifyBillApplyAttr.setAttFileF7AuthAppId(BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
            unifyBillApplyAttr.setAttFileAuthField("attfilebasef7");
            DynamicObject attFileVersion = service.getAttFileBoTop1(attfileBo.longValue(), unifyBillApplyAttr);
            if (attFileVersion == null) {
                return;
            }
            Long newAttfile = attFileVersion.getLong("id");
            if (!newAttfile.equals(attfileId)) {
                this.getView().getPageCache().put("newAttfile", newAttfile.toString());
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("confirmUpdate", (IFormPlugin)this);
                String message = ResManager.loadKDString((String)"\u6700\u65b0\u6863\u6848\u7248\u672c\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u786e\u8ba4\u53d8\u66f4\u3002", (String)"WTCBaseBillPlugin_13", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OK, confirmCallBackListener);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String newAttfileStr = this.getView().getPageCache().get("newAttfile");
        Long newAttfile = Long.parseLong(newAttfileStr);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"confirmUpdate")) {
            this.isChangeAttFileVersion = true;
            this.getModel().setValue("attfilebasef7", (Object)newAttfile);
        }
    }

    private void setPersonInfo() {
        BillUnifyService.setPersonInfo((IFormView)this.getView());
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IDataEntityProperty billStatusEntityProperty;
        IDataEntityProperty iDataEntityProperty;
        DataEntityPropertyCollection properties;
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean applyTypeRadio = dataEntity.getBoolean("applytyperadio");
        if (!applyTypeRadio) {
            IDataEntityProperty attFileF7;
            DataEntityState dataEntityState = dataEntity.getDataEntityState();
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            properties = dataEntityType.getProperties();
            iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"org_id");
            if (iDataEntityProperty != null) {
                dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
            }
            if ((attFileF7 = (IDataEntityProperty)properties.get((Object)"attfilebasef7_id")) != null) {
                dataEntityState.setBizChanged(attFileF7.getOrdinal(), false);
            }
        }
        IDataEntityType dataEntityType = dataEntity.getDataEntityType();
        DataEntityState dataEntityState = dataEntity.getDataEntityState();
        properties = dataEntityType.getProperties();
        iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"applydate");
        if (iDataEntityProperty != null) {
            dataEntityState.setBizChanged(iDataEntityProperty.getOrdinal(), false);
        }
        if ((billStatusEntityProperty = (IDataEntityProperty)properties.get((Object)"billstatus")) != null) {
            dataEntityState.setBizChanged(billStatusEntityProperty.getOrdinal(), false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billStatus;
        String propertyName = e.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)"attfile") && !HRStringUtils.equals((String)"A", (String)(billStatus = this.getModel().getDataEntity(true).getString("billstatus")))) {
            this.getModel().setValue("billstatus", (Object)"A");
            this.getView().updateView("billstatus");
            super.setSummary();
        }
        if (HRStringUtils.equals((String)propertyName, (String)"attfilebasef7")) {
            AttachmentPanel attachmentPanel;
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("attfilebasef7");
            if (dynamicObject != null) {
                Long attFileVid = (Long)dynamicObject.getPkValue();
                List boids = AttFileF7Utils.batchQueryAttFileBoidByVid(Collections.singletonList(attFileVid));
                this.getModel().setValue("attfile", boids.get(0));
                this.setPersonInfo();
            }
            if ((attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel")) != null && !this.isChangeAttFileVersion) {
                List attachmentDataList = attachmentPanel.getAttachmentData();
                for (Map attachmentData : attachmentDataList) {
                    attachmentPanel.remove(attachmentData);
                }
            }
            String attFileChangeCount = this.getPageCache().get("attfilebasef7_changecount");
            int changeCount = 1;
            if (HRStringUtils.isNotEmpty((String)attFileChangeCount)) {
                changeCount = Integer.parseInt(attFileChangeCount) + 1;
            }
            this.getPageCache().put("attfilebasef7_changecount", String.valueOf(changeCount));
        }
    }

    public void registerListener(EventObject e) {
        super.addClickListeners(new String[]{"lab_selectperson"});
        super.addClickListeners(new String[]{"lab_changeperson"});
        super.addClickListeners(new String[]{"more"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billOpenForm = (String)formShowParameter.getCustomParam("billopenfrom");
        String appId = formShowParameter.getAppId();
        if ("1".equals(billOpenForm) && "wtam".equals(appId)) {
            String operationKey = evt.getOperationKey();
            String entityId = this.getView().getEntityId();
            Tuple tuple = BillUnifyService.checkBillRight((String)entityId, (String)operationKey, (IFormView)this.getView());
            if (!((Boolean)tuple.getKey()).booleanValue()) {
                this.getView().showErrorNotification((String)tuple.getValue());
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "lab_selectperson": 
            case "lab_changeperson": {
                BasedataEdit personAddEdit = (BasedataEdit)this.getView().getControl("attfilebasef7");
                personAddEdit.click();
                break;
            }
            case "more": {
                this.showForm();
                break;
            }
        }
    }

    private void showForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        formShowParameter.setFormId("wtp_leaderlist");
        ArrayList<JSONObject> infoList = new ArrayList<JSONObject>();
        String depStr = this.getView().getPageCache().get("showdepInfo");
        String superStr = this.getView().getPageCache().get("showSuperInfo");
        String caption = ResManager.loadKDString((String)"\u66f4\u591a\u4fe1\u606f", (String)"BillUnifyService_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
        if (!HRStringUtils.isEmpty((String)depStr) && !HRStringUtils.isEmpty((String)superStr)) {
            infoList.add(JSON.parseObject((String)superStr));
            infoList.add(JSON.parseObject((String)depStr));
        } else if (!HRStringUtils.isEmpty((String)superStr)) {
            caption = ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"BillUnifyService_0", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            infoList.add(JSON.parseObject((String)superStr));
        } else if (!HRStringUtils.isEmpty((String)depStr)) {
            caption = ResManager.loadKDString((String)"\u90e8\u95e8\u8d1f\u8d23\u4eba", (String)"BillUnifyService_1", (String)"wtc-wtbs-business", (Object[])new Object[0]);
            infoList.add(JSON.parseObject((String)depStr));
        }
        formShowParameter.setCaption(caption);
        formShowParameter.setCustomParam("allInfo", (Object)JSON.toJSONString(infoList));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        if (option != null) {
            BillUnifyService.setOptionUserId((IFormView)this.getView(), (OperateOption)operate.getOption());
            option.setVariableValue("checkRightAppId", BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView()));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            BillUnifyService.setBillFormStatus((IFormView)this.getView());
        }
    }
}

