/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class WTCBaseTipsList
extends HRDataBaseList {
    private static final String PROPERTIESNAME = "wtc-wtbs-formplugin";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!this.showResultForm(afterDoOperationEventArgs)) {
            return;
        }
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        this.showCustomOperErrorsForm(this.getFailList(operationResult), afterDoOperationEventArgs.getOperateKey(), this.selectDynamicObjects());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        boolean isSecond = Boolean.TRUE.toString().equals(operate.getOption().getVariableValue("isSecond", ""));
        if (isSecond) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "delete": {
                this.operateHandle(this.checkDelete(args), operateKey, args);
                break;
            }
            case "submit": {
                this.operateHandle(this.checkSubmit(args), operateKey, args);
                break;
            }
            case "unsubmit": {
                this.operateHandle(this.checkUnSubmit(args), operateKey, args);
                break;
            }
            case "audit": {
                this.operateHandle(this.checkAudit(args), operateKey, args);
                break;
            }
            case "unaudit": {
                this.operateHandle(this.checkUnAudit(args), operateKey, args);
                break;
            }
            case "disable": {
                this.operateHandle(this.checkDisableAndEnable(args, false), operateKey, args);
                break;
            }
            case "enable": {
                this.operateHandle(this.checkDisableAndEnable(args, true), operateKey, args);
                break;
            }
            default: {
                this.operateHandle(this.checkDefault(args), operateKey, args);
            }
        }
    }

    public boolean showResultForm(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        return true;
    }

    private void operateHandle(List<Map<String, String>> failList, String operateKey, BeforeDoOperationEventArgs args) {
        int selectedSize = this.getSelectedRows().size();
        if (!CollectionUtils.isEmpty(failList)) {
            if (selectedSize == failList.size()) {
                this.showCustomOperErrorsForm(failList, operateKey, this.selectDynamicObjects());
            } else {
                this.showCustomForm(failList, operateKey, this.getOperateName(operateKey));
            }
            args.setCancel(true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        Map returnData = (Map)e.getReturnData();
        if (returnData != null && "ok".equals(returnData.get("res"))) {
            if ("delete".equals(e.getActionId())) {
                DynamicObject[] selectDynamicObjects = this.selectDynamicObjects();
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)this.getView().getModel().getDataEntityType().getName(), (DynamicObject[])selectDynamicObjects, (OperateOption)OperateOption.create());
                this.showCustomOperErrorsForm(this.getFailList(operationResult), "delete", selectDynamicObjects);
                this.getView().invokeOperation("refresh");
            } else {
                OperateOption op = OperateOption.create();
                op.setVariableValue("isSecond", Boolean.TRUE.toString());
                this.getView().invokeOperation(e.getActionId(), op);
            }
        }
    }

    public List<Map<String, String>> checkDelete(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkAudit(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkUnAudit(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkSubmit(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkUnSubmit(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkDisableAndEnable(BeforeDoOperationEventArgs args, boolean isEnable) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> checkDefault(BeforeDoOperationEventArgs args) {
        return Collections.emptyList();
    }

    public List<Map<String, String>> getFailList(OperationResult operationResult) {
        DynamicObject[] dynamicObjects;
        if (operationResult == null) {
            return new ArrayList<Map<String, String>>();
        }
        List validateResults = operationResult.getAllErrorOrValidateInfo();
        HashMap map = Maps.newHashMapWithExpectedSize((int)validateResults.size());
        for (IOperateInfo operateErrorInfo : validateResults) {
            HashMap temp = Maps.newHashMapWithExpectedSize((int)4);
            temp.put("message", operateErrorInfo.getMessage());
            map.put(String.valueOf(operateErrorInfo.getPkValue()), temp);
        }
        for (DynamicObject dynamicObject : dynamicObjects = this.selectDynamicObjects()) {
            String key = dynamicObject.getString("id");
            Map temp = (Map)map.get(key);
            if (temp == null) continue;
            temp.put("number", dynamicObject.getString("number"));
            temp.put("name", dynamicObject.getString("name"));
        }
        return new ArrayList<Map<String, String>>(map.values());
    }

    protected DynamicObject[] selectDynamicObjects() {
        IListView view = null;
        IFormView iFormView = this.getView();
        if (iFormView instanceof IListView) {
            view = (IListView)iFormView;
        } else {
            view = (IListView)this.getView().getParentView();
            if (view == null) {
                return new DynamicObject[0];
            }
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        return new HRBaseServiceHelper(view.getBillFormId()).loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    protected void showCustomForm(List<Map<String, String>> failList, String operatetype, String operateName) {
        ArrayList successList = new ArrayList();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<String> failNumbers = new ArrayList<String>(failList.size());
        for (Map<String, String> fail : failList) {
            failNumbers.add(fail.get("number"));
        }
        for (ListSelectedRow listSelectedRow : selectedRows) {
            if (failNumbers.contains(listSelectedRow.getNumber())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", listSelectedRow.getNumber());
            map.put("name", listSelectedRow.getName());
            successList.add(map);
        }
        int selectSize = selectedRows.size();
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtc_operconfirm");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setShowTitle(false);
        parameters.setCustomParam("operatename", (Object)operateName);
        parameters.setCustomParam("allnum", (Object)String.valueOf(selectSize));
        parameters.setCustomParam("oknum", (Object)String.valueOf(successList.size()));
        parameters.setCustomParam("failnum", (Object)String.valueOf(failList.size()));
        parameters.setCustomParam("failList", failList);
        parameters.setCustomParam("successList", successList);
        parameters.setCustomParam("operatetype", (Object)operateName);
        parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operatetype));
        this.getView().showForm(parameters);
    }

    public ListSelectedRowCollection getSelectedRows() {
        IListView view = null;
        IFormView iFormView = this.getView();
        view = iFormView instanceof IListView ? (IListView)iFormView : (IListView)this.getView().getParentView();
        return view.getSelectedRows();
    }

    public void showCustomOperErrorsForm(List<Map<String, String>> failList, String operatetype, DynamicObject[] selectDynamicObjects) {
        ArrayList successList = new ArrayList();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        int selectSize = selectedRows.size();
        int failSize = failList.size();
        if (selectSize == 1 && failSize == 1) {
            this.getView().showErrorNotification(WTCCollectionIndexUtil.getEleFromList(failList, (int)0).isPresent() ? (String)((Map)WTCCollectionIndexUtil.getEleFromList(failList, (int)0).get()).get("message") : null);
            return;
        }
        if (selectSize == 1 && failSize == 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"WTCBaseTipsList_0", (String)PROPERTIESNAME, (Object[])new Object[0]), this.getOperateName(operatetype)));
            return;
        }
        if (selectSize > 1 && failSize == 0) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f%1$s%2$s\u6761\u6570\u636e\u3002", (String)"WTCBaseTipsList_1", (String)PROPERTIESNAME, (Object[])new Object[0]), this.getOperateName(operatetype), selectSize));
            return;
        }
        ArrayList<String> failNumbers = new ArrayList<String>(failList.size());
        for (Map<String, String> fail : failList) {
            failNumbers.add(fail.get("number"));
        }
        for (DynamicObject dynamicObject : selectDynamicObjects) {
            if (failNumbers.contains(dynamicObject.getString("number"))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("number", dynamicObject.getString("number"));
            map.put("name", dynamicObject.getString("name"));
            successList.add(map);
        }
        FormShowParameter parameters = new FormShowParameter();
        parameters.setFormId("wtc_operationresult");
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setShowTitle(false);
        parameters.setCustomParam("operatename", (Object)this.getOperateName(operatetype));
        parameters.setCustomParam("allnum", (Object)String.valueOf(selectSize));
        parameters.setCustomParam("failnum", (Object)String.valueOf(failSize));
        parameters.setCustomParam("oknum", (Object)String.valueOf(successList.size()));
        parameters.setCustomParam("failList", failList);
        parameters.setCustomParam("successList", successList);
        parameters.setCustomParam("operatetype", (Object)operatetype);
        this.getView().showForm(parameters);
    }

    public String getOperateName(String operateKey) {
        String operateName = "";
        switch (operateKey) {
            case "delete": {
                operateName = ResManager.loadKDString((String)"\u5220\u9664", (String)"WTCBaseTipsList_2", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "submit": {
                operateName = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"WTCBaseTipsList_3", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                operateName = ResManager.loadKDString((String)"\u64a4\u9500", (String)"WTCBaseTipsList_4", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "audit": {
                operateName = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"WTCBaseTipsList_5", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                operateName = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"WTCBaseTipsList_6", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "disable": {
                operateName = ResManager.loadKDString((String)"\u7981\u7528", (String)"WTCBaseTipsList_7", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            case "enable": {
                operateName = ResManager.loadKDString((String)"\u542f\u7528", (String)"WTCBaseTipsList_8", (String)PROPERTIESNAME, (Object[])new Object[0]);
                break;
            }
            default: {
                operateName = ResManager.loadKDString((String)"\u6267\u884c", (String)"WTCBaseTipsList_9", (String)PROPERTIESNAME, (Object[])new Object[0]);
            }
        }
        return operateName;
    }
}

