/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.EventObject;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.wtc.wtbs.common.enums.ConfirmDlgTypeEnum;

public class WTCConfirmDlgPlugin
extends AbstractFormPlugin {
    private static final String KEY_OK = "btnok";
    private static final String KEY_CANCEL = "btncancel";
    private static final String KEY_YES = "btnyes";
    private static final String KEY_NO = "btnno";
    private static final String KEY_INSERT = "btninsert";
    private static final String KEY_ABANDON = "btnabandon";
    private static final String KEY_COVER = "btncover";
    private static final String KEY_MESSAGE = "message";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_OK, KEY_CANCEL, KEY_YES, KEY_NO, KEY_INSERT, KEY_ABANDON, KEY_COVER});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String message = (String)this.getView().getFormShowParameter().getCustomParam(KEY_MESSAGE);
        Object confirmTypeObj = this.getView().getFormShowParameter().getCustomParam("confirmType");
        if (confirmTypeObj == null) {
            this.toggleBtn(ConfirmDlgTypeEnum.OK_CANCEL);
        } else {
            this.toggleBtn(ConfirmDlgTypeEnum.valueOf((String)confirmTypeObj.toString()));
        }
        Label messageLabel = (Label)this.getControl(KEY_MESSAGE);
        messageLabel.setText(message);
    }

    private void toggleBtn(ConfirmDlgTypeEnum dlgType) {
        switch (dlgType) {
            case YES_NO: {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_YES, KEY_NO});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OK, KEY_CANCEL, KEY_INSERT, KEY_ABANDON, KEY_COVER});
                break;
            }
            case INSERT_ABANDON_CANCEL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_INSERT, KEY_ABANDON, KEY_CANCEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_YES, KEY_NO, KEY_OK, KEY_COVER});
                break;
            }
            case YES_NO_CANCEL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_YES, KEY_NO, KEY_CANCEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_OK, KEY_INSERT, KEY_ABANDON, KEY_COVER});
                break;
            }
            case INSERT_COVER_CANCEL: {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_INSERT, KEY_COVER, KEY_CANCEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_YES, KEY_NO, KEY_OK, KEY_ABANDON});
                break;
            }
            default: {
                this.getView().setVisible(Boolean.TRUE, new String[]{KEY_OK, KEY_CANCEL});
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_YES, KEY_NO, KEY_INSERT, KEY_ABANDON, KEY_COVER});
            }
        }
    }

    public void click(EventObject evt) {
        String result;
        String key;
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "btnok": 
            case "btnyes": {
                result = "Yes";
                break;
            }
            case "btnabandon": {
                result = "Abandon";
                break;
            }
            case "btncover": {
                result = "Cover";
                break;
            }
            case "btnno": {
                result = "No";
                break;
            }
            case "btninsert": {
                result = "Insert";
                break;
            }
            default: {
                result = null;
            }
        }
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }
}

