/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;

public class WTCDateRangeEdit
extends HRDataBaseEdit {
    private static final Log logger = LogFactory.getLog(WTCDateRangeEdit.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
    private static final String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();

    public void afterBindData(EventObject e) {
        String hisAction;
        BillShowParameter showParameter;
        String childpageId = this.getPageCache().get("childpageId");
        if (childpageId != null) {
            return;
        }
        String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
        Long basedataid = (Long)this.getModel().getDataEntity().getPkValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        if (basedataid == null || basedataid == 0L) {
            basedataid = this.getModel().getDataEntity().getLong("boid");
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isCopy = (Boolean)customParams.get("iscopy");
        String option = (String)customParams.get("option");
        if (isCopy != null && isCopy.booleanValue() && !HRStringUtils.equals((String)"insertdata_his", (String)option) && (showParameter = (BillShowParameter)this.getView().getFormShowParameter()).getPkId() != null && (Long)showParameter.getPkId() != 0L) {
            basedataid = (Long)showParameter.getPkId();
        }
        if (HRStringUtils.equals((String)"open_insert_new_data_page", (String)(hisAction = (String)customParams.get("his_action")))) {
            basedataid = 0L;
        }
        formShowParameter.setStatus(this.getFormStatus());
        DynamicObject dynamicObject = null;
        if (basedataid != null && basedataid != 0L) {
            dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", (Object)basedataid)});
        }
        formShowParameter.setFormId("wtbd_daterangeform");
        formShowParameter.getOpenStyle().setTargetKey("daterangeflex");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        this.getView().showForm(formShowParameter);
        String pageId = formShowParameter.getPageId();
        this.getPageCache().put("childpageId", pageId);
        if (dynamicObject != null) {
            this.getTargetCondition().setValue(dynamicObject.getString("conditions"));
        }
    }

    private TargetCondition getTargetCondition() {
        String pageId = this.getPageCache().get("childpageId");
        return (TargetCondition)this.getView().getView(pageId).getControl("targetconditionap");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof AbstractOperate) {
            String operateKey;
            AbstractOperate op = (AbstractOperate)evt.getSource();
            switch (operateKey = op.getOperateKey()) {
                case "save": 
                case "submit": 
                case "audit": 
                case "submitandaudit": 
                case "confirmchange": 
                case "confirmchangenoaudit": {
                    String conditionJson = this.getTargetCondition().getValue();
                    WTCDateRangeEdit.validCondition(this.getView(), evt, conditionJson);
                }
            }
        }
    }

    private static Boolean getAppParam() {
        AppParam appParam = new AppParam(appId, Long.valueOf(SystemParamQueryUtil.getWTCRootOrg()));
        Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Boolean inShiftOt = (Boolean)params.get("inshiftot");
        return inShiftOt;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String pageId;
        String operateKey = args.getOperateKey();
        if (HRStringUtils.equals((String)"new", (String)operateKey)) {
            this.getTargetCondition().clearAll();
            pageId = this.getPageCache().get("childpageId");
            IFormView view = this.getView().getView(pageId);
            this.getView().sendFormAction(view);
            this.getView().updateView(pageId);
        }
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": 
                case "submit": 
                case "audit": 
                case "submitandaudit": 
                case "confirmchange": 
                case "confirmchangenoaudit": {
                    String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
                    Object basedataid = this.getModel().getDataEntity().getPkValue();
                    String dataJson = this.getTargetCondition().getValue();
                    DynamicObject dynamicObject = serviceHelper.queryOne("conditions,metanumber,basedataid", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", basedataid)});
                    if (Objects.nonNull(dynamicObject)) {
                        dynamicObject.set("conditions", (Object)dataJson);
                    } else {
                        MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                        dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                        dynamicObject.set("metanumber", (Object)metanumber);
                        dynamicObject.set("basedataid", basedataid);
                        dynamicObject.set("conditions", (Object)dataJson);
                    }
                    serviceHelper.saveOne(dynamicObject);
                    this.updateBoData();
                    break;
                }
                case "his_disable": 
                case "enable": {
                    String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
                    Object basedataid = this.getModel().getDataEntity().getPkValue();
                    String dataJson = this.getTargetCondition().getValue();
                    HRBaseServiceHelper thisService = new HRBaseServiceHelper(metanumber);
                    DynamicObject thisDy = thisService.queryOne("sourcevid", new QFilter("id", "=", basedataid));
                    MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                    DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                    dynamicObject.set("metanumber", (Object)metanumber);
                    dynamicObject.set("basedataid", (Object)thisDy.getLong("sourcevid"));
                    dynamicObject.set("conditions", (Object)dataJson);
                    serviceHelper.saveOne(dynamicObject);
                }
            }
            pageId = this.getPageCache().get("childpageId");
            IFormView view = this.getView().getView(pageId);
            view.setStatus(this.getFormStatus(operateKey));
            this.setFormStatus(this.getFormStatus(operateKey).getValue());
            this.getView().sendFormAction(view);
            this.getView().updateView(pageId);
        }
    }

    private void setFormStatus(int status) {
        TargetCondition targetCondition = this.getTargetCondition();
        if (this.isLock(status, targetCondition.getLock())) {
            targetCondition.setPageState("VIEW");
        } else {
            targetCondition.setPageState("EDIT");
        }
    }

    private boolean isLock(int status, String lock) {
        if (StringUtils.isEmpty((String)lock)) {
            return false;
        }
        return BillOperationStatus.ADDNEW.getValue() == status && lock.contains("new") || BillOperationStatus.EDIT.getValue() == status && lock.contains("edit") || BillOperationStatus.VIEW.getValue() == status && lock.contains("view") || BillOperationStatus.SUBMIT.getValue() == status && lock.contains("submit") || BillOperationStatus.AUDIT.getValue() == status && lock.contains("audit");
    }

    private void updateBoData() {
        if (!Objects.equals(this.getModel().getDataEntity().getPkValue(), this.getModel().getDataEntity().get("boid"))) {
            HRBaseServiceHelper serviceHelper;
            DynamicObject sourceDy;
            Date bsed = this.getModel().getDataEntity().getDate("bsed");
            Date bsled = this.getModel().getDataEntity().getDate("bsled");
            Date currentDate = new Date();
            String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
            Long basedataid = this.getModel().getDataEntity().getLong("boid");
            String dataJson = this.getTargetCondition().getValue();
            if (bsed.compareTo(currentDate) <= 0 && bsled.compareTo(currentDate) >= 0) {
                DynamicObject dynamicObject = WTCDateRangeEdit.serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", (Object)basedataid)});
                dynamicObject.set("conditions", (Object)dataJson);
                WTCDateRangeEdit.serviceHelper.updateOne(dynamicObject);
            }
            if (Objects.nonNull(sourceDy = (serviceHelper = new HRBaseServiceHelper(metanumber)).queryOne("id", new QFilter[]{new QFilter("hisversion", ">", this.getModel().getDataEntity().get("hisversion")), new QFilter("boid", "=", (Object)basedataid)}))) {
                MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                dynamicObject.set("metanumber", (Object)metanumber);
                dynamicObject.set("basedataid", sourceDy.getPkValue());
                dynamicObject.set("conditions", (Object)dataJson);
                serviceHelper.saveOne(dynamicObject);
            }
        } else {
            long sourcevid = this.getModel().getDataEntity().getLong("sourcevid");
            if (sourcevid != 0L) {
                String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
                String dataJson = this.getTargetCondition().getValue();
                DynamicObject dynamicObject = serviceHelper.queryOne("conditions,metanumber,basedataid", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", (Object)sourcevid)});
                if (Objects.nonNull(dynamicObject)) {
                    dynamicObject.set("conditions", (Object)dataJson);
                } else {
                    MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                    dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                    dynamicObject.set("metanumber", (Object)metanumber);
                    dynamicObject.set("basedataid", (Object)sourcevid);
                    dynamicObject.set("conditions", (Object)dataJson);
                }
                serviceHelper.saveOne(dynamicObject);
            }
        }
    }

    public static boolean validCondition(IFormView view, BeforeDoOperationEventArgs args, String conditionJson) {
        if (HRStringUtils.isNotEmpty((String)conditionJson) && conditionJson.contains("is_or_isSub")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"WTCSimpleDateRangeEdit_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson);
        WTCDateRangeEdit.validConditions(view, conditionJson, args);
        return WTCDateRangeEdit.showErrorNotification(view, args, info);
    }

    private static void validConditions(IFormView view, String conditionJson, BeforeDoOperationEventArgs args) {
        if (HRStringUtils.isNotEmpty((String)conditionJson) && conditionJson.contains("datetypepattern")) {
            AccessDto accessDto = null;
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
            }
            catch (Exception e) {
                logger.error("JsonProcessingException:", (Throwable)e);
            }
            if (accessDto == null) {
                return;
            }
            List conditionList = accessDto.getConditionList();
            if (conditionList == null) {
                return;
            }
            int count = 0;
            for (ConditionDto dto : conditionList) {
                if (!HRStringUtils.isNotEmpty((String)dto.getParam()) || !dto.getParam().contains("datetypepattern")) continue;
                ++count;
                if (dto.getOperators().equals("==")) continue;
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u4ec5\u652f\u6301\u8fd0\u7b97\u7b26:\u201c\u7b49\u4e8e\u201d\u3002", (String)"WTCDateRangeEdit_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            }
            if (count > 1) {
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528\u6761\u4ef6\uff1a\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u3002", (String)"WTCDateRangeEdit_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info) {
        if (!info.isSuccess()) {
            List msgList = info.getMsgList();
            if (args != null) {
                args.setCancel(true);
                if (msgList.contains(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u90e8\u5206", (String)"WTCDateRangeEdit_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]))) {
                    msgList.clear();
                    msgList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4", (String)"WTCDateRangeEdit_4", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    args.setCancelMessage(String.join((CharSequence)",", msgList));
                }
            }
            view.showTipNotification(String.join((CharSequence)",", msgList));
        }
        return info.isSuccess();
    }

    private OperationStatus getFormStatus() {
        OperationStatus i;
        String status = this.getModel().getDataEntity().getString("status");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParams().get("fromPage");
        String hisAction = (String)this.getView().getFormShowParameter().getCustomParams().get("his_action");
        switch (status) {
            case "A": {
                i = OperationStatus.EDIT;
                break;
            }
            case "B": {
                i = OperationStatus.VIEW;
                break;
            }
            case "C": {
                i = OperationStatus.VIEW;
                break;
            }
            default: {
                i = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise") || HRStringUtils.equals((String)hisAction, (String)"open_insert_data_page")) {
            i = OperationStatus.EDIT;
        }
        return i;
    }

    private OperationStatus getFormStatus(String operation) {
        OperationStatus i;
        String status = this.getModel().getDataEntity().getString("status");
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParams().get("fromPage");
        switch (status) {
            case "A": {
                i = OperationStatus.EDIT;
                break;
            }
            case "B": {
                i = OperationStatus.VIEW;
                break;
            }
            case "C": {
                i = OperationStatus.VIEW;
                break;
            }
            default: {
                i = OperationStatus.ADDNEW;
            }
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            i = OperationStatus.EDIT;
        }
        if (HRStringUtils.equals((String)fromPage, (String)"revise") && operation.equals("save")) {
            i = OperationStatus.VIEW;
        }
        return i;
    }
}

