/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;

public class WTCDateRangeList
extends HRDataBaseList {
    private static final Log logger = LogFactory.getLog(WTCDateRangeList.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(args.getOperationResult())) {
            switch (operateKey) {
                case "audit": 
                case "his_disable": 
                case "enable": {
                    List idSet = args.getOperationResult().getSuccessPkIds();
                    ListView view = (ListView)this.getView();
                    String metanumber = view.getBillFormId();
                    HRBaseServiceHelper currentService = new HRBaseServiceHelper(metanumber);
                    DynamicObject[] dynamicObjects = currentService.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", (Object)idSet)});
                    if (dynamicObjects == null || dynamicObjects.length == 0) {
                        return;
                    }
                    Set iscurrentversionIds = Arrays.stream(dynamicObjects).filter(e -> e.getBoolean("iscurrentversion")).map(e -> (Long)e.getPkValue()).collect(Collectors.toSet());
                    Map<Long, Long> map = Arrays.stream(dynamicObjects).filter(e -> e.getBoolean("iscurrentversion")).collect(Collectors.toMap(e -> e.getLong("boid"), e -> e.getLong("sourcevid"), (key, value) -> value));
                    DynamicObject[] targetConditions = serviceHelper.query("conditions,metanumber,basedataid", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "in", iscurrentversionIds)});
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    MainEntityType metaTyp = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                    for (DynamicObject dynamicObject : targetConditions) {
                        Long boid = dynamicObject.getLong("basedataid");
                        DynamicObject targetCondition = new DynamicObject((DynamicObjectType)metaTyp);
                        targetCondition.set("metanumber", (Object)metanumber);
                        targetCondition.set("basedataid", (Object)map.get(boid));
                        targetCondition.set("conditions", (Object)dynamicObject.getString("conditions"));
                        collection.add((Object)targetCondition);
                    }
                    serviceHelper.save(collection);
                    break;
                }
                case "confirmchange": {
                    List idSet = args.getOperationResult().getSuccessPkIds();
                    ListView view = (ListView)this.getView();
                    String metanumber = view.getBillFormId();
                    HRBaseServiceHelper currentService = new HRBaseServiceHelper(metanumber);
                    DynamicObject[] dynamicObjects = currentService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)idSet)});
                    if (dynamicObjects == null || dynamicObjects.length == 0) {
                        return;
                    }
                    String maxhisversion = Arrays.stream(dynamicObjects).map(e -> e.getString("hisversion")).max(String::compareTo).get();
                    String minhisversion = Arrays.stream(dynamicObjects).map(e -> e.getString("hisversion")).min(String::compareTo).get();
                    Long boid = Arrays.stream(dynamicObjects).map(e -> e.getLong("boid")).max(Long::compareTo).get();
                    DynamicObject[] sourceDys = currentService.query("id,hisversion", new QFilter[]{new QFilter("hisversion", "<", (Object)minhisversion), WTCHisServiceHelper.dataStatusValidQFilter(), new QFilter("boid", "=", (Object)boid)});
                    String maxSourceVersion = Arrays.stream(sourceDys).map(e -> e.getString("hisversion")).max(String::compareTo).get();
                    Optional<DynamicObject> hisversion = Arrays.stream(sourceDys).filter(e -> e.getString("hisversion").equals(maxSourceVersion)).findFirst();
                    DynamicObject sourceDy = hisversion.get();
                    if (sourceDy == null) break;
                    DynamicObject dy = serviceHelper.queryOne("conditions", new QFilter("basedataid", "=", sourceDy.getPkValue()));
                    DynamicObject[] currentDys = currentService.query("id", new QFilter[]{new QFilter("hisversion", ">", (Object)maxhisversion), new QFilter("boid", "=", (Object)boid)});
                    if (!Objects.nonNull(currentDys)) break;
                    MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                    DynamicObjectCollection collection = new DynamicObjectCollection();
                    for (DynamicObject currentDy : currentDys) {
                        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                        dynamicObject.set("metanumber", (Object)metanumber);
                        dynamicObject.set("basedataid", currentDy.getPkValue());
                        dynamicObject.set("conditions", (Object)dy.getString("conditions"));
                        collection.add((Object)dynamicObject);
                    }
                    serviceHelper.save(collection);
                }
            }
        }
    }
}

