/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.hr.ruleengine.controls.TargetCondition;
import kd.bos.ext.hr.ruleengine.infos.RuleValidateInfo;
import kd.bos.ext.hr.ruleengine.utils.RuleValidateUtil;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;

public class WTCDateRangeNohisEdit
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(WTCDateRangeNohisEdit.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbd_daterange");
    private static final String appId = AppMetadataCache.getAppInfo((String)"wtp").getId();

    public void afterBindData(EventObject e) {
        OperationStatus status;
        if (Objects.isNull(this.getPageCache().get("childpageId"))) {
            DynamicObject dynamicObject;
            String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
            formShowParameter.setFormId("wtbd_daterangeform");
            formShowParameter.getOpenStyle().setTargetKey("daterangeflex");
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            this.getView().showForm(formShowParameter);
            String pageId = formShowParameter.getPageId();
            this.getPageCache().put("childpageId", pageId);
            Long basedataid = this.getModel().getDataEntity().getLong("basedataid");
            if (basedataid != 0L && Objects.nonNull(dynamicObject = serviceHelper.queryOne("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", (Object)basedataid)}))) {
                this.getTargetCondition().setValue(dynamicObject.getString("conditions"));
            }
        }
        if ((status = this.getView().getFormShowParameter().getStatus()).equals((Object)OperationStatus.ADDNEW)) {
            this.getModel().setValue("basedataid", (Object)ID.genLongId());
        }
    }

    private TargetCondition getTargetCondition() {
        String pageId = this.getPageCache().get("childpageId");
        return (TargetCondition)this.getView().getView(pageId).getControl("targetconditionap");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.getSource() instanceof AbstractOperate) {
            String operateKey;
            AbstractOperate op = (AbstractOperate)evt.getSource();
            switch (operateKey = op.getOperateKey()) {
                case "save": 
                case "submit": 
                case "submitandaudit": {
                    String conditionJson = this.getTargetCondition().getValue();
                    WTCDateRangeNohisEdit.validCondition(this.getView(), evt, conditionJson);
                    WTCDateRangeNohisEdit.validSection(this.getView(), evt, conditionJson);
                }
            }
        }
    }

    private static void validSection(IFormView view, BeforeDoOperationEventArgs evt, String conditionJson) {
        List conditions;
        DateRangeServiceImpl dateRangeService;
        Boolean contentDateRange;
        List paramList = (List)view.getFormShowParameter().getCustomParam("paramList");
        String metaNumber = view.getModel().getDataEntity().getDataEntityType().getName();
        DynamicObject[] dynamicObjects = serviceHelper.query("conditions", new QFilter[]{new QFilter("metanumber", "=", (Object)metaNumber), new QFilter("basedataid", "in", (Object)paramList)});
        if (dynamicObjects != null && dynamicObjects.length != 0 && (contentDateRange = (dateRangeService = new DateRangeServiceImpl()).isContentDateRange(conditions = Arrays.stream(dynamicObjects).map(e -> e.getString("conditions")).collect(Collectors.toList()), conditionJson)).booleanValue()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u65e5\u671f\u8303\u56f4\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u3002", (String)"WTCDateRangeNohisEdit_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private static Boolean getAppParam() {
        AppParam appParam = new AppParam(appId, Long.valueOf(SystemParamQueryUtil.getWTCRootOrg()));
        Map params = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Boolean inShiftOt = (Boolean)params.get("inshiftot");
        return inShiftOt;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if (Objects.nonNull(args.getOperationResult()) && args.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "save": 
                case "submit": 
                case "submitandaudit": {
                    String metanumber = this.getModel().getDataEntity().getDataEntityType().getName();
                    Long basedataid = this.getModel().getDataEntity().getLong("basedataid");
                    String dataJson = this.getTargetCondition().getValue();
                    DynamicObject dynamicObject = serviceHelper.queryOne("conditions,metanumber,basedataid", new QFilter[]{new QFilter("metanumber", "=", (Object)metanumber), new QFilter("basedataid", "=", (Object)basedataid)});
                    if (Objects.nonNull(dynamicObject)) {
                        dynamicObject.set("conditions", (Object)dataJson);
                    } else {
                        MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
                        dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                        dynamicObject.set("metanumber", (Object)metanumber);
                        dynamicObject.set("basedataid", (Object)basedataid);
                        dynamicObject.set("conditions", (Object)dataJson);
                    }
                    serviceHelper.saveOne(dynamicObject);
                }
            }
        }
    }

    public static boolean validCondition(IFormView view, BeforeDoOperationEventArgs args, String conditionJson) {
        RuleValidateInfo info = RuleValidateUtil.validCondition((String)conditionJson);
        WTCDateRangeNohisEdit.validConditions(view, conditionJson, args);
        return WTCDateRangeNohisEdit.showErrorNotification(view, args, info);
    }

    private static void validConditions(IFormView view, String conditionJson, BeforeDoOperationEventArgs args) {
        Boolean inShiftOt = WTCDateRangeNohisEdit.getAppParam();
        if (HRStringUtils.isNotEmpty((String)conditionJson) && conditionJson.contains("is_or_isSub")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u6682\u4e0d\u652f\u6301\u201c\u7b49\u4e8e/...\u7684\u4e0b\u7ea7\u201d\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u9009\u9879\u3002", (String)"WTCSimpleDateRangeEdit_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (HRStringUtils.isNotEmpty((String)conditionJson) && (conditionJson.contains("datetypepattern") || conditionJson.contains("shifttimebucketproperty") && !inShiftOt.booleanValue())) {
            AccessDto accessDto = new AccessDto();
            try {
                accessDto = (AccessDto)SerializationUtils.fromJsonString((String)conditionJson, AccessDto.class);
            }
            catch (Exception exception) {
                logger.error("JsonProcessingException", (Throwable)exception);
            }
            List conditionList = accessDto.getConditionList();
            int count = 0;
            for (ConditionDto dto : conditionList) {
                if (!HRStringUtils.isNotEmpty((String)dto.getParam()) || !dto.getParam().contains("datetypepattern")) continue;
                ++count;
                if (dto.getOperators().equals("==")) continue;
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u4ec5\u652f\u6301\u8fd0\u7b97\u7b26:\u201c\u7b49\u4e8e\u201d\u3002", (String)"WTCDateRangeNohisEdit_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            }
            if (count > 1) {
                args.setCancel(true);
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528\u6761\u4ef6\uff1a\u201c\u65e5\u671f\u7c7b\u578b\u65f6\u6bb5\u201d\u3002", (String)"WTCDateRangeNohisEdit_3", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static boolean showErrorNotification(IFormView view, BeforeDoOperationEventArgs args, RuleValidateInfo info) {
        if (!info.isSuccess()) {
            List msgList = info.getMsgList();
            if (args != null) {
                args.setCancel(true);
                if (msgList.contains(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6\u90e8\u5206", (String)"WTCDateRangeNohisEdit_4", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]))) {
                    msgList.clear();
                    msgList.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u8303\u56f4", (String)"WTCDateRangeNohisEdit_5", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    args.setCancelMessage(String.join((CharSequence)",", msgList));
                }
            }
            String daterange = ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4:", (String)"OverWorkRuleEdit_7", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]);
            view.showTipNotification(daterange + String.join((CharSequence)",", msgList));
        }
        return info.isSuccess();
    }
}

