/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.SummaryServiceHelper;
import kd.wtc.wtbs.common.constants.WTCCommonConstants;

public class WTCSnapPlugin
extends HRDataBaseEdit {
    private static final String BAR_EDIT = "bar_modify";
    private static final String BAR_VIEW_HIS = "bar_viewhis";

    public void beforeBindData(EventObject e) {
        this.showSummary();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)BAR_VIEW_HIS, (CharSequence)evt.getItemKey())) {
            String hisName = this.getModel().getDataEntityType().getName() + "his";
            long id = this.getModel().getDataEntity().getLong("id");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setFormId("bos_list");
            listShowParameter.setBillFormId(hisName);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            listShowParameter.setShowTitle(false);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(new QFilter("bo", "=", (Object)id));
            listShowParameter.setListFilterParameter(listFilterParameter);
            listShowParameter.setMultiSelect(true);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initViewEnable();
        this.getModel().setDataChanged(false);
    }

    private void showSummary() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus == OperationStatus.ADDNEW) {
            SummaryServiceHelper.showAddSummary((IFormView)this.getView(), (String)this.getAddSummaryName());
        } else {
            SummaryServiceHelper.showViewDetailSummary((IFormView)this.getView(), (String)this.getModel().getDataEntity().getString("name"));
        }
    }

    protected String getAddSummaryName() {
        return WtbsBusinessUtils.getMainEntityDisplayName((String)this.getView().getFormShowParameter().getFormId());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && WTCCommonConstants.opList.contains(operateKey)) {
            this.showSummary();
        }
    }

    public void setTagStatus() {
        String status = this.getModel().getDataEntity().getString("status");
        String enable = this.getModel().getDataEntity().getString("enable");
        WTCSnapService.setStatusLabel((String)status, (IFormView)this.getView(), (String)"statusstr");
        WTCSnapService.setEnableLabel((String)enable, (IFormView)this.getView(), (String)"enablestr");
    }

    public void setNameStr() {
        Control control;
        String name = this.getModel().getDataEntity().getString("name");
        if (name != null && (control = this.getView().getControl("namestr")) != null) {
            Label label = (Label)control;
            label.setText(name);
        }
    }

    public void setTagCreatorInfo() {
        Control control;
        String creator = this.getModel().getDataEntity().getString("creator.name");
        if (creator != null && (control = this.getView().getControl("creatorstr")) != null) {
            Label label = (Label)control;
            label.setText(creator);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date createTime = this.getModel().getDataEntity().getDate("createtime");
        if (creator != null) {
            Control controlTime;
            String createTimeStr = sdf.format(createTime);
            Control control2 = this.getView().getControl("createtimestr");
            if (control2 != null) {
                Label label = (Label)control2;
                label.setText(createTimeStr);
            }
            if ((controlTime = this.getView().getControl("createtimeformat")) != null) {
                Label labelTime = (Label)controlTime;
                labelTime.setText(createTimeStr);
            }
        }
    }

    public void initViewEnable() {
        this.setTagStatus();
        this.setNameStr();
        this.setTagCreatorInfo();
    }
}

