/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web;

import java.util.EventObject;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WtcRapidProcessHandlePlugin
extends HRDynamicFormBasePlugin {
    private IFormView openView;
    private static final Log LOG = LogFactory.getLog(WtcRapidProcessHandlePlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String outSysUrl = (String)customParams.get("outSysUrl");
        String pkId = (String)customParams.get("pkId");
        String appName = (String)customParams.get("appName");
        String entityNumber = (String)customParams.get("entityNumber");
        String operationStatus = (String)customParams.get("operationStatus");
        String rootPageId = this.getView().getFormShowParameter().getRootPageId();
        this.openView = this.getView().getViewNoPlugin(rootPageId);
        LOG.info("WtcRapidProcessHandlePlugin_afterBindData outSysUrl ={}\uff0cpkId={},appName={},entityNumber={},operationStatus={}", new Object[]{outSysUrl, pkId, appName, entityNumber, operationStatus});
        if (HRStringUtils.isNotEmpty((String)outSysUrl)) {
            this.handleOutSysUrl(outSysUrl);
        } else if (HRStringUtils.isNotEmpty((String)pkId)) {
            this.handleForm(customParams);
        } else {
            this.handleListOrDyForm(customParams);
        }
        this.getView().sendFormAction(this.openView);
        this.getView().close();
    }

    private void handleOutSysUrl(String outSysUrl) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.NewWindow);
        showParameter.setFormId(outSysUrl);
        this.openView.showForm(showParameter);
    }

    private void handleForm(Map<String, Object> customParams) {
        String appName = (String)customParams.get("appName");
        String pkId = (String)customParams.get("pkId");
        String entityNumber = (String)customParams.get("entityNumber");
        String operationStatus = (String)customParams.get("operationStatus");
        FormShowParameter formShowParameter = this.getFormShowByEntityNumber(entityNumber, true);
        if (formShowParameter != null && appName != null && entityNumber != null) {
            if (pkId != null) {
                this.setPkId(formShowParameter, pkId, entityNumber);
            }
            if (HRStringUtils.isNotEmpty((String)operationStatus)) {
                int status = Integer.parseInt(operationStatus);
                for (OperationStatus value : OperationStatus.values()) {
                    if (status != value.getValue()) continue;
                    formShowParameter.setStatus(value);
                    break;
                }
            }
            WtbsBusinessUtils.openTargetFormView((IFormView)this.openView, (FormShowParameter)formShowParameter, (String)appName);
        }
    }

    private void setPkId(FormShowParameter formShowParameter, String pkId, String entityNumber) {
        Class propertyType = EntityMetadataCache.getDataEntityType((String)entityNumber).getPrimaryKey().getPropertyType();
        String className = propertyType.getName();
        Object pkIdAfterTran = null;
        if (StringUtils.equalsAny((CharSequence)className, (CharSequence[])new CharSequence[]{Long.class.getName(), "long"})) {
            pkIdAfterTran = Long.parseLong(pkId);
        } else if (HRStringUtils.equals((String)className, (String)String.class.getName())) {
            pkIdAfterTran = pkId;
        }
        if (formShowParameter instanceof BaseShowParameter) {
            ((BaseShowParameter)formShowParameter).setPkId(pkIdAfterTran);
        } else if (formShowParameter instanceof BillShowParameter) {
            ((BillShowParameter)formShowParameter).setPkId(pkIdAfterTran);
        }
    }

    private void handleListOrDyForm(Map<String, Object> customParams) {
        String appName = (String)customParams.get("appName");
        String entityNumber = (String)customParams.get("entityNumber");
        FormShowParameter formShowParameter = this.getFormShowByEntityNumber(entityNumber, false);
        if (formShowParameter != null && appName != null && entityNumber != null) {
            WtbsBusinessUtils.openTargetFormView((IFormView)this.openView, (FormShowParameter)formShowParameter, (String)appName);
        }
    }

    private FormShowParameter getFormShowByEntityNumber(String entityNumber, boolean isForm) {
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return null;
        }
        FormShowParameter formShowParameter = null;
        LOG.info("WtcRapidProcessHandlePlugin_getFormShowByEntityNumber isForm = {}", (Object)isForm);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        DynamicObject dynamicObject = serviceHelper.queryOne("modeltype", new QFilter("number", "=", (Object)entityNumber).toArray());
        if (dynamicObject != null) {
            String modelType = dynamicObject.getString("modeltype");
            LOG.info("WtcRapidProcessHandlePlugin_getFormShowByEntityNumber modelType = {}", (Object)modelType);
            switch (modelType) {
                case "BillFormModel": {
                    if (isForm) {
                        formShowParameter = new BillShowParameter();
                        break;
                    }
                    formShowParameter = new ListShowParameter();
                    break;
                }
                case "BaseFormModel": {
                    if (isForm) {
                        formShowParameter = new BaseShowParameter();
                        break;
                    }
                    formShowParameter = new ListShowParameter();
                    break;
                }
                case "DynamicFormModel": 
                case "QueryListModel": {
                    formShowParameter = new FormShowParameter();
                    break;
                }
                case "ReportFormModel": {
                    formShowParameter = new ReportShowParameter();
                    break;
                }
            }
        }
        if (formShowParameter != null) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (formShowParameter instanceof ListShowParameter) {
                ((ListShowParameter)formShowParameter).setBillFormId(entityNumber);
            } else {
                formShowParameter.setFormId(entityNumber);
            }
        }
        LOG.info("WtcRapidProcessHandlePlugin_getFormShowByEntityNumber formShowParameter == null:{}", (Object)(formShowParameter == null ? 1 : 0));
        return formShowParameter;
    }
}

