/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.batchbill;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.util.WTCBillViewUtils;

public class BatchBillTplChangeEdit
extends HRCoreBaseBillEdit {
    protected static final Set<String> NOTSETVALUEKEYS = Sets.newHashSet((Object[])new String[]{"seq", "billno", "parent", "auditor", "auditdate", "submittime", "submitter", "changetype", "entrybillno", "entryparent", "entryischangebill", "entryparentid", "ishavechange", "isexistsworkflow"});

    public void preOpenForm(PreOpenFormEventArgs evt) {
        StringBuilder errMsg;
        boolean require;
        super.preOpenForm(evt);
        BillShowParameter billShowParameter = (BillShowParameter)evt.getFormShowParameter();
        String parentId = (String)billShowParameter.getCustomParam("parent");
        if (BillOperationStatus.ADDNEW.equals((Object)billShowParameter.getBillStatus()) && WTCStringUtils.isNotEmpty((String)parentId) && Long.parseLong(parentId) != 0L && !(require = WTCBillViewUtils.requireMutex(parentId, "wtabm_batchvaapply", "update", errMsg = new StringBuilder()))) {
            evt.setCancel(true);
            evt.setCancelMessage(errMsg.toString());
        }
    }

    public void pageRelease(EventObject evt) {
        super.pageRelease(evt);
        String parentId = this.getView().getPageCache().get("parent");
        if (WTCStringUtils.isNotEmpty((String)parentId) && Long.parseLong(parentId) != 0L) {
            DataMutex dataMutex = DataMutex.create();
            dataMutex.release(parentId, "wtabm_batchvaapply", "update");
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        this.getModel().beginInit();
        this.setBillInfo(formShowParameter);
        this.getModel().updateEntryCache(this.getModel().getEntryEntity("entryentity"));
        this.getModel().updateCache();
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
        this.getView().updateView("attachmentpanel");
        this.getView().updateView("contentpanel");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "change": {
                if (!"2".equals(this.getModel().getValue("changetype"))) break;
                this.getView().showTipNotification(WTCBaseKDString.loseEfficacy());
                args.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String changeName = evt.getProperty().getName();
        if ("changetype".equals(changeName)) {
            String batchBillId = this.getView().getPageCache().get("parent");
            String entityId = this.getView().getEntityId();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
            DynamicObject batchBillDy = serviceHelper.loadSingle((Object)Long.parseLong(batchBillId));
            this.resetFieldValue(batchBillDy, NOTSETVALUEKEYS, true, true);
        }
    }

    private void setChangeBillDataModel() {
        String batchBillId = this.getView().getPageCache().get("parent");
        String entityId = this.getView().getEntityId();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityId);
        DynamicObject batchBillDy = serviceHelper.loadSingle((Object)Long.parseLong(batchBillId));
        this.resetFieldValue(batchBillDy, NOTSETVALUEKEYS, false, false);
        long currUserId = RequestContext.get().getCurrUserId();
        Date currDateTime = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.now());
        IDataModel model = this.getModel();
        model.setValue("islatestbill", (Object)Boolean.TRUE);
        model.setValue("ischangebill", (Object)Boolean.TRUE);
        model.setValue("billstatus", (Object)"A");
        model.setValue("auditstatus", (Object)"A");
        model.setValue("creator", (Object)currUserId);
        model.setValue("createtime", (Object)currDateTime);
        model.setValue("modifier", (Object)currUserId);
        model.setValue("modifytime", (Object)currDateTime);
    }

    protected void setChangeBillOtherData() {
    }

    protected void resetFieldValue(DynamicObject dy, Set<String> notSetValueKeys, boolean onlyEntryData, boolean ignoreParent) {
        this.getModel().beginInit();
        this.resetFieldValue(dy, notSetValueKeys, onlyEntryData, false, false, ignoreParent, -1, -1);
        this.getModel().endInit();
    }

    protected void resetFieldValue(DynamicObject dy, Set<String> notSetValueKeys, boolean onlyEntryData, boolean isEntry, boolean isSubEntry, boolean ignoreParent, int entryIndex, int subEntryIndex) {
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        IDataModel model = this.getModel();
        for (IDataEntityProperty property : properties) {
            if (property instanceof EntryProp && !(property instanceof SubEntryProp)) {
                DynamicObjectCollection entryColl;
                if (!ignoreParent) {
                    model.deleteEntryData(property.getName());
                }
                if (!WTCCollections.isNotEmpty((Collection)(entryColl = dy.getDynamicObjectCollection(property.getName())))) continue;
                if (!ignoreParent) {
                    model.batchCreateNewEntryRow(property.getName(), entryColl.size());
                }
                for (int ii = 0; ii < entryColl.size(); ++ii) {
                    DynamicObject entryDy = (DynamicObject)entryColl.get(ii);
                    this.resetFieldValue(entryDy, notSetValueKeys, onlyEntryData, true, false, ignoreParent, ii, -1);
                }
                continue;
            }
            if (property instanceof SubEntryProp) {
                DynamicObjectCollection subEntryColl = dy.getDynamicObjectCollection(property.getName());
                model.setEntryCurrentRowIndex(property.getParent().getName(), entryIndex);
                if (!ignoreParent) {
                    model.deleteEntryData(property.getName());
                }
                if (!WTCCollections.isNotEmpty((Collection)subEntryColl)) continue;
                if (!ignoreParent) {
                    model.batchCreateNewEntryRow(property.getName(), subEntryColl.size());
                }
                for (int sii = 0; sii < subEntryColl.size(); ++sii) {
                    DynamicObject subEntrtDy = (DynamicObject)subEntryColl.get(sii);
                    this.resetFieldValue(subEntrtDy, notSetValueKeys, onlyEntryData, false, true, ignoreParent, entryIndex, sii);
                }
                continue;
            }
            if ("id".equals(property.getName())) {
                if (ignoreParent) continue;
                if (isEntry && "entryentity".equals(property.getParent().getName())) {
                    model.setValue("entryparent", dy.get(property.getName()), entryIndex);
                    model.setValue("entryischangebill", (Object)Boolean.TRUE, entryIndex);
                    continue;
                }
                if (isSubEntry) {
                    model.setValue("entryparentid", dy.get(property.getName()), subEntryIndex, entryIndex);
                    continue;
                }
                if (onlyEntryData || isEntry) continue;
                model.setValue("parent", dy.get(property.getName()));
                continue;
            }
            String mainPropKey = property.getName();
            if (mainPropKey.endsWith("_id")) {
                mainPropKey = mainPropKey.replace("_id", "");
            }
            if (notSetValueKeys.contains(mainPropKey)) continue;
            if (isEntry) {
                model.setValue(property.getName(), dy.get(property.getName()), entryIndex);
                continue;
            }
            if (isSubEntry) {
                model.setValue(property.getName(), dy.get(property.getName()), subEntryIndex, entryIndex);
                continue;
            }
            if (onlyEntryData) continue;
            model.setValue(property.getName(), dy.get(property.getName()));
        }
    }

    private void setBillInfo(BillShowParameter formShowParameter) {
        BillOperationStatus status = formShowParameter.getBillStatus();
        if (status.equals((Object)BillOperationStatus.ADDNEW)) {
            String parentId = (String)formShowParameter.getCustomParam("parent");
            this.getView().getPageCache().put("parent", parentId);
            this.copyAttachment(Long.valueOf(parentId));
            this.setChangeBillDataModel();
            this.setChangeBillOtherData();
        } else {
            String parentId = String.valueOf(this.getModel().getValue("parent"));
            this.getView().getPageCache().put("parent", parentId);
        }
        this.getView().getPageCache().put("originalid", String.valueOf(this.getModel().getDataEntity(true).getLong("originalid")));
    }

    private void copyAttachment(Long parentId) {
        Long pkValue = DB.genGlobalLongId();
        this.getModel().getDataEntity().set("id", (Object)pkValue);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("bos_attachment");
        QFilter filter = new QFilter("finterid", "=", (Object)parentId.toString());
        DynamicObject[] originalAttachments = helper.loadDynamicObjectArray(new QFilter[]{filter});
        if (originalAttachments == null || originalAttachments.length == 0) {
            return;
        }
        DynamicObject[] attachments = new DynamicObject[originalAttachments.length];
        for (int i = 0; i < originalAttachments.length; ++i) {
            DynamicObject attachment = originalAttachments[i];
            DynamicObject newAttachment = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)attachment, (DynamicObject)newAttachment);
            newAttachment.set("fbilltype", (Object)this.getView().getFormShowParameter().getFormId());
            newAttachment.set("finterid", (Object)pkValue);
            attachments[i] = newAttachment;
        }
        helper.save(attachments);
    }
}

