/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.batchbill;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyKDStringHelper;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.common.enums.WTCBillChangeEnum;
import kd.wtc.wtbs.common.model.bill.unifybill.UnifyBillApplyAttr;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BatchBillTplEdit
extends HRDataBaseEdit {
    private static Map<String, WTCBillChangeEnum> billChangeEnumMap = new HashMap<String, WTCBillChangeEnum>(16);

    public void afterBindData(EventObject evt) {
        Long personId;
        super.afterBindData(evt);
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus billStatus = showParameter.getBillStatus();
        IDataModel model = this.getModel();
        Object adminOrg = model.getValue("adminorg");
        Object isChangeBill = model.getValue("ischangebill");
        if (BillOperationStatus.ADDNEW.equals((Object)billStatus) && adminOrg == null && Boolean.TRUE != isChangeBill && (personId = BillUnifyService.getUserId((IFormView)this.getView())) != null && personId != 0L) {
            String appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(this.getView());
            UnifyBillApplyAttr attr = new UnifyBillApplyAttr(appId, "wtabm_batchvaapply");
            String queryProp = "id,boid,adminorg,startdate,enddate";
            Map attFileTopMap = BillCommonService.getInstance().getAttFileTop1ByPersonIds((Set)Sets.newHashSet((Object[])new Long[]{personId}), attr, queryProp);
            if (WTCCollections.isNotEmpty((Map)attFileTopMap)) {
                List attFileVList = attFileTopMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
                attFileVList.sort((o1, o2) -> {
                    Date startDate = o1.getDate("startdate");
                    Date startDate02 = o2.getDate("startdate");
                    if (startDate == null) {
                        return -1;
                    }
                    if (startDate02 == null) {
                        return 1;
                    }
                    return startDate.compareTo(startDate02);
                });
                long adminOrgId = ((DynamicObject)attFileVList.get(attFileVList.size() - 1)).getLong("adminorg");
                model.setValue("adminorg", (Object)adminOrgId);
                model.setDataChanged(false);
            }
        }
        BatchBillUnifyService.getInstance().customBatchBillButton(this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.beforeOpValidator(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String opKey;
            BatchBillUnifyService.getInstance().customBatchBillButton(this.getView());
            switch (opKey = afterDoOperationEventArgs.getOperateKey()) {
                case "change": {
                    DynamicObject dy = this.getModel().getDataEntity(true);
                    BatchBillUnifyService.getInstance().openAddChangeBill(this.getView(), dy, this.getView().getFormShowParameter().getFormId());
                    break;
                }
            }
        }
    }

    private void beforeOpValidator(BeforeDoOperationEventArgs args) {
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        BillOperationStatus pageStatus = formShowParameter.getBillStatus();
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (BillOperationStatus.ADDNEW.equals((Object)pageStatus) && HRStringUtils.equals((String)"unsubmit", (String)operateKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"BatchBillTplEdit_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        } else if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submiteffect", "submit", "change"})) {
            String entityId = this.getView().getEntityId();
            WTCBillChangeEnum billChangeEnum = billChangeEnumMap.get(entityId);
            HRBaseServiceHelper serviceHelper = HRBaseServiceHelper.create((String)entityId);
            if (billChangeEnum != null) {
                DynamicObject dy = null;
                if ("change".equals(operateKey)) {
                    dy = serviceHelper.loadSingle((Object)this.getModel().getDataEntity().getLong("id"));
                } else if (((Boolean)this.getModel().getValue("ischangebill")).booleanValue() && OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                    dy = serviceHelper.loadSingle((Object)this.getModel().getDataEntity().getLong("parent"));
                }
                if (dy != null && billChangeEnum.getVALUE() == dy.get(billChangeEnum.getFILTER())) {
                    args.setCancel(true);
                    this.getView().showTipNotification(BillUnifyKDStringHelper.changeRepeat((String)ResManager.loadKDString((String)"\u6279\u91cf\u4f11\u5047", (String)"BatchBillTplList_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0])));
                }
            }
        }
    }

    static {
        billChangeEnumMap.put("wtabm_batchvaapply", WTCBillChangeEnum.BATCHVA);
        billChangeEnumMap.put("wtabm_batchvaupdate", WTCBillChangeEnum.BATCHVA);
    }
}

