/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.batchbill;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.bill.batchbill.BatchBillUnifyService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.MultiLangEnumBridge;
import kd.wtc.wtbs.common.constants.WTCBaseKDString;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class BatchBillTplList
extends HRCoreBaseBillList {
    private static final Map<String, String> changeEntityMap = new HashMap<String, String>();
    private static final Map<String, MultiLangEnumBridge> entityNameMap;

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        if (!"wtabm_batchvaupdate".equals(((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId())) {
            List qFilters = evt.getQFilters();
            qFilters.add(new QFilter("islatestbill", "=", (Object)Boolean.TRUE));
            evt.setOrderBy("createtime desc,submittime desc");
        }
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject rowData;
        super.packageData(evt);
        if (!(evt.getSource() instanceof ColumnDesc)) {
            return;
        }
        String key = ((ColumnDesc)evt.getSource()).getKey();
        if ("openchangehis".equals(key) && (rowData = evt.getRowData()).containsProperty("ischangebill")) {
            Object formatValue = evt.getFormatValue();
            ArrayList operationColItems = (ArrayList)formatValue;
            for (OperationColItem operationColItem : operationColItems) {
                String operationKey = operationColItem.getOperationKey();
                if (!"openchangehis".equals(operationKey)) continue;
                boolean isChangeBill = rowData.getBoolean("ischangebill");
                operationColItem.setVisible(isChangeBill);
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent evt) {
        super.beforeShowBill(evt);
        BillShowParameter parameter = evt.getParameter();
        if (BillOperationStatus.ADDNEW != parameter.getBillStatus()) {
            long currUserId;
            QFilter qFilter;
            String formId = parameter.getFormId();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(formId);
            DynamicObject[] batchBillDy = serviceHelper.query("id,billstatus,creator,ischangebill", (qFilter = new QFilter("id", "=", parameter.getPkId())).toArray());
            long createUserId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)batchBillDy[0], (String)"creator");
            if (createUserId != (currUserId = RequestContext.get().getCurrUserId())) {
                parameter.setBillStatus(BillOperationStatus.VIEW);
                parameter.setStatus(OperationStatus.VIEW);
            }
            if (batchBillDy[0].getBoolean("ischangebill")) {
                parameter.setFormId("wtabm_batchvaupdate");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate;
        OperateOption option;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate && (option = (operate = (FormOperate)source).getOption()) != null) {
            String opKey;
            switch (opKey = operate.getOperateKey()) {
                case "change": {
                    this.checkChangeRight(args);
                    break;
                }
                case "submit": 
                case "unsubmit": {
                    this.handleOp(args, operate);
                    break;
                }
                case "viewflowchart": {
                    this.viewFlowChart(args);
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillUnifyService.handleHyperLinkViewFlowChar((IFormView)this.getView(), (HyperLinkClickArgs)args);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        BillCommonService.getInstance().handleFilterContainerInit(args, this.getView());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List attFileBoIds;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (("entryentity.attfile.id".equals(fieldName) || "attfile.id".equals(fieldName)) && WTCCollections.isNotEmpty((Collection)(attFileBoIds = BillCommonService.getInstance().getAttFileOpenBillListBoIdList(this.getView())))) {
            QFilter qFilter = new QFilter("boid", "in", (Object)attFileBoIds);
            args.addCustomQFilter(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String opKey = evt.getOperateKey();
        if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
            return;
        }
        switch (opKey) {
            case "openchangehis": {
                this.openChangeHis();
                break;
            }
            case "change": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
                DynamicObject dy = HRBaseServiceHelper.create((String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()).queryOne((Object)pk);
                BatchBillUnifyService.getInstance().openAddChangeBill(this.getView(), dy, ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
            }
        }
    }

    protected void checkChangeRight(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Set collect = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (WTCCollections.isEmpty(collect) || collect.size() != 1) {
            this.getView().showTipNotification(WTCBaseKDString.onlyChangeOne());
            evt.setCancel(true);
        } else {
            Long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject dy = HRBaseServiceHelper.create((String)((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()).queryOne((Object)pk);
            int changeType = dy.getInt("changetype");
            if (!"C".equals(dy.getString("billstatus"))) {
                this.getView().showTipNotification(WTCBaseKDString.checkBillPass());
                evt.setCancel(true);
                return;
            }
            if (dy.getBoolean("ischangebill") && changeType == 2) {
                this.getView().showTipNotification(WTCBaseKDString.loseEfficacy());
                evt.setCancel(true);
                return;
            }
        }
    }

    private void viewFlowChart(BeforeDoOperationEventArgs args) {
        String formId;
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        FormOperate operate = (FormOperate)args.getSource();
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (selectedRows.size() != 1) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86[%1$s]\u884c\u3002", (String)"BatchBillTplList_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), selectedRows.size());
            this.getView().showTipNotification(message);
            args.setCancel(true);
            return;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = HRBaseServiceHelper.create((String)billFormId).queryOne(primaryKeyValue);
        if (dynamicObject == null) {
            return;
        }
        boolean isChange = dynamicObject.getBoolean("ischangebill");
        String updateFormId = changeEntityMap.get(billFormId);
        String string = formId = isChange ? updateFormId : billFormId;
        if (WTCStringUtils.isEmpty((String)formId)) {
            return;
        }
        operate.setEntityId(formId);
    }

    private void handleOp(BeforeDoOperationEventArgs args, FormOperate formOperate) {
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        String changeFormId = changeEntityMap.get(billFormId);
        String operateKey = formOperate.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectRowIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", selectRowIds);
        String properties = String.join((CharSequence)",", "ischangebill", "billno");
        DynamicObject[] queryRes = HRBaseServiceHelper.create((String)billFormId).query(properties, new QFilter[]{qFilter});
        Map<Boolean, List<DynamicObject>> groupedResult = Arrays.stream(queryRes).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getBoolean("ischangebill")));
        if (WTCCollections.isNotEmpty(groupedResult) && groupedResult.size() > 1) {
            MultiLangEnumBridge billNameMulti = entityNameMap.get(billFormId);
            String billTypeName = billNameMulti != null ? billNameMulti.loadKDString() : "";
            String errorTips = StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit") ? WTCBaseKDString.submitTips((String)billTypeName) : WTCBaseKDString.unSubmitTips((String)billTypeName);
            this.getView().showTipNotification(errorTips);
            args.setCancel(true);
            return;
        }
        Set<Boolean> booleans = groupedResult.keySet();
        if (WTCStringUtils.isEmpty((String)billFormId)) {
            return;
        }
        if (WTCCollections.isNotEmpty(booleans) && booleans.contains(Boolean.TRUE)) {
            formOperate.setEntityId(changeFormId);
        }
    }

    private void openChangeHis() {
        BillList billListAp = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billListAp.getSelectedRows();
        Long focusRowId = (Long)selectedRows.get(0).getPrimaryKeyValue();
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        DynamicObject dy = HRBaseServiceHelper.create((String)billFormId).loadSingle((Object)focusRowId);
        BatchBillUnifyService.getInstance().loadHisBill(this.getView(), dy, changeEntityMap.get(billFormId), true);
    }

    static {
        changeEntityMap.put("wtabm_batchvaapply", "wtabm_batchvaupdate");
        entityNameMap = new HashMap<String, MultiLangEnumBridge>();
        entityNameMap.put("wtabm_batchvaapply", new MultiLangEnumBridge("\u6279\u91cf\u4f11\u5047", "BatchBillTplList_0", "wtc-wtbs-formplugin"));
    }
}

