/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.calreport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.web.calreport.CalReportAnalyseConstants;

public class CalReportAnalysisEdit
extends HRDataBaseEdit {
    private static final String RICHTEXT_EDITOR = "richtexteditorap";
    private static final String[] PIE_CHART_NAME_ARR = new String[]{"mainpiechart", "subpiechart1", "subpiechart2", "subpiechart3", "subpiechart4", "subpiechart5", "subpiechart6"};
    private static final String RICHTEXT_TAG = "richtext_tag";
    private static final String ANALYSISDATA_TAG = "analysisdata_tag";

    public void afterBindData(EventObject eventObject) {
        String largeText = (String)this.getModel().getValue(RICHTEXT_TAG);
        RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXT_EDITOR);
        if (largeText == null || largeText.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1"});
        } else {
            richTextEditor.setText(largeText);
        }
        this.setBarCartData();
        this.PieChart();
    }

    public void beforeBindData(EventObject object) {
        super.beforeBindData(object);
    }

    private void setBarCartData() {
        String analysisdata = (String)this.getModel().getValue(ANALYSISDATA_TAG);
        if (HRStringUtils.isEmpty((String)analysisdata)) {
            return;
        }
        Map map = (Map)JSON.parseObject((String)analysisdata, Map.class);
        Map barChartData = (Map)map.get("barChartData");
        if (null == barChartData || barChartData.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap11"});
            return;
        }
        JSONArray jsonArrayxData = (JSONArray)barChartData.get("xData");
        String[] xData = (String[])jsonArrayxData.toArray((Object[])new String[0]);
        JSONArray jsonArrayyData = (JSONArray)barChartData.get("yData");
        Number[] yData = (Number[])jsonArrayyData.toArray((Object[])new Number[0]);
        BarChart barchart = (BarChart)this.getControl("barchartap");
        boolean isLegendVertical = true;
        barchart.setLegendVertical(isLegendVertical);
        barchart.addTooltip("trigger", (Object)"axis");
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        String formatter = "{b0}: {c0}";
        barchart.addTooltip("formatter", (Object)formatter);
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        barchart.addFuncPath(toolTipFuncPath);
        barchart.setShowTooltip(true);
        barchart.setLegendAlign(XAlign.center, YAlign.top);
        String tempSubTaskLoadkdString = CalReportAnalyseConstants.SUB_TASK.loadKDString();
        Axis xLine = barchart.createXAxis(tempSubTaskLoadkdString, AxisType.category);
        xLine.setPropValue("data", (Object)xData);
        BarSeries barseries = barchart.createSeries(CalReportAnalyseConstants.HELP.loadKDString());
        barseries.setName(tempSubTaskLoadkdString);
        barseries.setStack(CalReportAnalyseConstants.TASK_COST.loadKDString());
        barseries.setData(yData);
        barseries.setBarWidth("15");
        barseries.setColor("#45cdff");
        barchart.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateKey, (CharSequence[])new CharSequence[]{"save", "submit", "submitandaudit"})) {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl(RICHTEXT_EDITOR);
            String editorText = richTextEditor.getText();
            this.getModel().setValue(RICHTEXT_TAG, (Object)editorText);
        }
    }

    private void PieChart() {
        for (String pieChartName : PIE_CHART_NAME_ARR) {
            this.drawOnePieChart(pieChartName);
        }
    }

    private void drawOnePieChart(String pieChartName) {
        String analysisdata = (String)this.getModel().getValue(ANALYSISDATA_TAG);
        if (HRStringUtils.isEmpty((String)analysisdata)) {
            return;
        }
        Map map = (Map)JSON.parseObject((String)analysisdata, Map.class);
        Map pieChartData = (Map)map.get(pieChartName);
        if (null == pieChartData || pieChartData.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{pieChartName});
            return;
        }
        PieChart pieChart = (PieChart)this.getControl(pieChartName);
        pieChart.clearData();
        pieChart.setMargin(Position.right, "80");
        List<String> schools = this.getSchools();
        Map<String, ItemValue[]> itemValueMap = this.getProfitData02(schools, pieChartData);
        int schoolsSize = schools.size();
        int ssIndex = 0;
        String[] percent = this.getPercent(schoolsSize);
        for (Map.Entry<String, ItemValue[]> entry : itemValueMap.entrySet()) {
            PieSeries series = pieChart.createPieSeries(entry.getKey());
            series.setRadius(percent[ssIndex++], percent[ssIndex++]);
            this.setSeriesData(series, entry.getValue());
        }
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("orient", (Object)"vertical");
        pieChart.setLegendPropValue("x", (Object)"right");
        pieChart.refresh();
    }

    private List<String> getSchools() {
        ArrayList<String> schools = new ArrayList<String>();
        schools.add("");
        return schools;
    }

    private PieSeries setSeriesData(PieSeries series, ItemValue[] items) {
        series.setData(items);
        Label label = new Label();
        label.setShow(true);
        label.setFontSize("16");
        label.setPosition(Position.top);
        series.setLabel(label);
        HashMap map02 = Maps.newHashMapWithExpectedSize((int)2);
        HashMap normalMap02 = Maps.newHashMapWithExpectedSize((int)4);
        map02.put("normal", normalMap02);
        normalMap02.put("length", "5");
        normalMap02.put("length2", "15");
        HashMap lineStyleMap = Maps.newHashMapWithExpectedSize((int)2);
        normalMap02.put("lineStyle", lineStyleMap);
        lineStyleMap.put("color", "red");
        series.setPropValue("labelLine", (Object)map02);
        Object[] points01 = new Object[]{"50%", "50%"};
        series.setPropValue("center", (Object)points01);
        return series;
    }

    private Map<String, ItemValue[]> getProfitData02(List<String> schools, Map<String, Object> pieChartData) {
        JSONArray jsonArrayItemArr = (JSONArray)pieChartData.get("itemArr");
        String[] itemArr = (String[])jsonArrayItemArr.toArray((Object[])new String[0]);
        JSONArray jsonArrayValueArr = (JSONArray)pieChartData.get("valueArr");
        Number[] valueArr = (Number[])jsonArrayValueArr.toArray((Object[])new Number[0]);
        HashMap resMap = Maps.newHashMapWithExpectedSize((int)2);
        Map<String, String> cityColor = this.getColor();
        ItemValue[] itemValues = new ItemValue[itemArr.length];
        for (int i = 0; i < itemArr.length; ++i) {
            itemValues[i] = new ItemValue(itemArr[i], valueArr[i], cityColor.get(itemArr[i]));
        }
        resMap.put(schools.get(0), itemValues);
        return resMap;
    }

    private String[] getPercent(int itemValueMapSize) {
        int rangeNum = 80 / itemValueMapSize;
        int temp = 0;
        String[] per = new String[itemValueMapSize * 2];
        for (int i = 0; i < itemValueMapSize * 2; ++i) {
            per[i] = temp + "%";
            per[++i] = (temp += rangeNum) + "%";
            temp += 5;
        }
        return per;
    }

    private Map<String, String> getColor() {
        HashMap cityColor = Maps.newHashMapWithExpectedSize((int)10);
        cityColor.put(CalReportAnalyseConstants.PARA_INIT.loadKDString(), "#6112e4");
        cityColor.put(CalReportAnalyseConstants.ENGINE_CALLBACK.loadKDString(), "#0a35b0");
        cityColor.put(CalReportAnalyseConstants.DATA_STORE.loadKDString(), "#77b00a");
        cityColor.put("11", "#ece917");
        cityColor.put(ResManager.loadKDString((String)"\u4e91\u5357", (String)"CalReportAnalysisEdit_6", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), "#ecb217");
        cityColor.put(ResManager.loadKDString((String)"\u6e56\u5357", (String)"CalReportAnalysisEdit_7", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), "#ec6c17");
        cityColor.put(ResManager.loadKDString((String)"\u6e56\u5317", (String)"CalReportAnalysisEdit_8", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), "#df7ee0");
        cityColor.put(ResManager.loadKDString((String)"\u5e7f\u4e1c", (String)"CalReportAnalysisEdit_9", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), "#915dc2");
        cityColor.put(CalReportAnalyseConstants.TIE_LINE.loadKDString(), "#7ecfe0");
        cityColor.put(ResManager.loadKDString((String)"\u56db\u5ddd", (String)"CalReportAnalysisEdit_11", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]), "#06090e");
        return cityColor;
    }
}

