/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.calreport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.formplugin.web.calreport.CalReportAnalyseConstants;

public class CalReportAnalyzer {
    private static final String BASE_UNIT = "-";
    private static final String BLANK = "&nbsp;";
    private static final int MAX_LENGTH = 100;
    private static final String MAIN_PIE_CHART_NAME = "mainpiechart";
    private static final String[] SUB_PIE_CHART_NAME_ARR = new String[]{"subpiechart1", "subpiechart2", "subpiechart3", "subpiechart4", "subpiechart5", "subpiechart6"};
    private static final long MILLISEC_TO_SECOND = 1000L;
    private static final String SECOND_TO_TIME_FORMATE = "h : m : s";
    private static final String FILE_JSON_TEXT_TAG = "jsontext_tag";
    private static final String RICHTEXT_TAG = "richtext_tag";
    private static final String ANALYSISDATA_TAG = "analysisdata_tag";

    public static DynamicObject queryMainTask(long totalTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_tietask");
        QFilter qFilter = new QFilter("id", "=", (Object)totalTaskId);
        String selectProperties = "timecost,totalsubtask,runattperson,startdate,enddate,creator";
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject[] querySubTasks(long totalTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_tiesubtask");
        QFilter qFilter = new QFilter("taskid", "=", (Object)totalTaskId);
        String selectProperties = "index,startdate,enddate";
        return serviceHelper.query(selectProperties, new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryCalReportsByTaskId(long totalTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreport");
        QFilter qFilter = new QFilter("totaltaskid", "=", (Object)totalTaskId);
        return serviceHelper.query(FILE_JSON_TEXT_TAG, new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryCalReportsBySubTaskId(long subTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreport");
        QFilter qFilter = new QFilter("subtaskid", "=", (Object)subTaskId);
        return serviceHelper.query(FILE_JSON_TEXT_TAG, new QFilter[]{qFilter});
    }

    public static DynamicObject querySubTaskById(long subTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_tiesubtask");
        QFilter qFilter = new QFilter("id", "=", (Object)subTaskId);
        String selectProperties = "index,startdate,enddate";
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public static Object analyseSubTask(Long taskId, String versionId, Long subtaskid) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject analysisDynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtbs_reportanalysis"));
        DynamicObject dynamicObject = CalReportAnalyzer.queryMainTask(taskId);
        Map<String, Object> pieChartData = CalReportAnalyzer.genTaskPieChart(CalReportAnalyzer.queryCalReportsBySubTaskId(subtaskid));
        result.put(MAIN_PIE_CHART_NAME, pieChartData);
        return CalReportAnalyzer.saveData(taskId, versionId, result, analysisDynamicObject, dynamicObject, subtaskid);
    }

    private static Object saveData(Long taskId, String versionId, Map<String, Object> result, DynamicObject analysisDynamicObject, DynamicObject dynamicObject, Long pkId) {
        long timeCost = dynamicObject.getLong("timecost");
        int totalSubTask = dynamicObject.getInt("totalsubtask");
        Date startDate = dynamicObject.getDate("startdate");
        Date endDate = dynamicObject.getDate("enddate");
        long creator = dynamicObject.getLong("creator.id");
        analysisDynamicObject.set("totaltaskcost", (Object)(timeCost / 1000L));
        analysisDynamicObject.set("shardingnum", (Object)totalSubTask);
        analysisDynamicObject.set("maintaskstart", (Object)startDate);
        analysisDynamicObject.set("maintaskend", (Object)endDate);
        analysisDynamicObject.set("versionid", (Object)versionId);
        analysisDynamicObject.set("maintaskid", (Object)taskId);
        analysisDynamicObject.set(ANALYSISDATA_TAG, (Object)JSON.toJSONString(result));
        analysisDynamicObject.set("creator", (Object)creator);
        analysisDynamicObject.set("id", (Object)pkId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_reportanalysis");
        return serviceHelper.saveOne(analysisDynamicObject);
    }

    public static Object analyseMainTask(Long taskId, String versionId) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject analysisDynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtbs_reportanalysis"));
        DynamicObject dynamicObject = CalReportAnalyzer.queryMainTask(taskId);
        DynamicObject[] dynamicObjects = CalReportAnalyzer.querySubTasks(taskId);
        long longestTimeOfSubTask = CalReportAnalyzer.queryLongestTimeOfSubTask(dynamicObjects);
        String parallelChart = CalReportAnalyzer.genSubTaskParallelChart(taskId, dynamicObjects, longestTimeOfSubTask);
        result.put("parallelChart", parallelChart);
        analysisDynamicObject.set(RICHTEXT_TAG, (Object)parallelChart);
        Map<String, Object> barChartData = CalReportAnalyzer.genSubTaskBarChart(dynamicObjects);
        result.put("barChartData", barChartData);
        DynamicObject[] subTaskList = CalReportAnalyzer.queryCalReportsByTaskId(taskId);
        Map<String, Object> pieChartData = CalReportAnalyzer.genTaskPieChart(subTaskList);
        result.put(MAIN_PIE_CHART_NAME, pieChartData);
        CalReportAnalyzer.genSubPieChartData(subTaskList, result);
        return CalReportAnalyzer.saveData(taskId, versionId, result, analysisDynamicObject, dynamicObject, taskId);
    }

    private static void genSubPieChartData(DynamicObject[] subTaskList, Map<String, Object> result) {
        int length = subTaskList.length;
        ArrayList<Integer> indexList = new ArrayList<Integer>(10);
        if (length >= 6) {
            indexList.add(0);
            indexList.add(1);
            indexList.add(2);
            indexList.add(length - 3);
            indexList.add(length - 2);
            indexList.add(length - 1);
        } else {
            for (int i = 0; i < length; ++i) {
                indexList.add(i);
            }
        }
        int index = 0;
        for (Integer i : indexList) {
            DynamicObject dynamicObject = subTaskList[i];
            Map<String, Object> pieChartDataMap = CalReportAnalyzer.genTaskPieChart(new DynamicObject[]{dynamicObject});
            result.put(SUB_PIE_CHART_NAME_ARR[index++], pieChartDataMap);
        }
    }

    private static Map<String, Object> genTaskPieChart(DynamicObject[] dynamicObjects) {
        String[] itemArr = new String[4];
        int[] valueArr = new int[4];
        for (DynamicObject dynamicObject : dynamicObjects) {
            String jsontext = dynamicObject.getString(FILE_JSON_TEXT_TAG);
            Map map = (Map)JSONObject.parseObject((String)jsontext, Map.class);
            JSONArray children = (JSONArray)map.get("children");
            Object[] objects = children.toArray(new Object[0]);
            boolean first = true;
            long tieLineStartTime = 0L;
            long tieLineEndTime = 0L;
            Integer dataStoreCost = 0;
            int index = 0;
            for (Object object : objects) {
                JSONObject jsonObject = (JSONObject)object;
                Integer elapsedMilliSecond = jsonObject.getInteger("elapsedMilliSecond");
                String group = jsonObject.getString("group");
                if (group.startsWith(CalReportAnalyseConstants.TIE_LINE.loadKDString())) {
                    if (!first) continue;
                    tieLineStartTime = jsonObject.getLong("startTime");
                    first = false;
                    continue;
                }
                if (group.equals(CalReportAnalyseConstants.ENGINE_CALLBACK.loadKDString())) {
                    tieLineEndTime = jsonObject.getLong("startTime");
                } else if (group.equals(CalReportAnalyseConstants.DATA_STORE.loadKDString())) {
                    dataStoreCost = elapsedMilliSecond;
                }
                itemArr[index] = group;
                int n = index++;
                valueArr[n] = valueArr[n] + elapsedMilliSecond;
            }
            itemArr[itemArr.length - 1] = CalReportAnalyseConstants.TIE_LINE.loadKDString();
            if (tieLineStartTime == 0L || tieLineEndTime < tieLineStartTime) continue;
            int n = valueArr.length - 1;
            valueArr[n] = valueArr[n] + (Math.toIntExact(tieLineEndTime - tieLineStartTime) - dataStoreCost);
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        result.put("itemArr", itemArr);
        result.put("valueArr", valueArr);
        return result;
    }

    private static Map<String, Object> genSubTaskBarChart(DynamicObject[] dynamicObjects) {
        String[] xData = new String[dynamicObjects.length];
        Number[] yData = new Number[dynamicObjects.length];
        for (int i = 0; i < dynamicObjects.length; ++i) {
            String barName;
            DynamicObject dynamicObject = dynamicObjects[i];
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("endDate");
            int index = dynamicObject.getInt("index");
            if (null == startDate || null == endDate) {
                xData[i] = index + "_";
                yData[i] = 0;
                continue;
            }
            long end = endDate.getTime();
            long start = startDate.getTime();
            long cost = end - start;
            xData[i] = barName = CalReportAnalyzer.getBarName(cost, index);
            yData[i] = cost;
        }
        HashMap data = Maps.newHashMapWithExpectedSize((int)2);
        data.put("xData", xData);
        data.put("yData", yData);
        return data;
    }

    private static String getBarName(Long cost, int index) {
        String name = index + "_";
        name = name + CalReportAnalyzer.getCostStr(cost);
        return name;
    }

    private static String getCostStr(Long cost) {
        String costStr = cost >= 1000L ? WTCDateUtils.secondToTime((long)(cost / 1000L), (String)SECOND_TO_TIME_FORMATE) : String.valueOf(cost);
        return costStr;
    }

    public static String genSubTaskParallelChart(Long taskId, DynamicObject[] dynamicObjects, long longestTimeOfSubTask) {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        long earlyStartTime = CalReportAnalyzer.queryEarlyStartTimeOfSubTask(taskId);
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("enddate");
            if (null == startDate || null == endDate) continue;
            int index = dynamicObject.getInt("index");
            long startTime = startDate.getTime();
            long endTime = endDate.getTime();
            long diff = (startTime - earlyStartTime) * 100L / longestTimeOfSubTask;
            long cost = (endTime - startTime) * 100L / longestTimeOfSubTask;
            String tag = "  " + index + " ," + sdf.format(startDate) + " ," + CalReportAnalyzer.getCostStr(endTime - startTime);
            sb.append(CalReportAnalyzer.getDiffString(diff, BLANK));
            sb.append(CalReportAnalyzer.getDiffString(cost, BASE_UNIT));
            sb.append('>');
            sb.append(tag);
            sb.append("<br/>");
        }
        return sb.toString();
    }

    private static String getDiffString(long diff, String baseUnit) {
        StringBuilder sb = new StringBuilder((int)diff);
        int i = 0;
        while ((long)i < diff) {
            sb.append(baseUnit);
            ++i;
        }
        return sb.toString();
    }

    private static long queryEarlyStartTimeOfSubTask(Long taskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtte_tiesubtask");
        QFilter qFilter = new QFilter("taskid", "=", (Object)taskId);
        String selectProperties = "index,startdate,enddate";
        String order = "startdate asc";
        DynamicObject dynamicObject = serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter}, order);
        return dynamicObject.getDate("startdate").getTime();
    }

    private static long queryLongestTimeOfSubTask(DynamicObject[] dynamicObjects) {
        long maxCost = 0L;
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date startDate = dynamicObject.getDate("startdate");
            Date endDate = dynamicObject.getDate("endDate");
            if (null == startDate || null == endDate) continue;
            long end = endDate.getTime();
            long start = startDate.getTime();
            maxCost = Math.max(maxCost, end - start);
        }
        return maxCost;
    }
}

