/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.calreport;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.business.web.DataBaseEditService;
import kd.wtc.wtbs.formplugin.web.calreport.CalReportAnalyzer;

public class CalReportList
extends HRDataBaseList {
    public void beforeShowBill(BeforeShowBillFormEvent event) {
        event.getParameter().setStatus(OperationStatus.VIEW);
        event.getParameter().setCaption(ResManager.loadKDString((String)"\u8003\u52e4\u8ba1\u7b97\u62a5\u544a", (String)"CalReportList_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
    }

    private DynamicObject getCurrentRowData(Object primaryKeyValue) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_taskreport");
        QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
        String selectProperties = "totaltaskid,subtaskid,name,category";
        return serviceHelper.queryOne(selectProperties, new QFilter[]{qFilter});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        Long analysedReportPkId;
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long pkId = (Long)clickEvent.getCurrentRow().getPrimaryKeyValue();
        String fieldName = clickEvent.getFieldName();
        DynamicObject currentRowData = this.getCurrentRowData(pkId);
        Object totalTaskId = currentRowData.get("totalTaskId");
        Object subtaskid = currentRowData.get("subtaskid");
        String category = currentRowData.getString("category");
        if (!"wtte_tie".equals(category)) {
            return;
        }
        String versionId = currentRowData.getString("name");
        Long pk = null;
        if ("totaltaskid".equals(fieldName)) {
            analysedReportPkId = this.getAnalysedReportPkId((Long)totalTaskId);
            if (null == analysedReportPkId) {
                Object object = CalReportAnalyzer.analyseMainTask((Long)totalTaskId, versionId);
                pk = ((DynamicObject)object).getLong("id");
            } else {
                pk = analysedReportPkId;
            }
            args.setCancel(true);
        } else if ("subtaskid".equals(fieldName)) {
            analysedReportPkId = this.getAnalysedReportPkId((Long)subtaskid);
            if (null == analysedReportPkId) {
                Object object = CalReportAnalyzer.analyseSubTask((Long)totalTaskId, versionId, (Long)subtaskid);
                pk = ((DynamicObject)object).getLong("id");
            } else {
                pk = analysedReportPkId;
            }
            args.setCancel(true);
        }
        if (pk == null) {
            return;
        }
        BillShowParameter showParameter = DataBaseEditService.getBillShowParameter((String)"wtbs_reportanalysis", (ShowType)ShowType.MainNewTabPage, (Object)pk);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Long getAnalysedReportPkId(Long taskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtbs_reportanalysis");
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject dynamicObject = serviceHelper.queryOne("id", new QFilter[]{qFilter});
        return dynamicObject == null ? null : Long.valueOf(dynamicObject.getLong("id"));
    }
}

