/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.daterangetips;

import java.util.EventObject;
import java.util.Map;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.TipsSupport;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.prompt.PromptService;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.formplugin.util.WTCFormUtils;

public class WTCDateRangeTips
extends AbstractFormPlugin {
    private static final Map<String, Tuple<Long, String>> TIPS_MAP = Maps.newHashMapWithExpectedSize((int)8);
    private static final String FLEXPANELAP = "flexpanelap";

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String formId = this.getView().getFormShowParameter().getFormId();
        Tuple<Long, String> tipsTuple = TIPS_MAP.get(formId);
        if (tipsTuple == null) {
            return;
        }
        Long promptId = (Long)tipsTuple.getKey();
        String promptContent = PromptService.getPromptContentById((Long)promptId);
        if (HRStringUtils.isNotEmpty((String)promptContent)) {
            this.setTips((String)tipsTuple.getValue(), promptContent);
        }
    }

    private void setTips(String controlKey, String promptContent) {
        IFormView view = this.getView();
        Control control = view.getControl(controlKey);
        if (control instanceof TipsSupport) {
            Tips tips = WTCFormUtils.newTips(promptContent, null);
            if (control instanceof AdvContainer) {
                WTCFormUtils.setAdvContainerTips(view, controlKey, tips);
            } else {
                ((TipsSupport)control).addTips(tips);
            }
        }
    }

    public void afterBindData(EventObject evn) {
        String textKey;
        IFormView view = this.getView();
        RichTextEditor richTextEditor = (RichTextEditor)view.getControl(textKey = "richtexteditorap");
        if (richTextEditor == null) {
            return;
        }
        String name = BillTypeEnum.EVECTIONBILL.getBillName();
        Map<String, String> promptMap = WTCFormUtils.getPromptMap(view, null, null, null, Boolean.TRUE, null);
        for (Map.Entry<String, String> entry : promptMap.entrySet()) {
            if (StringUtils.isBlank((CharSequence)entry.getValue())) continue;
            promptMap.put(entry.getKey(), String.format(entry.getValue(), name, name, name, name));
        }
        richTextEditor.setText(promptMap.get(textKey));
    }

    static {
        TIPS_MAP.put("wtp_otcalculrule", (Tuple<Long, String>)new Tuple((Object)1858666120635086848L, (Object)FLEXPANELAP));
        TIPS_MAP.put("wtp_tripcalculrule", (Tuple<Long, String>)new Tuple((Object)1858666120635086848L, (Object)FLEXPANELAP));
        TIPS_MAP.put("wtp_vacalculrule", (Tuple<Long, String>)new Tuple((Object)1858666120635086848L, (Object)FLEXPANELAP));
        TIPS_MAP.put("wtp_exconfig", (Tuple<Long, String>)new Tuple((Object)1858666120635086848L, (Object)"daterangeadvconap"));
        TIPS_MAP.put("wtp_otbaseset", (Tuple<Long, String>)new Tuple((Object)1860081802371266560L, (Object)"flexpanelap1"));
        TIPS_MAP.put("wtp_travelmeter", (Tuple<Long, String>)new Tuple((Object)1860098354017474560L, (Object)"flexpanelap1"));
        TIPS_MAP.put("wtp_vabaseset", (Tuple<Long, String>)new Tuple((Object)1860098354017474560L, (Object)FLEXPANELAP));
    }
}

