/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.components.DateSelCustomConstants;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.CalendarChooseTypeEnum;
import kd.wtc.wtbs.common.enums.CustomControlInteractEnum;
import kd.wtc.wtbs.common.model.customcontrol.CalendarChooseInitModel;
import kd.wtc.wtbs.common.model.customcontrol.CustomControlInteractModel;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class DateConSelectPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
DateSelCustomConstants {
    private static final Log logger = LogFactory.getLog(DateConSelectPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btndetermine"});
        this.addClickListeners(new String[]{"btnempty"});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initCalendar(customParams);
    }

    public void customEvent(CustomEventArgs cea) {
        if ("".equals(cea.getEventArgs())) {
            return;
        }
        List dateChoose = (List)SerializationUtils.fromJsonString((String)cea.getEventArgs(), List.class);
        if (dateChoose.size() == 2) {
            this.setPageDate((String)dateChoose.get(0), (String)dateChoose.get(1));
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btndetermine": {
                HashMap<String, String> returnData = new HashMap<String, String>(16);
                logger.info("DateSelCustomPlugin.click.DETERMINE.starttime:{}", (Object)System.currentTimeMillis());
                if (this.submitCheck(returnData)) {
                    return;
                }
                logger.info("DateSelCustomPlugin.click.DETERMINE.endtime:{}", (Object)System.currentTimeMillis());
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
            case "btnempty": {
                ArrayList<String> dateList = new ArrayList<String>(1);
                this.sendToCustomControl(dateList);
                break;
            }
        }
    }

    private boolean submitCheck(Map<String, String> returnData) {
        Long attFileBo = (Long)this.getView().getFormShowParameter().getCustomParam("attFileBo");
        String entryEntityStr = (String)this.getView().getFormShowParameter().getCustomParam("entryentity");
        DynamicObject entryEntity = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryEntityStr);
        ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.VACATION;
        this.setEntityReturnData(returnData, entryEntity, "entrystartdate", "entryenddate", "entrystarttimetext", "entryendtimetext", "entrystartmethod", "entryendmethod");
        logger.info("DateSelCustomPlugin.submitCheck.VAAPPLY.attFileBo:{}", (Object)attFileBo);
        logger.info("DateSelCustomPlugin.submitCheck.VAAPPLY.entryEntity:{}", (Object)entryEntity);
        return this.showTipCheck(returnData, entryEntity, "entrystartdate", "entryenddate");
    }

    private boolean showTipCheck(Map<String, String> returnData, DynamicObject entryEntity, String startDateSign, String endDateSign) {
        if (HRStringUtils.isEmpty((String)returnData.get("startdate")) || HRStringUtils.isEmpty((String)returnData.get("enddate"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u65e5\u671f\u53ca\u65f6\u95f4\u3002", (String)"DateSelCustomPlugin_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (HRStringUtils.isEmpty((String)returnData.get("startmethod")) || HRStringUtils.isEmpty((String)returnData.get("endmethod"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b8c\u6574\u7684\u65e5\u671f\u53ca\u65f6\u95f4\u3002", (String)"DateSelCustomPlugin_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void setEntityReturnData(Map<String, String> returnData, DynamicObject entryEntity, String startDate, String endDate, String startStr, String endStr, String startType, String endType) {
        returnData.put("startdate", this.getModel().getValue("startdate").toString());
        entryEntity.set(startDate, (Object)WTCDateUtils.str2Date((String)this.getModel().getValue("startdate").toString(), (String)"yyyy-MM-dd"));
        returnData.put("enddate", this.getModel().getValue("enddate").toString());
        entryEntity.set(endDate, (Object)WTCDateUtils.str2Date((String)this.getModel().getValue("enddate").toString(), (String)"yyyy-MM-dd"));
        returnData.put("startmethod", "2");
        entryEntity.set(startType, (Object)"2");
        returnData.put("endmethod", "2");
        entryEntity.set(endType, (Object)"2");
    }

    private void setPageDate(String startDateStr, String endDateStr) {
        this.getModel().setValue("startdate", (Object)startDateStr);
        this.getModel().setValue("enddate", (Object)endDateStr);
    }

    private void initCalendar(Map<String, Object> customParams) {
        ArrayList<String> value = new ArrayList<String>(2);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.INIT.getEvent());
        CalendarChooseInitModel calendarChooseInitModel = new CalendarChooseInitModel();
        calendarChooseInitModel.setCalendarType(CalendarChooseTypeEnum.RANGE);
        if (customParams.size() > 0 && customParams.get("startdate") != null) {
            value.add(customParams.get("startdate").toString());
            value.add(customParams.get("enddate").toString());
            calendarChooseInitModel.setDateList(value);
            this.setPageDate(customParams.get("startdate").toString(), customParams.get("enddate").toString());
            calendarChooseInitModel.setCurrentMonth((String)value.get(0));
        }
        customControlModel.setArgs((Object)calendarChooseInitModel);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }

    private void sendToCustomControl(List<String> dateList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.DATE_DATA.getEvent());
        customControlModel.setArgs(dateList);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }
}

