/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.mobile;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.web.applybill.service.BustripEntityCheckService;
import kd.wtc.wtbs.common.components.DateSelCustomConstants;
import kd.wtc.wtbs.common.components.TypeSelCusStyleEnum;
import kd.wtc.wtbs.common.enums.ApplyBillCheckEnum;
import kd.wtc.wtbs.common.enums.CalendarChooseTypeEnum;
import kd.wtc.wtbs.common.enums.CustomControlInteractEnum;
import kd.wtc.wtbs.common.enums.bill.unify.UnifyBillEnum;
import kd.wtc.wtbs.common.enums.wtctimerange.WtcTimeRangeBtnTypeEnum;
import kd.wtc.wtbs.common.model.BillResponse;
import kd.wtc.wtbs.common.model.customcontrol.CalendarChooseInitModel;
import kd.wtc.wtbs.common.model.customcontrol.CustomControlInteractModel;
import kd.wtc.wtbs.common.util.Tuples;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.formplugin.web.mobile.DateSelCustomUtil;

public class DateSelCustomPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
DateSelCustomConstants {
    private static final Log logger = LogFactory.getLog(DateSelCustomPlugin.class);
    private static Set<String> startDateType = Sets.newHashSet((Object[])new String[]{"labelap3", "labelap4", "labelap5", "labelap6"});
    private static Set<String> endDateType = Sets.newHashSet((Object[])new String[]{"labelap32", "labelap42", "labelap52", "labelap621"});
    private static Map<String, String> START_LABLE = new HashMap<String, String>(4);
    private static Map<String, String> END_LABLE = new HashMap<String, String>(4);
    private static final String APPLY_TIME_TYPE_CACHE = "applyTimeType";
    private static final Set<String> HALF_DAY_CONTROL = Sets.newHashSet((Object[])new String[]{"labelap3", "labelap4", "labelap32", "labelap42", "labelap3212", "labelap4212", "labelap321", "labelap421", "labelap3211", "labelap4211"});
    private static final Set<String> ALL_DAY_CONTROL = Sets.newHashSet((Object[])new String[]{"labelap5", "labelap52121", "labelap52", "labelap521", "labelap5211"});
    private static final Set<String> CUSTOM_CONTROL = Sets.newHashSet((Object[])new String[]{"labelap6", "labelap62", "labelap622", "labelap621", "labelap6211"});
    private Map<WtcTimeRangeBtnTypeEnum, Tuples.Tuple2<String, String>> DEFAULT_CHOSE = new HashMap<WtcTimeRangeBtnTypeEnum, Tuples.Tuple2<String, String>>(16);

    public DateSelCustomPlugin() {
        this.DEFAULT_CHOSE.put(WtcTimeRangeBtnTypeEnum.HALF_UP, (Tuples.Tuple2<String, String>)new Tuples.Tuple2((Object)"labelap3", (Object)"labelap42"));
        this.DEFAULT_CHOSE.put(WtcTimeRangeBtnTypeEnum.HALF_DOWN, (Tuples.Tuple2<String, String>)new Tuples.Tuple2((Object)"labelap3", (Object)"labelap42"));
        this.DEFAULT_CHOSE.put(WtcTimeRangeBtnTypeEnum.DAY, (Tuples.Tuple2<String, String>)new Tuples.Tuple2((Object)"labelap5", (Object)"labelap52"));
        this.DEFAULT_CHOSE.put(WtcTimeRangeBtnTypeEnum.CUSTOM, (Tuples.Tuple2<String, String>)new Tuples.Tuple2((Object)"labelap6", (Object)"labelap621"));
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"labelap3", "labelap4", "labelap5", "labelap6"});
        this.addClickListeners(new String[]{"labelap32", "labelap42", "labelap52", "labelap621"});
        this.addClickListeners(new String[]{"btndetermine"});
        this.addClickListeners(new String[]{"btnempty"});
    }

    public void beforeBindData(EventObject eventObject) {
        this.initApplyTimeCache();
        super.beforeBindData(eventObject);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.initCalendar(customParams);
        if (customParams.size() > 0 && customParams.get("startdate") != null && customParams.get("startmethod") != null) {
            this.initTime(customParams);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapsta", "flexpanelapallday", "flexpanelapend"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"alllableflex"});
        }
        this.hideChoseType();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<WtcTimeRangeBtnTypeEnum> timeBtnEnumByCache = this.getTimeBtnEnumByCache();
        if (timeBtnEnumByCache != null && timeBtnEnumByCache.size() == 1 && timeBtnEnumByCache.get(0) == WtcTimeRangeBtnTypeEnum.DAY) {
            this.getView().setEnable(Boolean.FALSE, ALL_DAY_CONTROL.toArray(new String[0]));
        }
    }

    private void hideChoseType() {
        List<WtcTimeRangeBtnTypeEnum> timeBtnEnumByCache = this.getTimeBtnEnumByCache();
        boolean containsHalf = timeBtnEnumByCache.contains(WtcTimeRangeBtnTypeEnum.HALF_DOWN) && timeBtnEnumByCache.contains(WtcTimeRangeBtnTypeEnum.HALF_UP);
        boolean containsAll = timeBtnEnumByCache.contains(WtcTimeRangeBtnTypeEnum.DAY);
        boolean containsCustom = timeBtnEnumByCache.contains(WtcTimeRangeBtnTypeEnum.CUSTOM);
        this.getView().setVisible(Boolean.valueOf(containsHalf), HALF_DAY_CONTROL.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(containsAll), ALL_DAY_CONTROL.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(containsCustom), CUSTOM_CONTROL.toArray(new String[0]));
    }

    private void initApplyTimeCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ArrayList initType = new ArrayList(10);
        if (WTCCollections.isNotEmpty((Map)customParams)) {
            List applyTypes = (List)customParams.get("APPLY_TIME_TYPE");
            if (WTCCollections.isNotEmpty((Collection)applyTypes)) {
                for (Integer btnEnum : applyTypes) {
                    initType.add(WtcTimeRangeBtnTypeEnum.getEnumByCode((int)btnEnum));
                }
            }
            int step = 1;
            Object stepObj = customParams.get("APPLY_TIME_STEP");
            if (stepObj != null && HRStringUtils.isNotEmpty((String)(stepObj + ""))) {
                step = Integer.parseInt(stepObj + "");
            }
            this.getView().getPageCache().put("APPLY_TIME_STEP", step + "");
        }
        if (WTCCollections.isEmpty(initType)) {
            initType = Lists.newArrayList((Object[])new WtcTimeRangeBtnTypeEnum[]{WtcTimeRangeBtnTypeEnum.HALF_UP, WtcTimeRangeBtnTypeEnum.HALF_DOWN, WtcTimeRangeBtnTypeEnum.DAY, WtcTimeRangeBtnTypeEnum.CUSTOM});
        }
        this.getView().getPageCache().put(APPLY_TIME_TYPE_CACHE, JSON.toJSONString(initType));
    }

    private List<WtcTimeRangeBtnTypeEnum> getTimeBtnEnumByCache() {
        String applyType = this.getView().getPageCache().get(APPLY_TIME_TYPE_CACHE);
        if (HRStringUtils.isEmpty((String)applyType)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)applyType, WtcTimeRangeBtnTypeEnum.class);
    }

    public void customEvent(CustomEventArgs cea) {
        if ("".equals(cea.getEventArgs())) {
            return;
        }
        List dateChoose = (List)SerializationUtils.fromJsonString((String)cea.getEventArgs(), List.class);
        if (dateChoose.size() == 2) {
            Map<String, Object> unCheckedMap = this.getUnCheckedMap();
            this.getView().getPageCache().put("firsttime", null);
            this.getView().getPageCache().put("secondtime", null);
            this.getView().getPageCache().put("starttimetype", null);
            this.getView().getPageCache().put("endtimetype", null);
            this.getView().updateControlMetadata("labelap3", unCheckedMap);
            this.getView().updateControlMetadata("labelap4", unCheckedMap);
            this.getView().updateControlMetadata("labelap5", unCheckedMap);
            this.getView().updateControlMetadata("labelap6", unCheckedMap);
            this.getView().updateControlMetadata("labelap32", unCheckedMap);
            this.getView().updateControlMetadata("labelap42", unCheckedMap);
            this.getView().updateControlMetadata("labelap52", unCheckedMap);
            this.getView().updateControlMetadata("labelap621", unCheckedMap);
            this.getView().getPageCache().put("isSameDate", "1");
            this.setStartOptionDate();
            this.setEndOptionDate();
            this.setPageDate((String)dateChoose.get(0), (String)dateChoose.get(1));
            Tuples.Tuple2<String, String> defaultType = this.getDefaultType();
            this.clickStartDateType((String)defaultType.item1, this.getSelectMap(), this.getUnCheckedMap());
            this.clickEndDateType((String)defaultType.item2, this.getSelectMap(), this.getUnCheckedMap());
        }
    }

    private Tuples.Tuple2<String, String> getDefaultType() {
        List<WtcTimeRangeBtnTypeEnum> timeBtnEnumByCache = this.getTimeBtnEnumByCache();
        if (WTCCollections.isEmpty(timeBtnEnumByCache)) {
            Tuples.Tuple2<String, String> val = this.DEFAULT_CHOSE.get(WtcTimeRangeBtnTypeEnum.DAY);
            return new Tuples.Tuple2(val.item1, val.item2);
        }
        WtcTimeRangeBtnTypeEnum defaultType = timeBtnEnumByCache.get(0);
        Tuples.Tuple2<String, String> defaultShow = this.DEFAULT_CHOSE.get(defaultType);
        if (defaultShow.item1 == null || defaultShow.item2 == null) {
            Tuples.Tuple2<String, String> val = this.DEFAULT_CHOSE.get(WtcTimeRangeBtnTypeEnum.DAY);
            return new Tuples.Tuple2(val.item1, val.item2);
        }
        return defaultShow;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        Map<String, Object> selectMap = this.getSelectMap();
        Map<String, Object> unCheckedMap = this.getUnCheckedMap();
        if (startDateType.contains(key)) {
            this.clickStartDateType(key, selectMap, unCheckedMap);
        } else if (endDateType.contains(key)) {
            this.clickEndDateType(key, selectMap, unCheckedMap);
        } else {
            switch (key) {
                case "btndetermine": {
                    HashMap<String, String> returnData = new HashMap<String, String>(16);
                    logger.info("DateSelCustomPlugin.click.DETERMINE.starttime:{}", (Object)System.currentTimeMillis());
                    if (this.submitCheck(returnData)) {
                        return;
                    }
                    logger.info("DateSelCustomPlugin.click.DETERMINE.endtime:{}", (Object)System.currentTimeMillis());
                    this.getView().returnDataToParent(returnData);
                    this.getView().close();
                    break;
                }
                case "btnempty": {
                    ArrayList<String> dateList = new ArrayList<String>(1);
                    this.sendToCustomControl(dateList);
                    this.setDateTimeComp();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"firstTimeRange")) {
            if (null != closedCallBackEvent.getReturnData()) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                List list = (List)returnData.get("text");
                if (list.size() == 1) {
                    this.getView().getPageCache().put("firsttime", (String)list.get(0));
                } else {
                    this.getView().getPageCache().put("firsttime", (String)list.get(0));
                    this.getView().getPageCache().put("secondtime", (String)list.get(1));
                }
                Label label = (Label)this.getView().getControl("labelap6");
                label.setText(StringUtils.join((Object[])list.toArray(), (String)"-"));
            } else {
                if ("1".equals(this.getView().getPageCache().get("isSameDate"))) {
                    this.getView().getPageCache().put("starttimetype", null);
                    this.getView().getPageCache().put("endtimetype", null);
                    this.getView().getPageCache().put("firsttime", null);
                    this.getView().getPageCache().put("secondtime", null);
                } else {
                    this.getView().getPageCache().put("starttimetype", null);
                    this.getView().getPageCache().put("firsttime", null);
                }
                this.setStartOptionDate();
            }
        } else if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"secondTimeRange")) {
            if (null != closedCallBackEvent.getReturnData()) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                List list = (List)returnData.get("text");
                if (list.size() == 1) {
                    this.getView().getPageCache().put("secondtime", (String)list.get(0));
                }
                Label label = (Label)this.getView().getControl("labelap621");
                label.setText((String)list.get(0));
            } else {
                this.getView().getPageCache().put("endtimetype", null);
                this.getView().getPageCache().put("secondtime", null);
                this.setEndOptionDate();
            }
        }
    }

    private void clickStartDateType(String key, Map<String, Object> selectMap, Map<String, Object> unCheckedMap) {
        this.getView().updateControlMetadata("labelap3", unCheckedMap);
        this.getView().updateControlMetadata("labelap4", unCheckedMap);
        this.getView().updateControlMetadata("labelap5", unCheckedMap);
        this.getView().updateControlMetadata("labelap6", unCheckedMap);
        this.getView().updateControlMetadata("labelap32", unCheckedMap);
        this.getView().updateControlMetadata("labelap42", unCheckedMap);
        this.getView().updateControlMetadata("labelap52", unCheckedMap);
        this.getView().updateControlMetadata("labelap621", unCheckedMap);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapsta"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapend", "flexpanelapallday", "flexpanelapnotdis"});
        this.getView().updateControlMetadata(key, selectMap);
        switch (key) {
            case "labelap3": {
                this.getView().getPageCache().put("starttimetype", "0");
                if ("1".equals(this.getView().getPageCache().get("isSameDate"))) {
                    this.getView().getPageCache().put("endtimetype", "0");
                    break;
                }
                this.getView().getPageCache().put("firsttime", null);
                this.getView().getPageCache().put("endtimetype", null);
                this.getView().getPageCache().put("secondtime", null);
                this.setStartOptionDate();
                this.setEndOptionDate();
                break;
            }
            case "labelap4": {
                this.getView().getPageCache().put("starttimetype", "1");
                if ("1".equals(this.getView().getPageCache().get("isSameDate"))) {
                    this.getView().getPageCache().put("endtimetype", "1");
                    break;
                }
                this.getView().getPageCache().put("firsttime", null);
                this.getView().getPageCache().put("endtimetype", null);
                this.getView().getPageCache().put("secondtime", null);
                this.setStartOptionDate();
                this.setEndOptionDate();
                break;
            }
            case "labelap5": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapallday"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapsta", "flexpanelapend", "flexpanelapnotdis"});
                this.getView().getPageCache().put("starttimetype", "2");
                if ("1".equals(this.getView().getPageCache().get("isSameDate"))) {
                    this.getView().getPageCache().put("endtimetype", "2");
                    break;
                }
                this.getView().getPageCache().put("firsttime", null);
                this.getView().getPageCache().put("endtimetype", null);
                this.getView().getPageCache().put("secondtime", null);
                this.setStartOptionDate();
                this.setEndOptionDate();
                break;
            }
            case "labelap6": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapend"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapsta", "flexpanelapallday", "flexpanelapnotdis"});
                this.getView().getPageCache().put("starttimetype", "3");
                String isSameDate = this.getView().getPageCache().get("isSameDate");
                String timeType = "1";
                if ("1".equals(isSameDate)) {
                    this.getView().getPageCache().put("endtimetype", "3");
                    timeType = "2";
                } else {
                    this.getView().getPageCache().put("endtimetype", null);
                    this.getView().getPageCache().put("secondtime", null);
                    this.setEndOptionDate();
                }
                ArrayList<String> timeRange = new ArrayList<String>(2);
                if (this.getView().getPageCache().get("firsttime") != null) {
                    timeRange.add(this.getView().getPageCache().get("firsttime"));
                }
                if (this.getView().getPageCache().get("secondtime") != null) {
                    timeRange.add(this.getView().getPageCache().get("secondtime"));
                }
                CloseCallBack firstCloseCallBack = new CloseCallBack((IFormPlugin)this, "firstTimeRange");
                this.showTimeRange(timeType, timeRange, firstCloseCallBack);
                break;
            }
        }
    }

    private void clickEndDateType(String key, Map<String, Object> selectMap, Map<String, Object> unCheckedMap) {
        this.getView().updateControlMetadata("labelap32", unCheckedMap);
        this.getView().updateControlMetadata("labelap42", unCheckedMap);
        this.getView().updateControlMetadata("labelap52", unCheckedMap);
        this.getView().updateControlMetadata("labelap621", unCheckedMap);
        this.getView().updateControlMetadata(key, selectMap);
        switch (key) {
            case "labelap32": {
                this.getView().getPageCache().put("endtimetype", "0");
                break;
            }
            case "labelap42": {
                this.getView().getPageCache().put("endtimetype", "1");
                break;
            }
            case "labelap52": {
                this.getView().getPageCache().put("endtimetype", "2");
                break;
            }
            case "labelap621": {
                this.getView().getPageCache().put("endtimetype", "3");
                ArrayList<String> timeRange = new ArrayList<String>(2);
                if (this.getView().getPageCache().get("secondtime") != null) {
                    timeRange.add(this.getView().getPageCache().get("secondtime"));
                }
                CloseCallBack secondCloseCallBack = new CloseCallBack((IFormPlugin)this, "secondTimeRange");
                this.showTimeRange("1", timeRange, secondCloseCallBack);
                break;
            }
        }
    }

    private void setStartOptionDate() {
        Label label = (Label)this.getView().getControl("labelap6");
        label.setText(ResManager.loadKDString((String)"\u65f6\u5206", (String)"DateSelCustomPlugin_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
    }

    private void setEndOptionDate() {
        Label label = (Label)this.getView().getControl("labelap621");
        label.setText(ResManager.loadKDString((String)"\u65f6\u5206", (String)"DateSelCustomPlugin_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
    }

    private boolean submitCheck(Map<String, String> returnData) {
        String pageType = (String)this.getView().getFormShowParameter().getCustomParam("pagetype");
        if (TypeSelCusStyleEnum.BUSITRIP.getEvent().equals(pageType)) {
            Long attFileBo = (Long)this.getView().getFormShowParameter().getCustomParam("attFileBo");
            String entryEntityStr = (String)this.getView().getFormShowParameter().getCustomParam("entryentity");
            DynamicObject entryEntity = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)entryEntityStr);
            UnifyBillEnum infoEnum = UnifyBillEnum.TP;
            ApplyBillCheckEnum checkEnum = ApplyBillCheckEnum.BUSTRIP;
            boolean entryReturnDataSuccess = DateSelCustomUtil.setEntityReturnData(this.getModel(), this.getView(), returnData, entryEntity, "startdate", "enddate", "startdatestr", "enddatestr", "startmethod", "endmethod");
            if (!entryReturnDataSuccess) {
                return true;
            }
            logger.info("DateSelCustomPlugin.submitCheck.BUSITRIP.attFileBo:{}", (Object)attFileBo);
            logger.info("DateSelCustomPlugin.submitCheck.BUSITRIP.entryEntity:{}", (Object)entryEntity);
            if (DateSelCustomUtil.showTipCheck(this.getView(), returnData, entryEntity, "startdate", "enddate")) {
                return true;
            }
            String parentPageId = this.getView().getFormShowParameter().getParentPageId();
            IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
            if (viewNoPlugin == null) {
                return true;
            }
            BustripEntityCheckService billCommonCheckHelper = new BustripEntityCheckService(attFileBo, infoEnum, checkEnum, entryEntity, viewNoPlugin.getEntityId(), this.getView().getFormShowParameter().getAppId());
            if (entryEntity.get("busitriptype") != null) {
                logger.info("DateSelCustomPlugin.submitCheck.busitriptype.starttime:{}", (Object)System.currentTimeMillis());
                BillResponse billResponse = billCommonCheckHelper.checkBaseSet();
                logger.info("DateSelCustomPlugin.submitCheck.busitriptype.endtime:{}", (Object)System.currentTimeMillis());
                if (!billResponse.isSuccess()) {
                    this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                    logger.info("DateSelCustomPlugin.submitCheck.BUSITRIP.Message:{}", billResponse.getMessage().get(0));
                    return true;
                }
            } else {
                BillResponse billResponse = billCommonCheckHelper.checkStartDateAndEndDate();
                logger.info("DateSelCustomPlugin.submitCheck.NOTYPE.billResponse:{}", (Object)billResponse);
                if (!billResponse.isSuccess()) {
                    this.getView().showTipNotification((String)billResponse.getMessage().get(0));
                    logger.info("DateSelCustomPlugin.submitCheck.NOTYPE.Message:{}", billResponse.getMessage().get(0));
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private void showTimeRange(String timeType, List<String> timeRange, CloseCallBack firstCloseCallBack) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wtbs_timerange");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("timeType", (Object)timeType);
        showParameter.setCustomParam("timeRange", timeRange);
        showParameter.setCustomParam("APPLY_TIME_STEP", (Object)this.getView().getPageCache().get("APPLY_TIME_STEP"));
        showParameter.setCloseCallBack(firstCloseCallBack);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setPageDate(String startDateStr, String endDateStr) {
        Date startDate = WTCDateUtils.str2Date((String)startDateStr, (String)"yyyy-MM-dd");
        Date endDate = WTCDateUtils.str2Date((String)endDateStr, (String)"yyyy-MM-dd");
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        int days = (int)((endTime - startTime) / 86400000L) - 1;
        this.getView().setVisible(Boolean.TRUE, new String[]{"alllableflex"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapnotdis"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapsta", "flexpanelapallday", "flexpanelapend"});
        this.getView().getPageCache().put("isSameDate", "0");
        if (startDateStr.equals(endDateStr)) {
            this.getView().getPageCache().put("isSameDate", "1");
            this.getModel().setValue("startdate", (Object)startDateStr);
            this.getModel().setValue("enddate", (Object)endDateStr);
            this.setDateText(startDateStr, "startdatestr");
            this.setDateText(endDateStr, "enddatestr");
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1", "labelap2", "flexpanelap31", "flexpanelap41", "flexpanelap311", "flexpanelap42"});
        } else if (days > 0) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1", "labelap2", "flexpanelap31", "flexpanelap41", "flexpanelap311", "flexpanelap42"});
            this.getModel().setValue("startdate", (Object)startDateStr);
            this.getModel().setValue("enddate", (Object)endDateStr);
            this.setDateText(startDateStr, "startdatestr");
            this.setDateText(endDateStr, "enddatestr");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendarStr = Calendar.getInstance();
            calendarStr.setTime(startDate);
            calendarStr.add(5, 1);
            Calendar calendarEnd = Calendar.getInstance();
            calendarEnd.setTime(endDate);
            calendarEnd.add(5, -1);
            if (calendarStr.getTime().getTime() == calendarEnd.getTime().getTime()) {
                this.getModel().setValue("middate", (Object)dateFormat.format(calendarStr.getTime()));
                this.setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calendarStr.getTime()), "middatestr");
            } else {
                this.getModel().setValue("middate", (Object)(dateFormat.format(calendarStr.getTime()) + "~" + dateFormat.format(calendarEnd.getTime())));
                this.setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calendarStr.getTime()) + "~" + WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)calendarEnd.getTime()), "middatestr");
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"labelap1", "labelap2", "flexpanelap31", "flexpanelap41", "flexpanelap311", "flexpanelap42"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap31", "flexpanelap41"});
            this.getModel().setValue("startdate", (Object)startDateStr);
            this.getModel().setValue("enddate", (Object)endDateStr);
            this.setDateText(startDateStr, "startdatestr");
            this.setDateText(endDateStr, "enddatestr");
        }
    }

    private void setDateText(Object startDateStr, String labelKey) {
        Label label = (Label)this.getView().getControl(labelKey);
        if (label != null) {
            String dateStr;
            String string = dateStr = startDateStr != null ? startDateStr.toString() : "";
            if (HRStringUtils.isNotEmpty((String)dateStr)) {
                Date date = WTCDateUtils.str2Date((String)dateStr, (String)"yyyy-MM-dd");
                if (date != null) {
                    label.setText(WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)date));
                }
            } else {
                label.setText("");
            }
        }
    }

    private void setText(Object text, String labelKey) {
        Label label = (Label)this.getView().getControl(labelKey);
        if (label != null) {
            String textStr = text != null ? text.toString() : "";
            label.setText(textStr);
        }
    }

    private Map<String, Object> getSelectMap() {
        HashMap<String, Object> mainMap = new HashMap<String, Object>(3);
        HashMap sMap = new HashMap(1);
        HashMap<String, String> bMap = new HashMap<String, String>(4);
        bMap.put("r", "1px_solid_var(--kd-cq-theme-color, #276ff5)");
        bMap.put("l", "1px_solid_var(--kd-cq-theme-color, #276ff5)");
        bMap.put("t", "1px_solid_var(--kd-cq-theme-color, #276ff5)");
        bMap.put("b", "1px_solid_var(--kd-cq-theme-color, #276ff5)");
        sMap.put("b", bMap);
        mainMap.put("fc", "var(--kd-cq-theme-color, #276ff5)");
        mainMap.put("bc", "#F2F9FF");
        mainMap.put("s", sMap);
        return mainMap;
    }

    private Map<String, Object> getUnCheckedMap() {
        HashMap<String, Object> mainMap = new HashMap<String, Object>(3);
        HashMap sMap = new HashMap(1);
        HashMap<String, String> bMap = new HashMap<String, String>(4);
        bMap.put("r", "1px_solid_#F2F2F2");
        bMap.put("l", "1px_solid_#F2F2F2");
        bMap.put("t", "1px_solid_#F2F2F2");
        bMap.put("b", "1px_solid_#F2F2F2");
        sMap.put("b", bMap);
        mainMap.put("fc", "#212121");
        mainMap.put("bc", "#F2F2F2");
        mainMap.put("s", sMap);
        return mainMap;
    }

    private void initCalendar(Map<String, Object> customParams) {
        ArrayList<String> value = new ArrayList<String>(2);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.INIT.getEvent());
        CalendarChooseInitModel calendarChooseInitModel = new CalendarChooseInitModel();
        calendarChooseInitModel.setCalendarType(CalendarChooseTypeEnum.RANGE);
        if (customParams.size() > 0 && customParams.get("startdate") != null) {
            value.add(customParams.get("startdate").toString());
            value.add(customParams.get("enddate").toString());
            calendarChooseInitModel.setDateList(value);
            this.setPageDate(customParams.get("startdate").toString(), customParams.get("enddate").toString());
            calendarChooseInitModel.setCurrentMonth((String)value.get(0));
        }
        customControlModel.setArgs((Object)calendarChooseInitModel);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }

    private void sendToCustomControl(List<String> dateList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcalendar");
        CustomControlInteractModel customControlModel = new CustomControlInteractModel();
        customControlModel.setEvent(CustomControlInteractEnum.DATE_DATA.getEvent());
        customControlModel.setArgs(dateList);
        customControlModel.setTimestamp(System.currentTimeMillis());
        customcontrol.setData((Object)customControlModel);
    }

    private void setDateTimeComp() {
        Map<String, Object> unCheckedMap = this.getUnCheckedMap();
        this.getView().updateControlMetadata("labelap3", unCheckedMap);
        this.getView().updateControlMetadata("labelap4", unCheckedMap);
        this.getView().updateControlMetadata("labelap5", unCheckedMap);
        this.getView().updateControlMetadata("labelap6", unCheckedMap);
        this.getView().updateControlMetadata("labelap32", unCheckedMap);
        this.getView().updateControlMetadata("labelap42", unCheckedMap);
        this.getView().updateControlMetadata("labelap52", unCheckedMap);
        this.getView().updateControlMetadata("labelap621", unCheckedMap);
        this.setStartOptionDate();
        this.setEndOptionDate();
        this.getView().getPageCache().put("starttimetype", null);
        this.getView().getPageCache().put("endtimetype", null);
        this.getModel().setValue("startdate", null);
        this.getModel().setValue("enddate", null);
        this.setDateText("", "startdatestr");
        this.setDateText("", "enddatestr");
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapsta", "flexpanelapallday", "flexpanelapend"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"alllableflex"});
    }

    private void initTime(Map<String, Object> customParams) {
        this.getModel().setValue("startdate", (Object)customParams.get("startdate").toString());
        this.getModel().setValue("enddate", (Object)customParams.get("enddate").toString());
        this.setDateText(customParams.get("startdate"), "startdatestr");
        this.setDateText(customParams.get("enddate"), "enddatestr");
        this.getView().getPageCache().put("starttimetype", customParams.get("startmethod").toString());
        this.getView().getPageCache().put("endtimetype", customParams.get("endmethod").toString());
        if ("3".equals(customParams.get("startmethod").toString())) {
            this.getView().getPageCache().put("firsttime", customParams.get("startdatestr").toString());
            this.getView().getPageCache().put("secondtime", customParams.get("enddatestr").toString());
        }
        Map<String, Object> selectMap = this.getSelectMap();
        this.getView().updateControlMetadata(START_LABLE.get(customParams.get("startmethod")), selectMap);
        this.getView().updateControlMetadata(END_LABLE.get(customParams.get("endmethod")), selectMap);
        this.getView().setVisible(Boolean.TRUE, new String[]{"alllableflex"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelapend", "flexpanelapsta", "flexpanelapallday", "flexpanelapnotdis"});
        if (customParams.get("startdate").toString().equals(customParams.get("enddate").toString())) {
            if (customParams.get("startmethod").toString().equals("3")) {
                String time = customParams.get("startdatestr") + "-" + customParams.get("enddatestr");
                Label label = (Label)this.getView().getControl("labelap6");
                label.setText(time);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"labelap1"});
        } else if (customParams.get("startmethod").toString().equals("3")) {
            Label label = (Label)this.getView().getControl("labelap6");
            label.setText(customParams.get("startdatestr").toString());
            Label label1 = (Label)this.getView().getControl("labelap621");
            label1.setText(customParams.get("enddatestr").toString());
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapend"});
        } else if (customParams.get("startmethod").toString().equals("2")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapallday"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelapsta"});
        }
    }

    static {
        START_LABLE.put("0", "labelap3");
        START_LABLE.put("1", "labelap4");
        START_LABLE.put("2", "labelap5");
        START_LABLE.put("3", "labelap6");
        END_LABLE.put("0", "labelap32");
        END_LABLE.put("1", "labelap42");
        END_LABLE.put("2", "labelap52");
        END_LABLE.put("3", "labelap621");
    }
}

