/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.mobile;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.bill.BillCommonService;
import kd.wtc.wtbs.business.bill.BillUnifyService;
import kd.wtc.wtbs.business.mobile.MobilePersonSelHelper;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.model.Page;
import kd.wtc.wtbs.common.model.UserCustomParam;
import kd.wtc.wtbs.common.model.UserListEntry;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class MobilePersonPlugin
extends AbstractMobFormPlugin {
    private static final int initPageSize = 20;
    private static final Log logger = LogFactory.getLog(MobilePersonPlugin.class);

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String applytype = (String)parameter.getCustomParam("applytype");
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)3);
        Long userId = BillUnifyService.getUserId((IFormView)this.getView());
        if (Objects.isNull(userId)) {
            throw new KDBizException(new ErrorCode("500", ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MobilePersonPlugin_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        UserCustomParam userCustomParam = new UserCustomParam();
        userCustomParam.setSearchType(applytype);
        userCustomParam.setUserId(String.valueOf(userId));
        userCustomParam.setSearchContent(null);
        userCustomParam.setPageSize(20);
        userCustomParam.setPageNum(0);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView viewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
        String appId = null;
        if (viewNoPlugin != null) {
            appId = BillCommonService.getInstance().getAuthAppIdForFormPlugin(viewNoPlugin);
        }
        appId = HRStringUtils.isNotEmpty(appId) ? appId : this.getView().getFormShowParameter().getAppId();
        userCustomParam.setAppId(appId);
        userCustomParam.setAuthField("attfilebasef7");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String authEntity = parentView.getEntityId();
            if ("wtpm_supsignpc".equals(authEntity)) {
                authEntity = "wtpm_supsignpcqueryconf";
            }
            userCustomParam.setAuthEntity(authEntity);
        }
        userCustomParam.setContainCurrentUser(true);
        customParam.put("cusParam_searchParam", JSONObject.toJSONString((Object)userCustomParam));
        if ("0".equals(applytype)) {
            MobilePersonSelHelper instance = MobilePersonSelHelper.getInstance();
            Page dynamicObjectPage = instance.getAttFileF7ByName(userCustomParam);
            List mapList = instance.getFileF7Result(dynamicObjectPage.getListRecords());
            logger.info("MobilePersonPlugin.afterCreateNewData.applytype0_userId:{}", (Object)userId);
            logger.info("MobilePersonPlugin.afterCreateNewData.applytype0_mapList:{}", (Object)mapList);
            int totalPage = 0;
            if (userId != null) {
                totalPage = dynamicObjectPage.getTotalPage();
            }
            logger.info("MobilePersonPlugin.afterCreateNewData.applytype0_totalPage:{}", (Object)totalPage);
            customParam.put("cusParam_searchData", this.transUserListObject(mapList));
            customParam.put("cusParam_searchPage", JSONObject.toJSONString((Object)totalPage));
        }
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        customcontrol.setData((Object)customParam);
    }

    private String transUserListObject(List<Map<String, String>> mapList) {
        ArrayList<UserListEntry> userList = new ArrayList<UserListEntry>(mapList.size());
        for (Map<String, String> item : mapList) {
            String headsculpture;
            String imgUrl = "";
            Map personBaseInfo = HRPIMServiceImpl.getInstance().getPersonBaseInfo(Long.valueOf(Long.parseLong(item.get("attperson.id"))));
            if (personBaseInfo != null && personBaseInfo.get("headsculpture") != null && !HRStringUtils.isEmpty((String)(headsculpture = personBaseInfo.get("headsculpture").toString())) && !headsculpture.contains("default_person_82_82")) {
                imgUrl = HRImageUrlUtil.getImageFullUrl((String)headsculpture);
            }
            UserListEntry userListEntry = new UserListEntry(imgUrl, item.get("attperson.id"), item.get("attperson.name"), item.get("attperson.number"), item.get("boid"), item.get("id"), item.get("org.name"));
            userList.add(userListEntry);
        }
        return JSONObject.toJSONString(userList);
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        switch (eventName) {
            case "employee_search": {
                this.searchEmployee(eventArgs);
                break;
            }
            case "employee_select": {
                this.selectEmployee(eventArgs);
                break;
            }
            case "employee_close": {
                this.closePage();
                break;
            }
        }
    }

    private void searchEmployee(String eventArgs) {
        UserCustomParam userCustomParam = (UserCustomParam)JSONObject.parseObject((String)eventArgs, UserCustomParam.class);
        String key = String.valueOf(userCustomParam.getSearchContent());
        String searchType = userCustomParam.getSearchType();
        HashMap customParam = Maps.newHashMapWithExpectedSize((int)3);
        CustomControl customcontrol = (CustomControl)this.getView().getControl("customcontrolap");
        MobilePersonSelHelper queryInstance = MobilePersonSelHelper.getInstance();
        if ("0".equals(searchType)) {
            userCustomParam.setSearchContent(null);
            userCustomParam.setContainCurrentUser(true);
            Page dynamicObjectPage = queryInstance.getAttFileF7ByName(userCustomParam);
            List mapList = queryInstance.getFileF7Result(dynamicObjectPage.getListRecords());
            logger.info("MobilePersonPlugin.searchEmployee.applytype0_userId:{}", (Object)userCustomParam.getUserId());
            logger.info("MobilePersonPlugin.searchEmployee.applytype0_mapList:{}", (Object)mapList);
            customParam.put("cusParam_searchData", JSONObject.toJSONString((Object)mapList));
        } else if (!StringUtils.isEmpty((String)key)) {
            userCustomParam.setUserId("0");
            userCustomParam.setSearchContent(key);
            userCustomParam.setContainCurrentUser(false);
            userCustomParam.setView(this.getView());
            Page attFileF7ByName = queryInstance.getAttFileF7ByName(userCustomParam);
            List mapList = queryInstance.getFileF7Result(attFileF7ByName.getListRecords());
            logger.info("MobilePersonPlugin.searchEmployee.applytype1_key:{}", (Object)key);
            logger.info("MobilePersonPlugin.searchEmployee.applytype1_mapList:{}", (Object)mapList);
            int totalPage = attFileF7ByName.getTotalPage();
            logger.info("MobilePersonPlugin.searchEmployee.applytype1_totalPage:{}", (Object)totalPage);
            customParam.put("cusParam_searchData", this.transUserListObject(mapList));
            customParam.put("cusParam_searchPage", JSONObject.toJSONString((Object)totalPage));
        }
        customcontrol.setData((Object)customParam);
    }

    private void selectEmployee(String eventArgs) {
        UserListEntry userListEntry = (UserListEntry)JSONObject.parseObject((String)eventArgs, UserListEntry.class);
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("personid", userListEntry.getPersonId());
        map.put("attfile", userListEntry.getBoid());
        map.put("id", userListEntry.getId());
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void closePage() {
        this.getView().returnDataToParent(null);
        this.getView().close();
    }
}

