/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class WTCPresetDeleteForbidList
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(WTCPresetDeleteForbidList.class);
    private boolean isCancel = false;
    private static final Set<String> preSetOpList = Sets.newHashSet((Object[])new String[]{"delete", "his_delete"});

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String operationKey = evt.getOperationKey();
        String string = operationKey = HRStringUtils.isEmpty((String)operationKey) ? evt.getItemKey() : operationKey;
        if (!evt.isCancel() && this.checkSysPreData(operationKey)) {
            evt.setCancel(true);
            this.isCancel = true;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.isCancel) {
            return;
        }
        String operationKey = ((FormOperate)args.getSource()).getOperateKey();
        boolean sysPreData = this.checkSysPreData(operationKey);
        if (!args.isCancel() && sysPreData) {
            args.setCancel(true);
        }
    }

    private boolean checkSysPreData(String operationKey) {
        try {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows) && !"showhisversion".equals(customParams.get("option"))) {
                return false;
            }
            boolean isHisDisableOp = false;
            if (preSetOpList.contains(operationKey) && this.getView() instanceof ListView || isHisDisableOp) {
                HRBaseServiceHelper helper;
                DynamicObject[] queryResult;
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                    primaryKeyValues = Collections.singletonList(customParams.get("boid")).toArray();
                }
                if (Stream.of(queryResult = (helper = new HRBaseServiceHelper(((ListView)this.getView()).getBillFormId())).query("issyspreset", new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)})).anyMatch(object -> object.getBoolean("issyspreset"))) {
                    if (isHisDisableOp) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u7981\u7528/\u542f\u7528", (String)"WTCPresetList_2", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u7981\u6b62\u5220\u9664", (String)"WTCPresetList_1", (String)"wtc-wtbs-formplugin", (Object[])new Object[0]));
                    }
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return false;
    }
}

