/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.pluginmgt;

import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.util.WtbsBusinessUtils;
import kd.wtc.wtbs.business.web.SummaryServiceHelper;
import kd.wtc.wtbs.business.web.pluginmgt.PluginManagementService;
import kd.wtc.wtbs.common.constants.pluginmgt.PluginManagementMultiConstants;
import kd.wtc.wtbs.common.enums.WTCCheckLocalStringEnum;
import kd.wtc.wtbs.common.util.RegexUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public class PluginManagementEditPlugin
extends HRDataBaseEdit {
    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        BillShowParameter billShowParameter = (BillShowParameter)preOpenFormEventArgs.getFormShowParameter();
        OperationStatus status = billShowParameter.getStatus();
        String formId = billShowParameter.getFormId();
        if (status == OperationStatus.ADDNEW) {
            billShowParameter.setCaption(this.getAddNewCaptionByByFormId(formId));
        } else {
            Long pkId = Long.valueOf(String.valueOf(billShowParameter.getPkId()));
            DynamicObject dynamicObject = this.getDynamicObjectByFormId(formId, pkId);
            if (status == OperationStatus.VIEW) {
                billShowParameter.setCaption(MessageFormat.format(this.getViewCaptionByByFormId(formId), dynamicObject.getString("name")));
            } else if (status == OperationStatus.EDIT) {
                billShowParameter.setCaption(MessageFormat.format(this.getEditCaptionByByFormId(formId), dynamicObject.getString("name")));
            }
        }
    }

    private String getAddNewCaptionByByFormId(String formId) {
        if (HRStringUtils.equals((String)"wtbs_interfaceregister", (String)formId)) {
            return PluginManagementMultiConstants.saveInterface();
        }
        if (HRStringUtils.equals((String)"wtbs_pluginregister", (String)formId)) {
            return PluginManagementMultiConstants.savePlugin();
        }
        return "";
    }

    private String getEditCaptionByByFormId(String formId) {
        if (HRStringUtils.equals((String)"wtbs_interfaceregister", (String)formId)) {
            return PluginManagementMultiConstants.editInterface();
        }
        if (HRStringUtils.equals((String)"wtbs_pluginregister", (String)formId)) {
            return PluginManagementMultiConstants.editPlugin();
        }
        return "";
    }

    private String getViewCaptionByByFormId(String formId) {
        if (HRStringUtils.equals((String)"wtbs_interfaceregister", (String)formId)) {
            return PluginManagementMultiConstants.viewInterface();
        }
        if (HRStringUtils.equals((String)"wtbs_pluginregister", (String)formId)) {
            return PluginManagementMultiConstants.viewPlugin();
        }
        return "";
    }

    private DynamicObject getDynamicObjectByFormId(String formId, Long pkId) {
        if (HRStringUtils.equals((String)"wtbs_interfaceregister", (String)formId)) {
            return PluginManagementService.interfaceRegisterService.queryOne("name", (Object)pkId);
        }
        if (HRStringUtils.equals((String)"wtbs_pluginregister", (String)formId)) {
            return PluginManagementService.pluginRegisterService.queryOne("name", (Object)pkId);
        }
        return new DynamicObject();
    }

    protected String getAddSummaryName() {
        return WtbsBusinessUtils.getMainEntityDisplayName((String)this.getView().getFormShowParameter().getFormId());
    }

    public void afterBindData(EventObject e) {
        SummaryServiceHelper.showAddSummary((IFormView)this.getView(), (String)this.getAddSummaryName());
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object[] changeSet = propertyChangedArgs.getChangeSet();
        if (HRStringUtils.equals((String)propertyName, (String)"classpath")) {
            Object newValue;
            Object object = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])changeSet, (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])changeSet, (int)0).get()).getNewValue() : null;
            if (Objects.nonNull(newValue)) {
                if (RegexUtils.checkClassPath((String)dataEntity.getString("classpath"))) {
                    String[] split = newValue.toString().split("\\.");
                    this.getModel().setValue("class", (Object)split[split.length - 1]);
                } else {
                    this.getView().showErrorNotification(WTCCheckLocalStringEnum.CLASSPATH_TIPS.getTips());
                }
            } else {
                this.getModel().setValue("class", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            DynamicObject interfaceName;
            Object classpath = this.getModel().getValue("classpath");
            Optional.ofNullable(classpath).ifPresent(val -> {
                if (!RegexUtils.checkClassPath((String)String.valueOf(val))) {
                    this.getView().showErrorNotification(WTCCheckLocalStringEnum.CLASSPATH_TIPS.getTips());
                    args.setCancel(true);
                }
            });
            String formId = this.getView().getFormShowParameter().getFormId();
            if (HRStringUtils.equals((String)"wtbs_pluginregister", (String)formId) && (interfaceName = (DynamicObject)this.getModel().getValue("interface")) == null) {
                this.getView().showErrorNotification(PluginManagementMultiConstants.deleteInterface());
                args.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        String name = this.getModel().getDataEntity().getString("name");
        if (itemKey.equalsIgnoreCase("bar_modify")) {
            FormShowParameter parameter = this.getView().getFormShowParameter();
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setCaption(MessageFormat.format(this.getEditCaptionByByFormId(parameter.getFormId()), name));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult result;
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) && (result = args.getOperationResult()).isSuccess()) {
            String name = this.getModel().getDataEntity().getString("name");
            FormShowParameter parameter = this.getView().getFormShowParameter();
            parameter.setStatus(OperationStatus.VIEW);
            parameter.setCaption(MessageFormat.format(this.getViewCaptionByByFormId(parameter.getFormId()), name));
            this.getView().invokeOperation("refresh");
        }
    }
}

