/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.prompt;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.wtc.wtbs.common.util.third.collect.Maps;

public class PromptCache {
    public static final String WTC_PROMPT = "wtc_prompt";
    private Map<String, String> promptMap;
    private Map<String, List<String>> entryEntityMap;
    private Map<String, Tips> pageTips;

    public Map<String, String> getPromptMap() {
        if (this.promptMap == null) {
            this.promptMap = Maps.newHashMap();
        }
        return this.promptMap;
    }

    public Map<String, Tips> getPageTips() {
        if (this.pageTips == null) {
            this.pageTips = Maps.newHashMap();
        }
        return this.pageTips;
    }

    public Map<String, List<String>> getEntryEntityMap() {
        if (this.entryEntityMap == null) {
            this.entryEntityMap = Maps.newHashMap();
        }
        return this.entryEntityMap;
    }

    public static PromptCache get(IFormView view) {
        String cacheStr = view.getPageCache().get(WTC_PROMPT);
        return cacheStr == null ? new PromptCache() : (PromptCache)SerializationUtils.fromJsonString((String)cacheStr, PromptCache.class);
    }

    public static String getPrompt(IFormView view, String controlKey) {
        return PromptCache.get(view).getPromptMap().get(controlKey);
    }

    public static void put(IFormView view, PromptCache cache) {
        view.getPageCache().put(WTC_PROMPT, SerializationUtils.toJsonString((Object)cache));
    }

    public static void put(IFormView view, String controlKey, String prompt) {
        PromptCache cache = PromptCache.get(view);
        cache.getPromptMap().put(controlKey, prompt);
        PromptCache.put(view, cache);
    }
}

