/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.relate;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.relate.WTCLeftRelateService;
import kd.wtc.wtbs.business.relate.WTCRelatePanelSetFactory;
import kd.wtc.wtbs.common.cache.IWTCAppCache;
import kd.wtc.wtbs.common.cache.relate.WTCAppCache;
import kd.wtc.wtbs.common.enums.AttFileRelateEnum;
import kd.wtc.wtbs.common.model.relate.RelatePageInfo;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class WTCRelatePageLeftDynamicPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(WTCRelatePageLeftDynamicPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"imgdown", "imgup"});
    }

    public void initialize() {
        super.initialize();
        WTCLeftRelateService.hidePartTwoPanel((IFormView)this.getView());
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        logger.info("loadCustomControlMetas0");
        WTCLeftRelateService.buildLeft((LoadCustomControlMetasArgs)args);
    }

    public void onGetControl(OnGetControlArgs args) {
        this.bindClickEventEveryRows(args);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String configPageNumber = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        boolean isShowTopCommonSearch = WTCLeftRelateService.isShowTopCommonSearch((IFormView)this.getView());
        String currShowPage = this.getCurrShowPage(configPageNumber, isShowTopCommonSearch);
        Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
        WTCLeftRelateService.showRelatedPageInContainer((IFormView)this.getView(), (String)currShowPage, (boolean)isShowTopCommonSearch);
        WTCLeftRelateService.setSelectRelatePageLabelStyle((IFormView)this.getView(), (String)currShowPage, (Map)pageIconMap);
    }

    private String getCurrShowPage(String configPageNumber, boolean isShowTopCommonSearch) {
        IWTCAppCache iwtcAppCache;
        String currShowPage;
        if (isShowTopCommonSearch && StringUtils.isNotBlank((CharSequence)(currShowPage = (String)(iwtcAppCache = WTCAppCache.get((String)"currShowPageNumber")).get("currShowPageNumber", String.class))) && !currShowPage.equals(configPageNumber)) {
            return currShowPage;
        }
        return configPageNumber;
    }

    public void click(EventObject evt) {
        super.click(evt);
        IFormView view = this.getView();
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelPageId = curClickLabel.getKey();
            WTCLeftRelateService.hidePartTwoPanel((IFormView)view);
            Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
            boolean isShowTopCommonSearch = WTCLeftRelateService.isShowTopCommonSearch((IFormView)this.getView());
            WTCLeftRelateService.setSelectRelatePageLabelStyle((IFormView)this.getView(), (String)curClickLabel.getKey(), (Map)pageIconMap);
            WTCLeftRelateService.showRelatedPageInContainer((IFormView)this.getView(), (String)labelPageId, (boolean)isShowTopCommonSearch);
            this.getPageCache().put("currentRelatePage", labelPageId);
        } else if (evt.getSource() instanceof Vector) {
            Vector clickImg = (Vector)evt.getSource();
            if (clickImg.getKey().equals("imgup")) {
                WTCLeftRelateService.hidePartTwoPanel((IFormView)view);
            } else if (clickImg.getKey().equals("imgdown")) {
                WTCLeftRelateService.showPartTwoPanel((IFormView)view);
            }
        }
    }

    public void bindClickEventEveryRows(OnGetControlArgs args) {
        FormView formView = (FormView)args.getSource();
        String key = args.getKey();
        String relateEntityTypeId = (String)formView.getFormShowParameter().getCustomParam("wtbs_entitytype_id");
        if (HRStringUtils.isEmpty((String)key) || !AttFileRelateEnum.getAllShellPageIdList().contains(key) && !key.contains("schedule") && !key.contains("attstateinfo")) {
            return;
        }
        String appNumber = (String)formView.getFormShowParameter().getCustomParam("appName");
        List pageInfoList = WTCRelatePanelSetFactory.getRelatePageInfoList((String)appNumber, (String)relateEntityTypeId);
        for (RelatePageInfo pageInfo : pageInfoList) {
            String pageId = pageInfo.getPageNumber();
            if (!key.equals(pageId)) continue;
            Label relatePageLabel = new Label();
            relatePageLabel.setKey(pageId);
            relatePageLabel.setView(this.getView());
            relatePageLabel.addClickListener((ClickListener)this);
            args.setControl((Control)relatePageLabel);
        }
    }
}

