/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.rulecontrol;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.business.personfilter.enums.RuleParamTypeEnum;
import kd.wtc.wtbs.business.rulecontrol.RuleConditionService;
import kd.wtc.wtbs.business.rulecontrol.RuleCusCacheService;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlF7Service;
import kd.wtc.wtbs.business.rulecontrol.RuleCusControlService;
import kd.wtc.wtbs.business.rulecontrol.RuleOperatorsTypeService;
import kd.wtc.wtbs.business.rulecontrol.entity.RuleControlCfgInfo;
import kd.wtc.wtbs.common.rulecontrol.RuleCusControlConstants;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class RuleCusControlPlugin
extends HRDataBaseEdit
implements RuleCusControlConstants {
    private static final Log LOG = LogFactory.getLog(RuleCusControlPlugin.class);
    private static final String ACTION_SHOWDATE = "showDate";

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propKey = args.getProperty().getName();
        if ("ruledate".equals(propKey)) {
            Object newValue;
            String setDateFormatCache = this.getPageCache().get("ruledate_value_is_set");
            if ("true".equals(setDateFormatCache)) {
                this.getPageCache().remove("ruledate_value_is_set");
                return;
            }
            Object object = newValue = WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).isPresent() ? ((ChangeData)WTCCollectionIndexUtil.getEleFromArr((Object[])args.getChangeSet(), (int)0).get()).getNewValue() : null;
            if (newValue == null) {
                return;
            }
            Date date = (Date)newValue;
            String dateStr = WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd");
            String key = RuleCusCacheService.getShowDateControlKey((IFormView)this.getView());
            RuleConditionService.getInstance((String)key).setView(this.getView()).setDate(dateStr);
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        boolean useCfgInited = RuleCusCacheService.isUseCfgInited((IFormView)this.getView());
        if (!useCfgInited) {
            RuleCusCacheService.initSceneUseCfg((IFormView)this.getView());
        }
        this.initControl();
    }

    public void customEvent(CustomEventArgs args) {
        super.customEvent(args);
        String eventName = args.getEventName();
        if ("setValue".equals(eventName)) {
            RuleCusCacheService.cacheControlValue((IFormView)this.getView(), (String)args.getKey(), (String)RuleCusControlService.getConvertArgValue((String)this.getView().getEntityId(), (String)args.getEventArgs()));
        } else if ("openParamF7".equals(eventName)) {
            this.openParamF7(args, this.getCreateOrgId());
        } else if ("openExpressView".equals(eventName)) {
            this.openExpressView(args);
        } else if ("setDateFormat".equals(eventName)) {
            JSONObject requestParams = RuleCusControlService.getRequestParams((String)args.getEventArgs());
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity();
            if (dataEntity.containsProperty("ruledate")) {
                try {
                    boolean noSetRuleDateValue;
                    Date date = model.getDataEntity().getDate("ruledate");
                    Date oldDate = date == null ? null : WTCDateUtils.getZeroDate((Date)date);
                    String paramValue = requestParams.getString("paramValue");
                    Date paramDate = HRStringUtils.isEmpty((String)paramValue) ? null : WTCDateUtils.parseDate((String)paramValue, (String)"yyyy-MM-dd");
                    boolean bl = noSetRuleDateValue = oldDate == paramDate || paramDate == null || paramDate.equals(oldDate);
                    if (!noSetRuleDateValue) {
                        this.getPageCache().put("ruledate_value_is_set", "true");
                        this.getModel().setValue("ruledate", (Object)paramDate);
                        this.getModel().setDataChanged(false);
                    } else if (paramDate == null) {
                        this.getModel().setValue("ruledate", null);
                    }
                }
                catch (Exception ex) {
                    LOG.warn("RuleCusControlPlugin.customEvent \u65f6\u95f4\u683c\u5f0f\u5316\u9519\u8bef", (Throwable)ex);
                }
            }
            this.setDateFormat(args, requestParams);
            RuleCusCacheService.cacheShowDateControlKey((IFormView)this.getView(), (String)args.getKey());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object[] params = closedCallBackEvent.getActionId().split("\\.");
        if (params.length == 4 && (WTCCollectionIndexUtil.getEleFromArr((Object[])params, (int)1).isPresent() ? (String)WTCCollectionIndexUtil.getEleFromArr((Object[])params, (int)1).get() : "").equals("openConditionTargetF7CallBack")) {
            Map f7CallBackParamsMap = RuleCusControlF7Service.getF7CallBack((ClosedCallBackEvent)closedCallBackEvent);
            RuleCusControlService.updateControlData((IFormView)this.getView(), (String)params[0], (String)"paramValue", (Object)f7CallBackParamsMap);
        }
    }

    private void initControl() {
        List ruleControlCfgInfos = RuleCusCacheService.getSceneUseCfg((IFormView)this.getView());
        for (RuleControlCfgInfo cfgInfo : ruleControlCfgInfos) {
            if (cfgInfo.isEnable()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{cfgInfo.getWtcControlNumber()});
                this.getView().setVisible(Boolean.FALSE, new String[]{cfgInfo.getHrControlNumber()});
                this.bindData(cfgInfo, this.getCreateOrgId());
                continue;
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{cfgInfo.getWtcControlNumber()});
            this.getView().setVisible(Boolean.TRUE, new String[]{cfgInfo.getHrControlNumber()});
        }
    }

    private long getCreateOrgId() {
        long createOrgId = -1L;
        if (HRStringUtils.equals((String)"wtp_timecutconfig", (String)this.getView().getEntityId())) {
            Map entryInfo;
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (null != customParams && customParams.containsKey("entry_info") && null != (entryInfo = (Map)customParams.get("entry_info")) && entryInfo.containsKey("createorg") && null != entryInfo.get("createorg")) {
                createOrgId = Long.parseLong(entryInfo.get("createorg").toString());
            }
        } else {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            if (dataEntity.containsProperty("createorg")) {
                createOrgId = dataEntity.getLong("createorg.id");
            }
        }
        return createOrgId;
    }

    private void bindData(RuleControlCfgInfo cfgInfo, long createOrgId) {
        List cusAssignLogicType;
        HashMap data = Maps.newHashMapWithExpectedSize((int)16);
        data.put("initing", "true");
        String key = cfgInfo.getWtcControlNumber();
        RuleConditionService instance = RuleConditionService.getInstance((String)key).setView(this.getView());
        String conditionValue = instance.getValue();
        data.put("value", conditionValue);
        data.put("comparisonOpt", this.getComparisonOperatorsMap(key));
        data.put("conditionExpress", this.getConditionExpress(conditionValue));
        data.put("hideButton", Boolean.FALSE);
        data.put("defaultRows", cfgInfo.getDefaultRows());
        data.put("showDeleteOnlyOneRow", cfgInfo.isOnlyOneShowDelete());
        data.put("showValueType", cfgInfo.isShowValueTypeColumn());
        String pageStatus = this.getPageState(key);
        data.put("pageState", pageStatus);
        long sceneId = cfgInfo.getSceneId();
        DynamicObjectCollection inputParams = RuleCusControlService.querySceneInputParams((long)sceneId);
        if (!CollectionUtils.isEmpty((Collection)inputParams)) {
            data.put("param", this.getInputParam(inputParams, createOrgId, conditionValue));
            data.put("valueParam", this.getInputValueParam(inputParams));
        }
        if (WTCCollections.isNotEmpty((Collection)(cusAssignLogicType = RuleCusCacheService.getCusAssignLogicType((IFormView)this.getView(), (String)key)))) {
            data.put("cusAssignLogicType", cusAssignLogicType);
        }
        RuleCusControlService.updateControlData((IFormView)this.getView(), (String)key, (Object)data);
        RuleCusCacheService.cacheInitStatus((IFormView)this.getView(), (String)key, (boolean)true);
    }

    private void openParamF7(CustomEventArgs args, long createOrgId) {
        String eventArgs = args.getEventArgs();
        Map map = (Map)JSON.parseObject((String)eventArgs, Map.class);
        ListShowParameter openF7Parameter = RuleCusControlF7Service.getOpenF7Parameter((Map)map);
        if (-1L != createOrgId) {
            openF7Parameter.setUseOrgId(createOrgId);
        }
        String key = args.getKey();
        String index = String.valueOf(map.get("index"));
        String entityNumber = (String)map.get("entityNumber");
        openF7Parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RuleCusControlService.getActionId((String[])new String[]{key, "openConditionTargetF7CallBack", index, entityNumber})));
        try {
            this.getView().showForm((FormShowParameter)openF7Parameter);
        }
        catch (KDException exc) {
            String errMsg = ResManager.loadKDString((String)"\u6253\u5f00\u5b9e\u4f53%s\u5217\u8868\u5f02\u5e38\u3002", (String)"RuleCusControlPlugin_0", (String)"wtc-wtbs-formplugin", (Object[])new Object[]{entityNumber});
            this.getView().showErrorNotification(errMsg);
            LOG.warn(errMsg, (Throwable)exc);
        }
    }

    private void openExpressView(CustomEventArgs args) {
        FormShowParameter bill = new FormShowParameter();
        bill.setStatus(OperationStatus.VIEW);
        bill.setFormId("wtbd_ruleexpressview");
        bill.getOpenStyle().setShowType(ShowType.Modal);
        bill.setHasRight(true);
        String eventArgs = args.getEventArgs();
        bill.setCustomParam("conditions", (Object)eventArgs);
        bill.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
        this.getView().showForm(bill);
    }

    private void setDateFormat(CustomEventArgs args, JSONObject requestParams) {
        String dateFormat = requestParams.getString("dateFormat");
        if (StringUtils.isEmpty((CharSequence)dateFormat)) {
            dateFormat = "yyyy-MM-dd";
        }
        this.updateRuleDateFormat(dateFormat);
        RuleCusControlService.updateControlData((IFormView)this.getView(), (String)args.getKey(), (String)ACTION_SHOWDATE, (Object)Boolean.TRUE);
    }

    private Map<String, List<Map<String, String>>> getComparisonOperatorsMap(String key) {
        List maps;
        Map operatorsMap = RuleCusCacheService.getCusComparisonOperators((IFormView)this.getView(), (String)key);
        if (CollectionUtils.isEmpty((Map)operatorsMap) && !CollectionUtils.isEmpty((Collection)(maps = (List)(operatorsMap = RuleOperatorsTypeService.getComparisonOperatorsMap()).get(RuleParamTypeEnum.ADMINORG.getValue())))) {
            for (Map map : maps) {
                if (!RuleOperatorEnum.IS_OR_IS_SUB.getValue().equals(map.get("value"))) continue;
                maps.remove(map);
                break;
            }
        }
        return operatorsMap;
    }

    private List<Map<String, String>> getInputParam(DynamicObjectCollection inputParams, long createOrgId, String conditionValue) {
        return RuleCusControlService.getInputParam((DynamicObjectCollection)inputParams, (long)createOrgId, (String)conditionValue);
    }

    private Map<String, List<Map<String, String>>> getInputValueParam(DynamicObjectCollection inputParams) {
        return RuleCusControlService.getInputValueParam((DynamicObjectCollection)inputParams);
    }

    private Map<String, String> getConditionExpress(String conditionValue) {
        HashMap conditionExpress = Maps.newHashMapWithExpectedSize((int)2);
        if (StringUtils.isNotEmpty((CharSequence)conditionValue)) {
            AccessDto ruleConditionInfo = (AccessDto)SerializationUtils.fromJsonString((String)conditionValue, AccessDto.class);
            conditionExpress.put("value", ruleConditionInfo.getConditionExpressStr());
        } else {
            conditionExpress.put("value", "");
        }
        return conditionExpress;
    }

    private void updateRuleDateFormat(String dateFormat) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)2);
        paramMap.put("mask", dateFormat);
        itemMap.put("item", paramMap);
        this.getView().updateControlMetadata("ruledate", (Map)itemMap);
    }

    private boolean isHisPage() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object fromPage = params.get("fromPage");
        return fromPage != null && "fromHisAction".equals(fromPage);
    }

    private String getPageState(String key) {
        String pageState = RuleCusCacheService.getPageState((IFormView)this.getView(), (String)key);
        if (HRStringUtils.isNotEmpty((String)pageState)) {
            return pageState;
        }
        if (this.isHisPage()) {
            pageState = this.getPageCache().get("pageStatus");
            pageState = HRStringUtils.isNotEmpty((String)pageState) ? pageState : BillOperationStatus.VIEW.name();
        } else {
            HashSet billOperationStatuses;
            CustomControl customControl;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String billStatusName = BillOperationStatus.VIEW.name();
            if (formShowParameter instanceof BillShowParameter) {
                BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                BillOperationStatus billStatus = billShowParameter.getBillStatus();
                billStatusName = billStatus.name();
            } else {
                OperationStatus status = formShowParameter.getStatus();
                billStatusName = status.name();
            }
            if (BillOperationStatus.ADDNEW.name().equals(billStatusName)) {
                billStatusName = "new";
            }
            pageState = (customControl = (CustomControl)this.getControl(key)) != null && customControl.getLock() != null && customControl.getLock().contains(billStatusName.toLowerCase(Locale.ROOT)) ? BillOperationStatus.VIEW.name() : (!(billOperationStatuses = Sets.newHashSet((Object[])new String[]{BillOperationStatus.VIEW.name(), BillOperationStatus.SUBMIT.name(), BillOperationStatus.AUDIT.name()})).contains(billStatusName) ? BillOperationStatus.EDIT.name() : BillOperationStatus.VIEW.name());
        }
        return pageState;
    }
}

