/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtbs.formplugin.web.task;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.task.enums.TaskCategoryEnum;
import kd.wtc.wtbs.business.task.repository.WTCTaskRepository;
import kd.wtc.wtbs.business.task.view.TaskDetailShowUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;

public class CalTaskEdit
extends HRDataBaseEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        FormShowParameter parameter = evt.getFormShowParameter();
        String caption = (String)parameter.getCustomParam("KEY_PAGE_CAPTION");
        if (WTCStringUtils.isEmpty((String)caption)) {
            String category;
            Long taskId = Long.parseLong(parameter.getCustomParam("KEY_TASK_ID").toString());
            WTCCalTaskEntity task = this.queryTask(taskId, category = (String)parameter.getCustomParam("KEY_TASK_CATEGORY"));
            String taskVersion = task == null ? "" : task.getVersion();
            caption = TaskDetailShowUtils.genCaption((String)taskVersion);
        }
        parameter.setCaption(caption);
    }

    public void afterCreateNewData(EventObject e) {
        this.initPage();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"refresh")) {
            this.getView().updateView("flexpanelap1");
        }
    }

    private WTCCalTaskEntity queryTask(Long taskId, String category) {
        WTCTaskRepository tieTaskRepository = WTCTaskInstanceHelper.getRepository((String)category);
        if (tieTaskRepository == null) {
            return null;
        }
        return (WTCCalTaskEntity)tieTaskRepository.loadTaskByTaskId(taskId.longValue(), WTCTaskRepository.NO_CUSTOM_CONDITION);
    }

    private void initPage() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object customParam = parameter.getCustomParam("KEY_TASK_ID");
        Long taskId = customParam == null ? 0L : Long.parseLong(customParam.toString());
        String category = (String)parameter.getCustomParam("KEY_TASK_CATEGORY");
        WTCCalTaskEntity task = this.queryTask(taskId, category);
        boolean existData = task != null;
        this.getView().setVisible(Boolean.valueOf(existData), new String[]{"flexpanelap", "flexpanelap1"});
        this.getView().setVisible(Boolean.valueOf(!existData), new String[]{"flexpanelap2"});
        if (!existData) {
            return;
        }
        this.getModel().setValue("version", (Object)task.getVersion());
        this.getModel().setValue("name", (Object)Objects.requireNonNull(TaskCategoryEnum.of((String)category)).getDescription());
        this.getModel().setValue("calstartdate", (Object)task.getCalStartDate());
        this.getModel().setValue("calenddate", (Object)task.getCalEndDate());
        this.getModel().setValue("source", (Object)task.getSource().code);
        this.getModel().setValue("startdate", (Object)task.getStartDate());
        this.getModel().setValue("enddate", (Object)task.getEndDate());
        this.getModel().setValue("timecost", (Object)task.getTimeCost());
        this.getModel().setValue("taskstatus", (Object)task.getTaskStatus().code);
        this.getModel().setValue("taskdesc", (Object)task.getTaskDesc());
        this.getModel().setValue("errcause", (Object)task.getErrCause());
        this.getModel().setValue("totalattperson", (Object)task.getTotalAttPerson());
        this.getModel().setValue("runattperson", (Object)task.getRunAttPerson());
        this.getModel().setValue("succeedattperson", (Object)task.getSucceedAttPerson());
        this.getModel().setValue("failedattperson", (Object)task.getFailedAttPerson());
        this.getModel().setValue("notrunattperson", (Object)task.getNotRunAttPerson());
        this.getModel().setValue("totalattfile", (Object)task.getTotalAttFile());
        this.getModel().setValue("runattfile", (Object)task.getRunAttFile());
        this.getModel().setValue("succeedattfile", (Object)task.getSucceedAttFile());
        this.getModel().setValue("failedattfile", (Object)task.getFailedAttFile());
        this.getModel().setValue("notrunattfile", (Object)task.getNotRunAttFile());
    }
}

