/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtctd.mservice.atttotalbase.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.model.period.PerAttPeriodReportVo;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtctd.mservice.atttotalbase.IAttTotalBaseQueryService;

public class AttTotalBaseQueryService
implements IAttTotalBaseQueryService {
    private static String ATT_PERIOD_ID = "perattperiodid";
    private static String ATT_FILE_VID = "attfilevid";
    private static String PER_ATT_PERIOD_REPORT_ID = "attperattperiodid";

    public boolean queryAttTotalBaseByPerAttPeriodReport(String perAttPeriodReportId, Long attPeriodId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        QFilter qFilter = new QFilter(ATT_PERIOD_ID, "=", (Object)attPeriodId);
        qFilter.and(PER_ATT_PERIOD_REPORT_ID, "=", (Object)perAttPeriodReportId);
        if (hrBaseServiceHelper.queryOne(new QFilter[]{qFilter}) == null) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Map<String, Boolean> queryAttTotalBaseByPerAttPeriodReport(List<PerAttPeriodReportVo> perAttPeriodReportList) {
        if (WTCCollections.isNotEmpty(perAttPeriodReportList)) {
            HashMap returnMap = Maps.newHashMapWithExpectedSize((int)perAttPeriodReportList.size());
            WTCBatchHandleUtils.batchHandleMap((Map)returnMap, perAttPeriodReportList, (int)1000, this::inBatchesQueryAttTotalBaseByPerAttPeriodReport);
            return returnMap;
        }
        return null;
    }

    private Map<String, Boolean> inBatchesQueryAttTotalBaseByPerAttPeriodReport(List<PerAttPeriodReportVo> perAttPeriodReportList) {
        if (WTCCollections.isNotEmpty(perAttPeriodReportList)) {
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
            Set periodIdSet = perAttPeriodReportList.stream().map(PerAttPeriodReportVo::getPeriodId).collect(Collectors.toSet());
            Set perAttPeriodIdSet = perAttPeriodReportList.stream().map(PerAttPeriodReportVo::getPerAttPeriodId).collect(Collectors.toSet());
            Set fileSet = perAttPeriodReportList.stream().map(PerAttPeriodReportVo::getFileVersionId).collect(Collectors.toSet());
            DynamicObject[] attTotalBaseList = hrBaseServiceHelper.query(PER_ATT_PERIOD_REPORT_ID, new QFilter[]{new QFilter(ATT_PERIOD_ID, "in", periodIdSet).and(PER_ATT_PERIOD_REPORT_ID, "in", perAttPeriodIdSet).and(ATT_FILE_VID, "in", fileSet)});
            Map<String, DynamicObject> attTotalBaseMap = Arrays.stream(attTotalBaseList).collect(Collectors.toMap(dy -> dy.getString(PER_ATT_PERIOD_REPORT_ID), dy -> dy, (n1, n2) -> n1));
            if (WTCCollections.isNotEmpty(attTotalBaseMap)) {
                HashMap perAttPeriodReportIdMap = Maps.newHashMapWithExpectedSize((int)attTotalBaseMap.size());
                perAttPeriodReportList.forEach(perAttPeriodReportVo -> {
                    if (attTotalBaseMap.get(perAttPeriodReportVo.getPerAttPeriodId()) != null) {
                        perAttPeriodReportIdMap.put(perAttPeriodReportVo.getPerAttPeriodId(), Boolean.TRUE);
                    } else {
                        perAttPeriodReportIdMap.put(perAttPeriodReportVo.getPerAttPeriodId(), Boolean.FALSE);
                    }
                });
                return perAttPeriodReportIdMap;
            }
        }
        return null;
    }
}

