/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtctd.mservice.openapi.atttotal;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtctd.mservice.openapi.atttotal.AttTotalOpenApiErrorCode;
import kd.wtc.wtctd.mservice.openapi.atttotal.AttTotalReqModel;
import kd.wtc.wtctd.mservice.openapi.atttotal.AttTotalRespModel;

@ApiController(desc="AttTotal OpenApi", value="AttTotal OpenApi")
@ApiMapping(value="/AttTotal")
@ApiErrorCodes(value={@ApiErrorCode(code="0-999", desc="api system error"), @ApiErrorCode(code="10000-99999", desc="BOS\u5e73\u53f0\u5f02\u5e38"), @ApiErrorCode(code="wtctd.100001", desc="\u8bf7\u586b\u5199\u201c\u8003\u52e4\u671f\u95f4ID\u201d\uff0c\u6216\u586b\u5199\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f+\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u8003\u52e4\u671f\u95f4\u548c\u5f52\u5c5e\u65e5\u671f\u4e8c\u8005\u5fc5\u586b\u5176\u4e00\u3002"), @ApiErrorCode(code="wtctd.100002", desc="\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\u4e0e\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\u672a\u586b\u5199\u5b8c\u6574\uff0c\u6309\u5f52\u5c5e\u65e5\u671f\u67e5\u8be2\u65f6\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\u201d\u548c\u201c\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\u5747\u5fc5\u586b\u3002"), @ApiErrorCode(code="wtctd.100003", desc="\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002"), @ApiErrorCode(code="wtctd.100004", desc="\u6309\u5f52\u5c5e\u65e5\u671f\u67e5\u8be2\u65f6\uff0c\u65f6\u95f4\u8de8\u5ea6\u6700\u5927\u4e3a31\u5929\u3002"), @ApiErrorCode(code="wtctd.100005", desc="\u8003\u52e4\u6863\u6848ID\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u6bcf\u6b21\u67e5\u8be2\u65f6\u6700\u591a\u5141\u8bb8\u8f93\u5165xx\u4e2a\u8003\u52e4\u6863\u6848ID\u3002")})
public class AttTotalOpenApi
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(AttTotalOpenApi.class);
    private final int BATCH_SIZE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtctd.openapi.AttTotalOpenApi.attFileBatchSize", Integer.valueOf(200));
    private static final String SELECTS_DETAIL = "id,attmain attmain,perattperiodid,attitemvid attitemvid,perattperiodid attperiod,  valuelong valuelong, attitemid attitemid,attitemid.name attitemname,attitemid.number attitemnumber,attitemid.unit unit";
    private static final String SELECTS_BASE = "id attmain,personid personid,orgid orgid,calculatedate calculatedate, positionvid positionvid,jobvid jobvid, companyvid companyvid, departmentvid departmentvid, attfilevid.empgroup empgroup,attfilevid.personnum personnum,attfilevid.number attfilenumber,managescopevid managescopevid,affiliateadminorgvid affiliateadminorgvid,attfilevid.dependency dependency,attfilevid.dependencytype dependencytype,attfilevid.agreedlocation agreedworkplace,attfilevid.workplace workplace,perattperiodid attperiod,perattperiodid.number attperiodnumber,perattperiodid.name attperiodname,attperattperiodpk attperattperiodpk,perperiodbegindate perperiodbegindate,perperiodenddate perperiodenddate,attfilevid attfilevid,attfileid attfileid,attfileid attfile,versionid versionid,reckoner reckoner";

    @ApiPostMapping(desc="AttTotalSummary", value="/summary")
    public CustomApiResult<List<AttTotalRespModel>> attTotalSummary(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid AttTotalReqModel request) {
        LOGGER.info("attFileIds size={},perattperiodid={},startOwnDate={},endOwnDate={}", new Object[]{request.getAttFileIdList().size(), request.getPerattperiodid(), request.getStartOwnDate(), request.getEndOwnDate()});
        CustomApiResult customApiResult = new CustomApiResult();
        if (!this.checkParam(request, (CustomApiResult<List<AttTotalRespModel>>)customApiResult)) {
            LOGGER.info("checkParam bad");
            return customApiResult;
        }
        try {
            List<QFilter> filterList = this.genBaseFilter(request);
            QFilter attPeriodQFilter = this.getAttPeriodQFilter(request);
            if (attPeriodQFilter == null) {
                return customApiResult;
            }
            filterList.add(attPeriodQFilter);
            DataSet dataSet = this.queryMainData(filterList, request);
            List<AttTotalRespModel> res = this.transferData(dataSet, request);
            customApiResult.setData(res);
            customApiResult.setStatus(true);
        }
        catch (Exception ex) {
            LOGGER.warn("AttTotalDetail error", (Throwable)ex);
            customApiResult.setStatus(false);
            customApiResult.setMessage("query error");
        }
        LOGGER.info(" result AttTotalRespModel size={}", (Object)((List)customApiResult.getData()).size());
        return customApiResult;
    }

    private boolean checkParam(AttTotalReqModel request, CustomApiResult<List<AttTotalRespModel>> customApiResult) {
        List<Long> attFileIdList = request.getAttFileIdList();
        Long perattperiodid = request.getPerattperiodid();
        Date startOwnDate = request.getStartOwnDate();
        Date endOwnDate = request.getEndOwnDate();
        if (attFileIdList.isEmpty()) {
            return false;
        }
        if (attFileIdList.size() > this.BATCH_SIZE) {
            customApiResult.setMessage(MessageFormat.format(AttTotalOpenApiErrorCode.ERROR_CODE_005.getDesc(), this.BATCH_SIZE));
            customApiResult.setErrorCode(AttTotalOpenApiErrorCode.ERROR_CODE_005.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (perattperiodid == null && startOwnDate == null && endOwnDate == null) {
            customApiResult.setMessage(AttTotalOpenApiErrorCode.ERROR_CODE_001.getDesc());
            customApiResult.setErrorCode(AttTotalOpenApiErrorCode.ERROR_CODE_001.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (startOwnDate == null && endOwnDate != null || endOwnDate == null && startOwnDate != null) {
            customApiResult.setMessage(AttTotalOpenApiErrorCode.ERROR_CODE_002.getDesc());
            customApiResult.setErrorCode(AttTotalOpenApiErrorCode.ERROR_CODE_002.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (startOwnDate != null) {
            if (startOwnDate.compareTo(endOwnDate) > 0) {
                customApiResult.setMessage(AttTotalOpenApiErrorCode.ERROR_CODE_003.getDesc());
                customApiResult.setErrorCode(AttTotalOpenApiErrorCode.ERROR_CODE_003.getCode());
                customApiResult.setStatus(false);
                return false;
            }
            if (WTCDateUtils.daysBetween((Date)startOwnDate, (Date)endOwnDate) > 31) {
                customApiResult.setMessage(AttTotalOpenApiErrorCode.ERROR_CODE_004.getDesc());
                customApiResult.setErrorCode(AttTotalOpenApiErrorCode.ERROR_CODE_004.getCode());
                customApiResult.setStatus(false);
                return false;
            }
        }
        return true;
    }

    private DataSet queryExtData(DataSet dataSet) {
        return dataSet;
    }

    private List<AttTotalRespModel> transferData(DataSet dataSet, @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") AttTotalReqModel request) {
        Set returnFieldSet;
        ArrayList respModelList = Lists.newArrayListWithExpectedSize((int)10);
        String returnFields = request.getReturnFields();
        boolean returnAllFields = returnFields == null;
        Set set = returnFieldSet = returnAllFields ? Collections.emptySet() : Arrays.stream(returnFields.split(",")).collect(Collectors.toSet());
        while (dataSet.hasNext()) {
            AttTotalRespModel model = new AttTotalRespModel();
            Row row = dataSet.next();
            if (returnAllFields || returnFieldSet.contains("personId")) {
                model.setPersonId(row.getLong("personid"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileId")) {
                model.setAttFileId(row.getLong("attfileid"));
            }
            if (returnAllFields || returnFieldSet.contains("number")) {
                model.setNumber(row.getString("personnum"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileNumber")) {
                model.setAttFileNumber(row.getString("attfilenumber"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileVid")) {
                model.setAttFileVid(row.getLong("attfilevid"));
            }
            if (returnAllFields || returnFieldSet.contains("versionId")) {
                model.setVersionId(row.getString("versionid"));
            }
            if (returnAllFields || returnFieldSet.contains("attPeriod")) {
                model.setAttPeriod(row.getLong("attperiod"));
            }
            if (returnAllFields || returnFieldSet.contains("attPeriodNumber")) {
                model.setAttPeriodNumber(row.getString("attperiodnumber"));
            }
            if (returnAllFields || returnFieldSet.contains("personAttPeriod")) {
                model.setPersonAttPeriod(row.getLong("attperattperiodpk"));
            }
            if (returnAllFields || returnFieldSet.contains("perPeriodBeginDate")) {
                model.setPerPeriodBeginDate(row.getDate("perperiodbegindate"));
            }
            if (returnAllFields || returnFieldSet.contains("perPeriodEndDate")) {
                model.setPerPeriodEndDate(row.getDate("perperiodenddate"));
            }
            if (returnAllFields || returnFieldSet.contains("orgId")) {
                model.setOrgId(row.getLong("orgid"));
            }
            if (returnAllFields || returnFieldSet.contains("manageScopeVid")) {
                model.setManageScopeVid(row.getLong("managescopevid"));
            }
            if (returnAllFields || returnFieldSet.contains("companyVid")) {
                model.setCompanyVid(row.getLong("companyvid"));
            }
            if (returnAllFields || returnFieldSet.contains("departmentVid")) {
                model.setDepartmentVid(row.getLong("departmentvid"));
            }
            if (returnAllFields || returnFieldSet.contains("affiliateAdminOrgVid")) {
                model.setAffiliateAdminOrgVid(row.getLong("affiliateadminorgvid"));
            }
            if (returnAllFields || returnFieldSet.contains("positionVid")) {
                model.setPositionVid(row.getLong("positionvid"));
            }
            if (returnAllFields || returnFieldSet.contains("jobVid")) {
                model.setJobVid(row.getLong("jobvid"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemId")) {
                model.setAttItemId(row.getLong("attitemid"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemVid")) {
                model.setAttItemVid(row.getLong("attitemvid"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemNumber")) {
                model.setAttItemNumber(row.getString("attitemnumber"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemName")) {
                model.setAttItemName(row.getString("attitemname"));
            }
            if (returnAllFields || returnFieldSet.contains("valueString")) {
                model.setValueString(row.getBigDecimal("valuelong").toPlainString());
            }
            if (returnAllFields || returnFieldSet.contains("attItemUnit")) {
                model.setAttItemUnit(row.getString("unit"));
            }
            if (returnAllFields || returnFieldSet.contains("reckoner")) {
                model.setReckoner(row.getLong("reckoner"));
            }
            if (returnAllFields || returnFieldSet.contains("calculateDate")) {
                model.setCalculateDate(row.getDate("calculatedate"));
            }
            respModelList.add(model);
        }
        return respModelList;
    }

    private DataSet queryMainData(List<QFilter> filterList, AttTotalReqModel request) {
        HRBaseServiceHelper mainServiceHelper = new HRBaseServiceHelper("wtctd_atttotalbase");
        DataSet dataSetBase = mainServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_main", SELECTS_BASE, filterList.toArray(new QFilter[0]));
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = dataSetBase.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("attmain"));
        }
        List<QFilter> detailFilter = this.genDetailFilter(request);
        detailFilter.add(new QFilter("attmain", "in", (Object)ids));
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtctd_atttotaldetail");
        DataSet dataSetDetail = detailServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_detail", SELECTS_DETAIL, detailFilter.toArray(new QFilter[0]));
        JoinDataSet join = dataSetBase.join(dataSetDetail);
        join.on("attmain", "attmain");
        List<String> leftList = Arrays.stream(dataSetBase.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        List<String> rightList = Arrays.stream(dataSetDetail.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        rightList.removeAll(leftList);
        join.select(leftList.toArray(new String[0]), rightList.toArray(new String[0]));
        return join.finish();
    }

    private List<QFilter> genBaseFilter(AttTotalReqModel request) {
        List<Long> attFileIdList = request.getAttFileIdList();
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("attfileid", "in", attFileIdList));
        return qFilters;
    }

    private QFilter getAttPeriodQFilter(AttTotalReqModel request) {
        Long perattperiodid = request.getPerattperiodid();
        Date startOwnDate = request.getStartOwnDate();
        Date endOwnDate = request.getEndOwnDate();
        List<Long> attPeriodIdIntersection = this.getAttPeriodIdIntersection(perattperiodid, this.getAttPeriod(startOwnDate, endOwnDate));
        QFilter qFilter = null;
        if (attPeriodIdIntersection != null && !attPeriodIdIntersection.isEmpty()) {
            qFilter = new QFilter("perattperiodid", "in", attPeriodIdIntersection);
        }
        return qFilter;
    }

    private List<Long> getAttPeriodIdIntersection(Long perattperiodid, List<Long> attPeriodList) {
        if (perattperiodid == null) {
            return attPeriodList;
        }
        if (attPeriodList != null && !attPeriodList.isEmpty()) {
            for (Long attPeriodId : attPeriodList) {
                if (!attPeriodId.equals(perattperiodid)) continue;
                return Collections.singletonList(perattperiodid);
            }
        } else {
            return Collections.singletonList(perattperiodid);
        }
        return Collections.emptyList();
    }

    private List<Long> getAttPeriod(Date startOwnDate, Date endOwnDate) {
        ArrayList atPeriodIdList = null;
        if (startOwnDate != null && endOwnDate != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attperiodentry");
            QFilter[] qFilterArr = new QFilter[]{new QFilter("begindate", "<=", (Object)endOwnDate), new QFilter("enddate", ">=", (Object)startOwnDate)};
            DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("id", qFilterArr);
            atPeriodIdList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                atPeriodIdList.add(dynamicObject.getLong("id"));
            }
        }
        return atPeriodIdList;
    }

    private List<QFilter> genDetailFilter(AttTotalReqModel request) {
        Date startOwnDate = request.getStartOwnDate();
        Date endOwnDate = request.getEndOwnDate();
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        if (startOwnDate != null && endOwnDate != null) {
            this.getAttPeriod(startOwnDate, endOwnDate);
        }
        return qFilters;
    }
}

