/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtctd.formplugin.web;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;

public class AttPeriodTotalListProvider
extends ListDataProvider {
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtctd_atttotalbasehis");

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        Set attmain = rows.stream().map(dy -> dy.getDynamicObject("attmain")).filter(Objects::nonNull).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] attMainDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", attmain)});
        HashMap<Long, DynamicObject> attBaseMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject attMainDy : attMainDys) {
            attBaseMap.putIfAbsent(attMainDy.getLong("id"), attMainDy);
        }
        this.buildDyProp(rows);
        rows.forEach(row -> this.fillDyProp((Map<Long, DynamicObject>)attBaseMap, (DynamicObject)row));
        for (DynamicObject row2 : rows) {
            Long attItemId = row2.getLong("attitemid.id");
            BigDecimal valuelong = row2.getBigDecimal("valuelong");
            BigDecimal formatValue = this.getFormatValue(attItemId, valuelong);
            row2.set("valuelong", (Object)formatValue);
        }
        return rows;
    }

    private BigDecimal getFormatValue(Long attItemId, BigDecimal valueLong) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtbd_attitem");
        String selectProperties = "dataaccuracy,precisiontail";
        DynamicObject query = hrBaseServiceHelper.queryOne(selectProperties, new QFilter[]{new QFilter("id", "=", (Object)attItemId)});
        if (query == null) {
            return valueLong;
        }
        int dataAccuracy = query.getInt("dataaccuracy");
        String roundingMode = query.getString("precisiontail");
        int precision = 4;
        switch (roundingMode) {
            case "2": {
                precision = 1;
                break;
            }
            case "3": {
                precision = 0;
                break;
            }
        }
        return valueLong.setScale(dataAccuracy, RoundingMode.valueOf(precision));
    }

    private void fillDyProp(Map<Long, DynamicObject> attBaseMap, DynamicObject row) {
        DynamicObject attfilevid;
        DynamicObject base = row.getDynamicObject("attmain");
        if (base != null && (base = attBaseMap.get(base.getLong("id"))) != null && (attfilevid = base.getDynamicObject("attfilevid")) != null) {
            DynamicObject workplace;
            DynamicObject agreedLocation;
            DynamicObject dependencyType;
            DynamicObject dependency;
            DynamicObject empGroup;
            DynamicObject managingScope = attfilevid.getDynamicObject("managingscope");
            if (managingScope != null) {
                row.set("managingscope", (Object)managingScope.getString("name"));
            }
            if ((empGroup = attfilevid.getDynamicObject("empgroup")) != null) {
                row.set("empgroup", (Object)empGroup.getString("name"));
            }
            if ((dependency = attfilevid.getDynamicObject("dependency")) != null) {
                row.set("dependency", (Object)dependency.getString("name"));
            }
            if ((dependencyType = attfilevid.getDynamicObject("dependencytype")) != null) {
                row.set("dependencytype", (Object)dependencyType.getString("name"));
            }
            if ((agreedLocation = attfilevid.getDynamicObject("agreedlocation")) != null) {
                row.set("agreedworkplace", (Object)agreedLocation.getString("name"));
            }
            if ((workplace = attfilevid.getDynamicObject("workplace")) != null) {
                row.set("workplace", (Object)workplace.getString("name"));
            }
        }
    }

    private void buildDyProp(DynamicObjectCollection rows) {
        DynamicObject dynamicObject;
        DynamicObject dynamicObject2 = dynamicObject = WTCCollectionIndexUtil.getEleFromList((List)rows, (int)0).isPresent() ? (DynamicObject)WTCCollectionIndexUtil.getEleFromList((List)rows, (int)0).get() : null;
        if (dynamicObject == null) {
            return;
        }
        DynamicSimpleProperty prop = new DynamicSimpleProperty();
        prop.setName("managingscope");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
        prop = new DynamicSimpleProperty();
        prop.setName("empgroup");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
        prop = new DynamicSimpleProperty();
        prop.setName("dependency");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
        prop = new DynamicSimpleProperty();
        prop.setName("dependencytype");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
        prop = new DynamicSimpleProperty();
        prop.setName("agreedworkplace");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
        prop = new DynamicSimpleProperty();
        prop.setName("workplace");
        dynamicObject.getDataEntityType().getProperties().add((Object)prop);
    }
}

