/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtdtd.formplugin.web.attrecord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;

public class AttRecordHisEditPlugin
extends AbstractListPlugin {
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtdtd_attrecordhis");
    private static HRBaseServiceHelper hrServiceHelper = new HRBaseServiceHelper("wtte_datajson");

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.size() != 0) {
            Long personid = (Long)customParams.get("personid");
            String owndate = (String)customParams.get("owndate");
            Date parse = WTCDateUtils.str2Date((String)owndate, (String)"yyyy-MM-dd");
            Object attitemid = customParams.get("attitemid");
            String attitemtype = (String)customParams.get("attitemtype");
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            QFilter qFilter1 = new QFilter("personid", "=", (Object)personid);
            QFilter qFilter2 = new QFilter("owndate", "=", (Object)parse);
            QFilter qFilter3 = new QFilter("attitemid", "=", attitemid);
            QFilter qFilter4 = new QFilter("attitemtype", "=", (Object)attitemtype);
            qFilters.add(qFilter1);
            qFilters.add(qFilter2);
            qFilters.add(qFilter3);
            qFilters.add(qFilter4);
            setFilterEvent.setCustomQFilters(qFilters);
            setFilterEvent.setOrderBy("calculatedate desc");
        }
    }

    public static BillShowParameter getShiftFormParameter(Object pkValue) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("wtbd_shift");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setPkId(pkValue);
        return billShowParameter;
    }

    public static BillShowParameter getAttItemFormParameter(Object pkValue) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("wtbd_attitem");
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setPkId(pkValue);
        return billShowParameter;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getFieldName();
        Long rowId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
        if ("shiftid_name".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject attdrecord = serviceHelper.queryOne("shiftid", new QFilter[]{new QFilter("id", "=", (Object)rowId)});
            this.getView().showForm((FormShowParameter)AttRecordHisEditPlugin.getShiftFormParameter(attdrecord.getDynamicObject("shiftid").getPkValue()));
        } else if ("attitemid_name".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject attdrecord = serviceHelper.queryOne("attitemid", new QFilter[]{new QFilter("id", "=", (Object)rowId)});
            this.getView().showForm((FormShowParameter)AttRecordHisEditPlugin.getAttItemFormParameter(attdrecord.getDynamicObject("attitemid").getPkValue()));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing && Objects.equals(((Donothing)args.getSource()).getOperateKey(), "showcalculate")) {
            Long rowId = WTCCollectionIndexUtil.getEleFromList((List)args.getListSelectedData(), (int)0).isPresent() ? ((ListSelectedRow)WTCCollectionIndexUtil.getEleFromList((List)args.getListSelectedData(), (int)0).get()).getPrimaryKeyValue() : Long.valueOf(0L);
            DynamicObject dynamicObject = serviceHelper.queryOne("personid,attitemid,versionid,sourceattitemids,owndate", (Object)rowId);
            Long personId = dynamicObject.getLong("personid.id");
            String versionId = dynamicObject.getString("versionid");
            Long attItemId = dynamicObject.getLong("attitemid.id");
            Date ownDate = dynamicObject.getDate("owndate");
            String sourceAttItemIds = dynamicObject.getString("sourceattitemids");
            DynamicObject[] query = hrServiceHelper.query(AttRecordHisEditPlugin.getQFilter(personId, ownDate, versionId));
            if (query.length == 0) {
                String message = ResManager.loadKDString((String)"\u6838\u7b97\u4efb\u52a1\u672a\u5b58\u50a8\u6838\u7b97\u6b65\u9aa4\u3002", (String)"AttItemSetCheckService_1", (String)"wtc-wtdtd-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(message);
                return;
            }
            List<String> parentIds = Arrays.stream(sourceAttItemIds.split(",")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
            Map<String, Object> params = AttRecordHisEditPlugin.packageParams(personId, ownDate, parentIds, attItemId, versionId);
            this.getView().showForm(AttRecordHisEditPlugin.getCalStepFormParameter(params, dynamicObject.getString("personid.name")));
        }
    }

    public static QFilter[] getQFilter(Long personId, Date ownDate, String versionId) {
        return new QFilter[]{new QFilter("personid", "=", (Object)personId), new QFilter("owndate", "=", (Object)ownDate), new QFilter("version", "=", (Object)versionId)};
    }

    public static Map<String, Object> packageParams(Long personId, Date ownDate, List<String> parentIds, Long attItemId, String versionId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("personid", personId);
        params.put("owndate", ownDate);
        params.put("parentIds", parentIds);
        params.put("attitemid", attItemId);
        params.put("versionid", versionId);
        return params;
    }

    public static FormShowParameter getCalStepFormParameter(Map<String, Object> params, String personName) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("wtte_viewcalculatestep");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParams(params);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1400");
        styleCss.setHeight("800");
        formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6838\u7b97\u6b65\u9aa4-%s", (String)"AttItemSetCheckService_2", (String)"wtc-wtdtd-formplugin", (Object[])new Object[]{personName}));
        return formShowParameter;
    }
}

