/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtdtd.mservice.attrecord;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtdtd.mservice.attrecord.IAttRecordService;

public class AttRecordServiceImpl
implements IAttRecordService {
    private static final Log log = LogFactory.getLog(AttRecordServiceImpl.class);
    private static final String WTC_WTDTD_MSERVICE = "wtc-wtdtd-mservice";

    public void attFileDiscard(List<Long> attFileIdList, Date earliestDate) {
        this.deleteAttRecord(attFileIdList, earliestDate, "wtdtd_attrecordbase", "wtdtd_attrecorddetail");
        this.deleteAttRecord(attFileIdList, earliestDate, "wtdtd_attrecordbasehis", "wtdtd_attrecorddetailhis");
    }

    private void deleteAttRecord(List<Long> attFileIdList, Date earliestDate, String mainPageNumber, String detailPageNumber) {
        HRBaseServiceHelper baseHelper = new HRBaseServiceHelper(mainPageNumber);
        QFilter attFileQFilter = new QFilter("attfileid", "in", attFileIdList);
        QFilter ownDateQFilter = new QFilter("owndate", ">=", (Object)earliestDate);
        DynamicObject[] attRecordMainDys = baseHelper.queryOriginalArray("id", new QFilter[]{attFileQFilter, ownDateQFilter});
        if (null == attRecordMainDys || attRecordMainDys.length == 0) {
            return;
        }
        List idList = Arrays.stream(attRecordMainDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        IDataEntityType mainEntityType = baseHelper.generateEmptyDynamicObject().getDataEntityType();
        DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])idList.toArray());
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper(detailPageNumber);
        QFilter midQFilter = new QFilter("attmain", "in", idList);
        DynamicObject[] detail = detailHelper.query("id", new QFilter[]{ownDateQFilter, midQFilter});
        if (null == detail || detail.length == 0) {
            return;
        }
        IDataEntityType detailEntityType = detailHelper.generateEmptyDynamicObject().getDataEntityType();
        DeleteServiceHelper.delete((IDataEntityType)detailEntityType, (Object[])Arrays.stream(detail).map(dy -> dy.getLong("id")).toArray());
    }

    public Map<Long, Map<String, Map<Long, String>>> listDetailAttItems(Map<Long, List<String>> attfileQueryMap, List<Long> attItemList) {
        log.info("AttRecordServiceImpl.listDetailAttItems inputparams attfileMultBoQueryMap:{} attItemSet:{}", attfileQueryMap, attItemList);
        LinkedHashMap resultMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(attItemList)) {
            return resultMap;
        }
        HashSet dateSet = Sets.newHashSetWithExpectedSize((int)16);
        this.checkParam(attfileQueryMap, dateSet);
        HashMap attfileMap = Maps.newHashMapWithExpectedSize((int)16);
        DataSet dataSet = this.queryAttFileAttRecord(attfileQueryMap.keySet(), dateSet, attItemList, attfileMap);
        if (null == dataSet) {
            return resultMap;
        }
        while (dataSet.hasNext()) {
            Date ownDate;
            Row row = dataSet.next();
            Long mid = row.getLong("attmain");
            Long bid = (Long)attfileMap.get(mid);
            if (bid == null || (ownDate = row.getDate("owndate")) == null) continue;
            String ownDateStr = WTCDateUtils.date2Str((Date)ownDate, (String)"yyyy-MM-dd");
            List<String> dates = attfileQueryMap.get(bid);
            if (WTCCollections.isEmpty(dates) || WTCStringUtils.isEmpty((String)ownDateStr) || !dates.contains(ownDateStr)) continue;
            Map attfileOutMap = resultMap.computeIfAbsent(bid, key -> new HashMap());
            Map tempMap = attfileOutMap.computeIfAbsent(ownDateStr, key -> new HashMap());
            tempMap.put(row.getLong("attitemid"), row.getString("valuestring"));
        }
        log.info("AttRecordServiceImpl.listDetailAttItems output {}", (Object)resultMap);
        return resultMap;
    }

    private DataSet queryAttFileAttRecord(Set<Long> attfileBoidSet, Set<Date> dateSet, List<Long> attItemList, Map<Long, Long> attfileMap) {
        QFilter[] baseFilters = new QFilter[]{new QFilter("owndate", "in", dateSet), new QFilter("attfileid", "in", attfileBoidSet)};
        HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        String baseSelect = WTCStringUtils.joinOnComma((String[])new String[]{"attfileid", "id"});
        DataSet baseDataSet = baseServiceHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", baseSelect, baseFilters);
        DataSet copy = baseDataSet.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            Long id = row.getLong("id");
            attfileMap.put(id, row.getLong("attfileid"));
        }
        if (WTCCollections.isEmpty(attfileMap.keySet())) {
            return null;
        }
        QFilter[] detailFilters = new QFilter[]{new QFilter("owndate", "in", dateSet), new QFilter("attmain", "in", attfileMap.keySet()), new QFilter("attitemid", "in", attItemList)};
        HRBaseServiceHelper detailHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        String select = WTCStringUtils.joinOnComma((String[])new String[]{"attmain", "attitemid", "valuestring", "owndate"});
        return detailHelper.queryDataSet(this.getClass().getName() + ".queryPersonAttRecord", select, detailFilters);
    }

    private void checkParam(Map<Long, List<String>> attfileQueryMap, Set<Date> dateList) {
        if (CollectionUtils.isEmpty(attfileQueryMap)) {
            throw new KDException(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttRecordServiceImpl_0", (String)WTC_WTDTD_MSERVICE, (Object[])new Object[0]));
        }
        for (Map.Entry<Long, List<String>> entry : attfileQueryMap.entrySet()) {
            Long bid = entry.getKey();
            if (bid == null) {
                throw new KDException(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4fe1\u606f\u4e2d\u8003\u52e4\u6863\u6848bid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttRecordServiceImpl_1", (String)WTC_WTDTD_MSERVICE, (Object[])new Object[0]));
            }
            List<String> valueDate = entry.getValue();
            if (WTCCollections.isEmpty(valueDate)) {
                throw new KDException(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4fe1\u606f\u4e2d\u65e5\u671f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AttRecordServiceImpl_2", (String)WTC_WTDTD_MSERVICE, (Object[])new Object[0]));
            }
            for (String dateStr : valueDate) {
                try {
                    dateList.add(WTCDateUtils.parseDate((String)dateStr, (String)"yyyy-MM-dd"));
                }
                catch (ParseException e) {
                    throw new KDException(ResManager.loadKDString((String)"\u8003\u52e4\u6863\u6848\u4fe1\u606f\u4e2d\u65e5\u671f\u5217\u8868\u683c\u5f0f\u5fc5\u987b\u662fyyyy-MM-dd\u3002", (String)"AttRecordServiceImpl_3", (String)WTC_WTDTD_MSERVICE, (Object[])new Object[0]));
                }
            }
        }
    }
}

