/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtdtd.mservice.openapi.attrecord;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtdtd.mservice.openapi.attrecord.AttRecordOpenApiErrorCode;
import kd.wtc.wtdtd.mservice.openapi.attrecord.AttRecordReqModel;
import kd.wtc.wtdtd.mservice.openapi.attrecord.AttRecordRespModel;

@ApiController(desc="AttRecord OpenApi", value="AttRecord OpenApi")
@ApiMapping(value="/AttRecord")
@ApiErrorCodes(value={@ApiErrorCode(code="0-999", desc="api system error"), @ApiErrorCode(code="10000-99999", desc="BOS\u5e73\u53f0\u5f02\u5e38"), @ApiErrorCode(code="wtdtd.100001", desc="\u8bf7\u586b\u5199\u201c\u8003\u52e4\u671f\u95f4ID\u201d\uff0c\u6216\u586b\u5199\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f+\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u8003\u52e4\u671f\u95f4\u548c\u5f52\u5c5e\u65e5\u671f\u4e8c\u8005\u5fc5\u586b\u5176\u4e00\u3002"), @ApiErrorCode(code="wtdtd.100002", desc="\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\u4e0e\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\u672a\u586b\u5199\u5b8c\u6574\uff0c\u6309\u5f52\u5c5e\u65e5\u671f\u67e5\u8be2\u65f6\u201c\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\u201d\u548c\u201c\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u201d\u5747\u5fc5\u586b\u3002"), @ApiErrorCode(code="wtdtd.100003", desc="\u5f52\u5c5e\u7ed3\u675f\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u5f52\u5c5e\u5f00\u59cb\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u3002"), @ApiErrorCode(code="wtdtd.100004", desc="\u6309\u5f52\u5c5e\u65e5\u671f\u67e5\u8be2\u65f6\uff0c\u65f6\u95f4\u8de8\u5ea6\u6700\u5927\u4e3a31\u5929\u3002"), @ApiErrorCode(code="wtdtd.100005", desc="\u8003\u52e4\u6863\u6848ID\u6570\u91cf\u8d85\u8fc7\u4e0a\u9650\uff0c\u6bcf\u6b21\u67e5\u8be2\u65f6\u6700\u591a\u5141\u8bb8\u8f93\u5165xx\u4e2a\u8003\u52e4\u6863\u6848ID\u3002")})
public class AttRecordOpenApi
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(AttRecordOpenApi.class);
    private final int BATCH_SIZE = WTCAppContextHelper.getProjectParams().getInteger("kd.wtc.wtdtd.openapi.AttRecordOpenApi.attFileBatchSize", Integer.valueOf(20));
    private static final String SELECTS_DETAIL = "id,valuestring,attmain attmain,attitemid attitemid,attitemid.name attitemname,attitemid.number attitemnumber,attitemid.unit unit,attitemvid attitemvid";
    private static final String SELECTS_BASE = "id attmain,personid personid,owndate owndate,datetype datetype,datetype.number datetypenumber,datetype.name datetypename,dateattr dateattr,dateattr.number dateattrenumber,dateattr.name dateattrname,shiftid shiftid,shiftvid shiftvid,shiftvid.number shiftnumber,shiftvid.name shiftname,orgid orgid,departmentvid departmentvid,companyvid companyvid,positionvid positionvid,jobvid jobvid,mode mode,attperattperiodpk attperattperiodpk,perattperiodid attperiod,perperiodbegindate perperiodbegindate,perperiodenddate perperiodenddate,perattperiodid.number attperiodnumber,perattperiodid.name attperiodname,calculatedate calculatedate,createtime createtime,reckoner reckoner,versionid versionid,attfilevid attfilevid,attfileid attfileid,attfileid attfile,attfilevid.empgroup empgroup,attfilevid.personnum personnum,attfilevid.number attfilenumber,affiliateadminorgvid affiliateadminorgvid,attfilevid.dependencytype dependencytype,managescopevid managescopevid,attfilevid.agreedlocation agreedworkplace,attfilevid.workplace workplace,attfilevid.dependency dependency";

    @ApiPostMapping(desc="attRecordDetail", value="/attRecordDetail")
    public CustomApiResult<List<AttRecordRespModel>> attRecordDetail(@ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @Valid AttRecordReqModel request) {
        LOGGER.info("attFileIds size={},perattperiodid={},startOwnDate={},endOwnDate={}", new Object[]{request.getAttFileIdList().size(), request.getPerattperiodid(), request.getStartOwnDate(), request.getEndOwnDate()});
        CustomApiResult customApiResult = new CustomApiResult();
        if (!this.checkParam(request, (CustomApiResult<List<AttRecordRespModel>>)customApiResult)) {
            LOGGER.info("checkParam bad");
            return customApiResult;
        }
        try {
            List<QFilter> filterList = this.genBaseFilter(request);
            DataSet dataSet = this.queryMainData(filterList, request);
            List<AttRecordRespModel> res = this.transferData(dataSet, request);
            customApiResult.setData(res);
            customApiResult.setStatus(true);
        }
        catch (Exception ex) {
            LOGGER.warn("attRecordDetail error", (Throwable)ex);
            customApiResult.setStatus(false);
            customApiResult.setMessage("query error");
        }
        LOGGER.info(" result AttRecordRespModel size={}", (Object)((List)customApiResult.getData()).size());
        return customApiResult;
    }

    private boolean checkParam(AttRecordReqModel request, CustomApiResult<List<AttRecordRespModel>> customApiResult) {
        List<Long> attFileIdList = request.getAttFileIdList();
        Long perattperiodid = request.getPerattperiodid();
        Date startOwnDate = request.getStartOwnDate();
        Date endOwnDate = request.getEndOwnDate();
        if (attFileIdList.isEmpty()) {
            return false;
        }
        if (attFileIdList.size() > this.BATCH_SIZE) {
            customApiResult.setMessage(MessageFormat.format(AttRecordOpenApiErrorCode.ERROR_CODE_005.getDesc(), this.BATCH_SIZE));
            customApiResult.setErrorCode(AttRecordOpenApiErrorCode.ERROR_CODE_005.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (perattperiodid == null && startOwnDate == null && endOwnDate == null) {
            customApiResult.setMessage(AttRecordOpenApiErrorCode.ERROR_CODE_001.getDesc());
            customApiResult.setErrorCode(AttRecordOpenApiErrorCode.ERROR_CODE_001.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (startOwnDate == null && endOwnDate != null || endOwnDate == null && startOwnDate != null) {
            customApiResult.setMessage(AttRecordOpenApiErrorCode.ERROR_CODE_002.getDesc());
            customApiResult.setErrorCode(AttRecordOpenApiErrorCode.ERROR_CODE_002.getCode());
            customApiResult.setStatus(false);
            return false;
        }
        if (startOwnDate != null) {
            if (startOwnDate.compareTo(endOwnDate) > 0) {
                customApiResult.setMessage(AttRecordOpenApiErrorCode.ERROR_CODE_003.getDesc());
                customApiResult.setErrorCode(AttRecordOpenApiErrorCode.ERROR_CODE_003.getCode());
                customApiResult.setStatus(false);
                return false;
            }
            if (WTCDateUtils.daysBetween((Date)startOwnDate, (Date)endOwnDate) > 31) {
                customApiResult.setMessage(AttRecordOpenApiErrorCode.ERROR_CODE_004.getDesc());
                customApiResult.setErrorCode(AttRecordOpenApiErrorCode.ERROR_CODE_004.getCode());
                customApiResult.setStatus(false);
                return false;
            }
        }
        return true;
    }

    private DataSet queryExtData(DataSet dataSet) {
        return dataSet;
    }

    private List<AttRecordRespModel> transferData(DataSet dataSet, @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") @ApiParam(value="\u8bf7\u6c42\u53c2\u6570") AttRecordReqModel request) {
        Set returnFieldSet;
        ArrayList respModelList = Lists.newArrayListWithExpectedSize((int)10);
        String returnFields = request.getReturnFields();
        boolean returnAllFields = returnFields == null;
        Set set = returnFieldSet = returnAllFields ? Collections.emptySet() : Arrays.stream(returnFields.split(",")).collect(Collectors.toSet());
        while (dataSet.hasNext()) {
            AttRecordRespModel model = new AttRecordRespModel();
            Row row = dataSet.next();
            if (returnAllFields || returnFieldSet.contains("personId")) {
                model.setPersonId(row.getLong("personid"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileId")) {
                model.setAttFileId(row.getLong("attfileid"));
            }
            if (returnAllFields || returnFieldSet.contains("number")) {
                model.setNumber(row.getString("personnum"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileNumber")) {
                model.setAttFileNumber(row.getString("attfilenumber"));
            }
            if (returnAllFields || returnFieldSet.contains("attFileVid")) {
                model.setAttFileVid(row.getLong("attfilevid"));
            }
            if (returnAllFields || returnFieldSet.contains("versionId")) {
                model.setVersionId(row.getString("versionid"));
            }
            if (returnAllFields || returnFieldSet.contains("attPeriod")) {
                model.setAttPeriod(row.getLong("attperiod"));
            }
            if (returnAllFields || returnFieldSet.contains("attPeriodNumber")) {
                model.setAttPeriodNumber(row.getString("attperiodnumber"));
            }
            if (returnAllFields || returnFieldSet.contains("personAttPeriod")) {
                model.setPersonAttPeriod(row.getLong("attperattperiodpk"));
            }
            if (returnAllFields || returnFieldSet.contains("perPeriodBeginDate")) {
                model.setPerPeriodBeginDate(row.getDate("perPeriodBeginDate"));
            }
            if (returnAllFields || returnFieldSet.contains("perPeriodEndDate")) {
                model.setPerPeriodEndDate(row.getDate("perPeriodEndDate"));
            }
            if (returnAllFields || returnFieldSet.contains("ownDate")) {
                model.setOwnDate(row.getDate("owndate"));
            }
            if (returnAllFields || returnFieldSet.contains("dateTypeId")) {
                model.setDateTypeId(row.getLong("datetype"));
            }
            if (returnAllFields || returnFieldSet.contains("dateTypeNumber")) {
                model.setDateTypeNumber(row.getString("datetypenumber"));
            }
            if (returnAllFields || returnFieldSet.contains("dateTypeName")) {
                model.setDateTypeName(row.getString("datetypename"));
            }
            if (returnAllFields || returnFieldSet.contains("dateAttrId")) {
                model.setDateAttrId(row.getLong("dateattr"));
            }
            if (returnAllFields || returnFieldSet.contains("dateAttrNumber")) {
                model.setDateAttrNumber(row.getString("dateattrenumber"));
            }
            if (returnAllFields || returnFieldSet.contains("dateAttrName")) {
                model.setDateAttrName(row.getString("dateattrname"));
            }
            if (returnAllFields || returnFieldSet.contains("mode")) {
                model.setMode(row.getString("mode"));
            }
            if (returnAllFields || returnFieldSet.contains("orgId")) {
                model.setOrgId(row.getLong("orgid"));
            }
            if (returnAllFields || returnFieldSet.contains("manageScopeVid")) {
                model.setManageScopeVid(row.getLong("managescopevid"));
            }
            if (returnAllFields || returnFieldSet.contains("companyVid")) {
                model.setCompanyVid(row.getLong("companyvid"));
            }
            if (returnAllFields || returnFieldSet.contains("departmentVid")) {
                model.setDepartmentVid(row.getLong("departmentvid"));
            }
            if (returnAllFields || returnFieldSet.contains("affiliateAdminOrgVid")) {
                model.setAffiliateAdminOrgVid(row.getLong("affiliateadminorgvid"));
            }
            if (returnAllFields || returnFieldSet.contains("positionVid")) {
                model.setPositionVid(row.getLong("positionvid"));
            }
            if (returnAllFields || returnFieldSet.contains("jobVid")) {
                model.setJobVid(row.getLong("jobvid"));
            }
            if (returnAllFields || returnFieldSet.contains("shiftId")) {
                model.setShiftId(row.getLong("shiftid"));
            }
            if (returnAllFields || returnFieldSet.contains("shiftVid")) {
                model.setShiftVid(row.getLong("shiftvid"));
            }
            if (returnAllFields || returnFieldSet.contains("shiftNumber")) {
                model.setShiftNumber(row.getString("shiftnumber"));
            }
            if (returnAllFields || returnFieldSet.contains("shiftName")) {
                model.setShiftName(row.getString("shiftname"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemId")) {
                model.setAttItemId(row.getLong("attitemid"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemVid")) {
                model.setAttItemVid(row.getLong("attitemvid"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemNumber")) {
                model.setAttItemNumber(row.getString("attitemnumber"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemName")) {
                model.setAttItemName(row.getString("attitemname"));
            }
            if (returnAllFields || returnFieldSet.contains("valueString")) {
                model.setValueString(row.getString("valuestring"));
            }
            if (returnAllFields || returnFieldSet.contains("attItemUnit")) {
                model.setAttItemUnit(row.getString("unit"));
            }
            if (returnAllFields || returnFieldSet.contains("reckoner")) {
                model.setReckoner(row.getLong("reckoner"));
            }
            if (returnAllFields || returnFieldSet.contains("calculateDate")) {
                model.setCalculateDate(row.getDate("calculatedate"));
            }
            respModelList.add(model);
        }
        return respModelList;
    }

    private DataSet queryMainData(List<QFilter> filterList, AttRecordReqModel request) {
        HRBaseServiceHelper mainServiceHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
        DataSet dataSetBase = mainServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_main", SELECTS_BASE, filterList.toArray(new QFilter[0]));
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)30);
        DataSet copy = dataSetBase.copy();
        while (copy.hasNext()) {
            Row row = copy.next();
            ids.add(row.getLong("attmain"));
        }
        List<QFilter> detailFilters = this.genDetailFilter(request);
        detailFilters.add(new QFilter("attmain", "in", (Object)ids));
        HRBaseServiceHelper detailServiceHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
        DataSet dataSetDetail = detailServiceHelper.queryDataSet(this.getClass().getName() + ".queryDataSet_detail", SELECTS_DETAIL, detailFilters.toArray(new QFilter[0]));
        JoinDataSet join = dataSetBase.join(dataSetDetail);
        join.on("attmain", "attmain");
        List<String> leftList = Arrays.stream(dataSetBase.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        List<String> rightList = Arrays.stream(dataSetDetail.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        rightList.removeAll(leftList);
        join.select(leftList.toArray(new String[0]), rightList.toArray(new String[0]));
        return join.finish();
    }

    private void transferAttPeriodToDateRange(AttRecordReqModel request, List<QFilter> detailFilters) {
        Long attPeriodId = request.getPerattperiodid();
        DynamicObject attPeriod = this.getAttPeriod(attPeriodId);
        if (attPeriod != null) {
            detailFilters.add(new QFilter("owndate", ">=", (Object)attPeriod.getDate("begindate")));
            detailFilters.add(new QFilter("owndate", "<=", (Object)attPeriod.getDate("endDate")));
        }
    }

    private DynamicObject getAttPeriod(Long attPeriodId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("wtp_attperiodentry");
        QFilter[] qFilterArr = new QFilter[]{new QFilter("id", "=", (Object)attPeriodId)};
        return serviceHelper.queryOriginalOne("begindate,enddate", qFilterArr);
    }

    private List<QFilter> genBaseFilter(AttRecordReqModel request) {
        List<QFilter> detailFilters;
        List<Long> attFileIdList = request.getAttFileIdList();
        Long perattperiodid = request.getPerattperiodid();
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        qFilters.add(new QFilter("attfileid", "in", attFileIdList));
        if (perattperiodid != null) {
            qFilters.add(new QFilter("perattperiodid", "in", (Object)perattperiodid));
        }
        if (!(detailFilters = this.genDetailFilter(request)).isEmpty()) {
            qFilters.addAll(detailFilters);
        }
        return qFilters;
    }

    private List<QFilter> genDetailFilter(AttRecordReqModel request) {
        Date startOwnDate = request.getStartOwnDate();
        Date endOwnDate = request.getEndOwnDate();
        ArrayList qFilters = Lists.newArrayListWithExpectedSize((int)2);
        if (startOwnDate != null && endOwnDate != null) {
            qFilters.add(new QFilter("owndate", ">=", (Object)startOwnDate));
            qFilters.add(new QFilter("owndate", "<=", (Object)endOwnDate));
        } else {
            this.transferAttPeriodToDateRange(request, qFilters);
        }
        return qFilters;
    }
}

