/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtdtd.mservice.upgrade;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.task.upgrade.AbstractWtcTaskUpgrade;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;

public class AttIncrDecrRecordUpgrade
extends AbstractWtcTaskUpgrade {
    private static final Log LOG = LogFactory.getLog(AttIncrDecrRecordUpgrade.class);
    private static final HRBaseServiceHelper attIncrDecrHelper = new HRBaseServiceHelper("wtdtd_attincrdecr");
    private static final HRBaseServiceHelper attRecordHelper = new HRBaseServiceHelper("wtdtd_attrecorddetail");
    private static final HRBaseServiceHelper attRecordBaseHelper = new HRBaseServiceHelper("wtdtd_attrecordbase");
    private static final HRBaseServiceHelper incDecConfigHelper = new HRBaseServiceHelper("wtp_incdecconf");
    private static Integer SAVE_SIZE = 1000;
    private static final String[] DETAIL_SELECTS = new String[]{"attitemid", "owndate", "attitemvid", "value", "valuesecond", "valuelong", "valuestring", "attmain", "id"};
    private static final String[] BASE_SELECTS = new String[]{"id", "personid", "attfileid", "attfilevid"};

    protected String getJobId() {
        return "3Q0LK0B+U3+M";
    }

    protected String getScheduleId() {
        return "3Q0M27+=0HTJ";
    }

    public boolean process() {
        try (TXHandle txHandle = TX.required();){
            LOG.info("AttIncrDecrRecordUpgrade start ...");
            this.upgradeAction();
            LOG.info("AttIncrDecrRecordUpgrade end ...");
        }
        return true;
    }

    public void upgradeAction() {
        try {
            DynamicObject[] query = attIncrDecrHelper.query("id", null, "id", 1);
            if (null != query && query.length > 0) {
                LOG.warn("AttIncrDecrRecordUpgrade_replace_exec");
                return;
            }
            Set<Long> attItemIds = this.getAttItemIds();
            if (WTCCollections.isEmpty(attItemIds)) {
                return;
            }
            Date beginDate = WTCDateUtils.getZeroDate((Date)WTCDateUtils.toDate((LocalDate)LocalDate.of(2022, 10, 1)));
            Date endDate = WTCDateUtils.addDays((Date)new Date(), (int)2);
            DynamicObjectCollection recordList = new DynamicObjectCollection();
            while (beginDate.getTime() <= endDate.getTime()) {
                DataSet dataSet = this.queryAttRecord(attItemIds, beginDate);
                beginDate = WTCDateUtils.addDays((Date)beginDate, (int)1);
                if (dataSet.isEmpty()) continue;
                HashSet mainIds = Sets.newHashSetWithExpectedSize((int)30);
                for (Row dyn2 : dataSet.copy()) {
                    mainIds.add(dyn2.getLong("attmain"));
                }
                DynamicObject[] mainDys = this.queryAttBaseRecord(mainIds);
                if (null == mainDys || mainDys.length == 0) continue;
                Map mainMap = Arrays.stream(mainDys).collect(Collectors.toMap(dyn -> dyn.getLong("id"), Function.identity(), (v1, v2) -> v1));
                for (Row dyn3 : dataSet) {
                    DynamicObject attIncrDecr = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attincrdecr");
                    DynamicObject mainDyn = (DynamicObject)mainMap.get(dyn3.getLong("attmain"));
                    if (null == mainDyn) continue;
                    attIncrDecr.set("attfileid", (Object)mainDyn.getLong("attfileid"));
                    attIncrDecr.set("attfilevid", (Object)mainDyn.getLong("attfilevid"));
                    attIncrDecr.set("personid", (Object)mainDyn.getLong("personid"));
                    attIncrDecr.set("owndate", (Object)dyn3.getDate("owndate"));
                    attIncrDecr.set("attitemid", (Object)dyn3.getLong("attitemid"));
                    attIncrDecr.set("attitemvid", (Object)dyn3.getLong("attitemvid"));
                    attIncrDecr.set("value", (Object)dyn3.getBigDecimal("value"));
                    attIncrDecr.set("valuesecond", (Object)dyn3.getBigDecimal("valuesecond"));
                    attIncrDecr.set("valuelong", (Object)dyn3.getBigDecimal("valuelong"));
                    attIncrDecr.set("valuestring", (Object)dyn3.getString("valuestring"));
                    attIncrDecr.set("id", (Object)dyn3.getLong("id"));
                    recordList.add((Object)attIncrDecr);
                }
                dataSet.close();
                if (!WTCCollections.isNotEmpty((Collection)recordList) || recordList.size() < SAVE_SIZE) continue;
                attIncrDecrHelper.save(recordList);
                recordList.clear();
            }
            if (WTCCollections.isNotEmpty((Collection)recordList)) {
                attIncrDecrHelper.save(recordList);
            }
        }
        catch (Exception exception) {
            String msg = "AttIncrDecrRecordUpgrade exception";
            LOG.warn(msg, (Throwable)exception);
            throw new KDBizException((Throwable)exception, new ErrorCode("AttIncrDecrRecordUpgrade", msg), new Object[0]);
        }
    }

    private Set<Long> getAttItemIds() {
        DynamicObject[] configDons;
        HashSet attItemIds = Sets.newHashSetWithExpectedSize((int)16);
        QFilter[] qFilters = new QFilter[]{WTCHisServiceHelper.isCurrentVersion((boolean)false)};
        for (DynamicObject configDyn : configDons = incDecConfigHelper.loadDynamicObjectArray(qFilters)) {
            DynamicObjectCollection entryDys;
            if (HRStringUtils.equals((String)"2", (String)configDyn.getString("suittype")) || !HRStringUtils.equals((String)"A", (String)configDyn.getString("triggertype")) || WTCCollections.isEmpty((Collection)(entryDys = configDyn.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject entryDy : entryDys) {
                if (!entryDy.getBoolean("seriallimit")) continue;
                attItemIds.add(entryDy.getLong("curattitem.id"));
            }
        }
        return attItemIds;
    }

    private DataSet queryAttRecord(Set<Long> attItemIds, Date date) {
        QFilter qFilter = new QFilter("attitemid", "in", attItemIds);
        QFilter ownDate = new QFilter("owndate", "=", (Object)date);
        QFilter[] qFilters = new QFilter[]{qFilter, ownDate};
        return attRecordHelper.queryDataSet("AttIncrDecrRecordUpgrade.queryAttRecord", String.join((CharSequence)",", DETAIL_SELECTS), qFilters);
    }

    private DynamicObject[] queryAttBaseRecord(Set<Long> ids) {
        QFilter id = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{id};
        return attRecordBaseHelper.queryOriginalArray(String.join((CharSequence)",", BASE_SELECTS), qFilters);
    }
}

