/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtdtd.mservice.upgrade;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.wtc.wtbs.business.upgrade.WTCUpgradeService;
import kd.wtc.wtbs.common.util.WTCBatchHandleUtils;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class AttRecordPerAttPeriodIdUpgrade
extends WTCUpgradeService {
    private static final Log LOG = LogFactory.getLog(AttRecordPerAttPeriodIdUpgrade.class);
    private final List<Object[]> RECORD_BASE_PARAM = Lists.newArrayListWithExpectedSize((int)16);
    private static final String RECORD\uff3fBASE\uff3fROUTE\uff3fKEY = "wtc.wtdtd";
    private static final String RECORD\uff3fBASE\uff3fSELECT\uff3fSTR = "select fid,fpersonid ,fperattperiodid , fperperiodbegindate ,fperperiodenddate,fattperattperiodid  from  t_wtdtd_attrecordbase where  length ( concat(fattperattperiodid,'')) < 50;";
    private static final String RECORD\uff3fBASE\uff3fUPDATE\uff3fSQL = "update t_wtdtd_attrecordbase set fattperattperiodid =? where fid=?;";

    public void upgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        LOG.info("AttRecordPerAttPeriodIdUpgrade.upgradeAction start:{}", (Object)System.currentTimeMillis());
        try (TXHandle txHandle = TX.required();){
            WTCBatchHandleUtils.batchHandleCollection((Collection)Lists.newArrayListWithExpectedSize((int)16), this.RECORD_BASE_PARAM, (int)500, (Object)RECORD\uff3fBASE\uff3fUPDATE\uff3fSQL, this::batchUpdateRecordBase);
        }
        LOG.info("AttRecordPerAttPeriodIdUpgrade.upgradeAction end:{}", (Object)System.currentTimeMillis());
    }

    public void beforeUpgradeAction(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            super.beforeUpgradeAction(ver, iteration, dbKey, sqlFileName);
            this.initRecordBaseParam();
        }
        catch (Exception exception) {
            LOG.error("AttRecordPerAttPeriodIdUpgrade.beforeExecuteSqlWithResult error", (Throwable)exception);
            throw exception;
        }
    }

    private List<Object> batchUpdateRecordBase(List<Object[]> param, String executeStr) {
        DBRoute dbRoute = new DBRoute(RECORD\uff3fBASE\uff3fROUTE\uff3fKEY);
        HRDBUtil.executeBatch((DBRoute)dbRoute, (String)executeStr, param);
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    private void initRecordBaseParam() {
        DBRoute dbRoute = new DBRoute(RECORD\uff3fBASE\uff3fROUTE\uff3fKEY);
        DataSet dataSet = HRDBUtil.queryDataSet((String)"getAttRecordBasePerAttPeriodUpgradeData", (DBRoute)dbRoute, (String)RECORD\uff3fBASE\uff3fSELECT\uff3fSTR, null);
        this.addBaseParam(dataSet, this.RECORD_BASE_PARAM);
    }

    private void addBaseParam(DataSet dataSet, List<Object[]> totalBaseParam) {
        if (dataSet != null) {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long fId = row.getLong("fid");
                Long personId = row.getLong("fpersonid");
                Long perAttPeriodId = row.getLong("fperattperiodid");
                Date perPeriodBeginDate = row.getDate("fperperiodbegindate");
                Date perPeriodEndDate = row.getDate("fperperiodenddate");
                String key = String.join((CharSequence)"_", String.valueOf(personId), String.valueOf(perAttPeriodId), WTCDateUtils.date2Str((Date)perPeriodBeginDate, (String)"yyyy-MM-dd"), WTCDateUtils.date2Str((Date)perPeriodEndDate, (String)"yyyy-MM-dd"));
                totalBaseParam.add(new Object[]{key, fId});
            }
            dataSet.close();
        }
    }
}

