/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.mservice;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.wtc.wtbs.business.model.CircleRestVo;
import kd.wtc.wtbs.business.subject.AttPlainSubject;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.common.util.WTCAssert;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.core.TieEngineErrorCodes;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.attcaltask.AttFileInfo;
import kd.wtc.wtes.business.model.attcaltask.AttPersonRange;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.rlqt.AttRecordDetailHolder;
import kd.wtc.wtes.business.model.rlqt.QTUseConfig;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTDateConfigTypeEnum;
import kd.wtc.wtes.business.model.rlqt.qtenum.QTFloatUnitEnum;
import kd.wtc.wtes.business.quota.engine.IQuotaEngineConfig;
import kd.wtc.wtes.business.quota.engine.QuotaEngineConfigImpl;
import kd.wtc.wtes.business.quota.engine.QuotaEngineServiceImpl;
import kd.wtc.wtes.business.quota.init.QuotaInitParamRequest;
import kd.wtc.wtes.business.quota.init.QuotaInitParamResult;
import kd.wtc.wtes.business.quota.init.QuotaParamInitException;
import kd.wtc.wtes.business.quota.init.QuotaParamInitializer;
import kd.wtc.wtes.business.quota.init.TieInitCycleSetForQuota;
import kd.wtc.wtes.business.quota.model.QuotaCycInfo;
import kd.wtc.wtes.business.quota.service.QuotaRequest;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;
import kd.wtc.wtes.business.quota.util.RefDateUtils;
import kd.wtc.wtes.common.util.CollectionUtils;
import kd.wtc.wtes.common.util.LogUtils;
import kd.wtc.wtes.mservice.api.IQtTieService;
import kd.wtc.wtp.business.cumulate.trading.model.QTLineDetailComponent;

public class QtTieServiceImpl
implements IQtTieService {
    private static final Log LOGGER = LogFactory.getLog(QtTieServiceImpl.class);

    public void syncSubmitTieEngine(WTCTaskParam taskParams) {
        QuotaRequestStd tieRequestByTask = this.getQtTieRequestByTask(taskParams);
        QuotaEngineServiceImpl tieEngineService = new QuotaEngineServiceImpl();
        tieEngineService.submitSyncQuotaRequest(tieRequestByTask);
    }

    private QuotaRequestStd getQtTieRequestByTask(WTCTaskParam taskParams) {
        Object checkAuth;
        QuotaRequestStd quotaRequestStd = new QuotaRequestStd();
        quotaRequestStd.setTest(taskParams.isTrialTask());
        quotaRequestStd.setSubTaskId(taskParams.getTaskId());
        quotaRequestStd.setTaskId(taskParams.getMainTaskId());
        quotaRequestStd.setShardingIndex(taskParams.getShardingIndex());
        quotaRequestStd.setVersion(taskParams.getTaskVersion());
        Date startDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("startDate")), (String)"yyyy-MM-dd HH:mm:ss");
        quotaRequestStd.setStartDate(startDate == null ? null : startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        Date endDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("endDate")), (String)"yyyy-MM-dd HH:mm:ss");
        quotaRequestStd.setEndDate(endDate == null ? null : endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        Object param = taskParams.getParam("saveStep");
        quotaRequestStd.setSaveEvaluationDetail(((Boolean)param).booleanValue());
        quotaRequestStd.setPlanId(taskParams.getParam("planId") == null ? 0L : Long.parseLong(taskParams.getParam("planId").toString()));
        quotaRequestStd.setTiePlanId(taskParams.getParam("tiePlanId") == null ? 0L : Long.parseLong(taskParams.getParam("tiePlanId").toString()));
        quotaRequestStd.setCreateTime(LocalDateTime.now());
        quotaRequestStd.setCreateUserId(taskParams.getCreatorId());
        quotaRequestStd.setRegQtTypeIds((List)taskParams.getParam("qttype"));
        quotaRequestStd.setDyQtTypeIds((List)taskParams.getParam("dyqttype"));
        quotaRequestStd.setAccountMode((String)taskParams.getParam("accountmode"));
        Object computingBillId = taskParams.getParam("computingBillId");
        if (computingBillId != null) {
            quotaRequestStd.setComputingBillId(Long.parseLong(computingBillId.toString()));
        }
        if (null != (checkAuth = taskParams.getParam("checkAuth"))) {
            quotaRequestStd.setCheckAuth(((Boolean)checkAuth).booleanValue());
        }
        this.buildTaskSharding(quotaRequestStd, taskParams.getTaskShardingDetails());
        return quotaRequestStd;
    }

    private void buildTaskSharding(QuotaRequestStd tieRequestStd, List taskShardingDetails) {
        List shareDetails = taskShardingDetails;
        Set personIds = shareDetails.stream().map(shardingDetail -> shardingDetail.getAttPersonId()).collect(Collectors.toSet());
        tieRequestStd.setAttPersonIds(new ArrayList(personIds));
        Set BoIds = shareDetails.stream().map(shardingDetail -> shardingDetail.getAttFileBoId()).collect(Collectors.toSet());
        tieRequestStd.setAttFileBoIds(new ArrayList(BoIds));
        tieRequestStd.setAttPlainSubject(shareDetails.stream().map(this::buildAttSubject).collect(Collectors.toList()));
    }

    private AttPlainSubject buildAttSubject(WTCTaskCalShardingDetail shardingDetail) {
        AttPlainSubject subject = new AttPlainSubject();
        subject.setAttPersonId(shardingDetail.getAttPersonId());
        subject.setAttFileBoid(shardingDetail.getAttFileBoId());
        return subject;
    }

    public List<QTLineDetailComponent> getQuotaInitParam(List<QTLineDetailComponent> componentList) {
        long starttime = System.currentTimeMillis();
        if (componentList == null) {
            return new ArrayList<QTLineDetailComponent>();
        }
        HashSet<String> needRunInitializer = new HashSet<String>();
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitializerExtPluginForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitQTTypeForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitializerAttPeriodForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitializerAttFileForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitializerAttPersonInfoForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitEmployeeForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitializerRuleEngineForQuota");
        needRunInitializer.add("kd.wtc.wtes.business.quota.init.TieInitCycleSetForQuota");
        LOGGER.debug("invoke componentList is {}", (Object)componentList.size());
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        IQuotaEngineConfig quotaConfig = QuotaEngineConfigImpl.DEFAULT;
        QuotaRequestStd tieRequestByTask = this.getQtTieRequestByComponent(componentList);
        tieRequestByTask.setExtAttribute("KEY_CALL_BY", (Object)"CALL_BY_MS_FOR_INSERT_QT_DETAIL");
        List<AttPersonRange> attSubjects = this.dealAttPersonRangeByList(componentList);
        for (List list : quotaConfig.getInitialises()) {
            List<QuotaParamInitializer> copyList = list.stream().filter(ele -> needRunInitializer.contains(ele.getClass().getName())).collect(Collectors.toList());
            if (copyList.size() == 1 && copyList.get(0) instanceof TieInitCycleSetForQuota) {
                TieInitCycleSetForQuota iniExe = (TieInitCycleSetForQuota)copyList.get(0);
                iniExe.setLoadBill(false);
            }
            Map<String, Object> initParamsTemp = this.loadInitParams(copyList, (QuotaRequest)tieRequestByTask, attSubjects, initParams);
            initParams.putAll(initParamsTemp);
        }
        AttRecordDetailHolder holder = (AttRecordDetailHolder)initParams.get("QT_ATT_RECORD_DETAIL");
        block1: for (QTLineDetailComponent component : componentList) {
            if (null == holder || null == holder.getCycSetMap()) {
                component.setErrorCode("err_qttype");
                component.setErrMsg(ResManager.loadKDString((String)"\u8be5\u5b9a\u989d\u7c7b\u578b\u7f3a\u5c11\u6709\u6548\u7684\u671f\u95f4\u4fe1\u606f\u3002", (String)"QtTieServiceImpl_1", (String)"wtc-wtes-mservice", (Object[])new Object[0]));
                continue;
            }
            QuotaCycInfo quotaCycInfo = (QuotaCycInfo)holder.getCycSetMap().get(component.getAttFileBoId() + "_" + component.getQtTypeId());
            if (null == quotaCycInfo) {
                component.setErrorCode("err_qttype");
                component.setErrMsg(ResManager.loadKDString((String)"\u8be5\u5b9a\u989d\u7c7b\u578b\u7f3a\u5c11\u6709\u6548\u7684\u671f\u95f4\u4fe1\u606f\u3002", (String)"QtTieServiceImpl_1", (String)"wtc-wtes-mservice", (Object[])new Object[0]));
                continue;
            }
            List voList = quotaCycInfo.getRestVos();
            if (null == voList || voList.isEmpty()) {
                component.setErrorCode("err_qttype");
                component.setErrMsg(ResManager.loadKDString((String)"\u8be5\u5b9a\u989d\u7c7b\u578b\u7f3a\u5c11\u6709\u6548\u7684\u671f\u95f4\u4fe1\u606f\u3002", (String)"QtTieServiceImpl_1", (String)"wtc-wtes-mservice", (Object[])new Object[0]));
                continue;
            }
            component.setMinCycStartDate(voList.stream().map(CircleRestVo::getStartDate).min(Date::compareTo).get());
            component.setMaxCycEndDate(voList.stream().map(CircleRestVo::getEndDate).max(Date::compareTo).get());
            for (CircleRestVo vo : voList) {
                if (component.getGenStartDate().compareTo(vo.getStartDate()) < 0 || component.getGenStartDate().compareTo(vo.getEndDate()) > 0) continue;
                component.setpCycleId(vo.getCycSetId().longValue());
                component.setPeriodNum(vo.getIndex().intValue());
                component.setGenEndDate(vo.getEndDate());
                this.dealUserDateWithRule(component, vo, quotaCycInfo, initParams);
                if (component.getUseStartDate().after(component.getUseEndDate())) {
                    component.setErrMsg(ResManager.loadKDString((String)"\u914d\u7f6e\u7684\u4f7f\u7528\u7ed3\u675f\u65f6\u95f4\u65e9\u4e8e\u4f7f\u7528\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u3010\u8003\u52e4\u6863\u6848\u3011\u4e0b\u3010\u5b9a\u989d\u65b9\u6848\u3011\u5185\u7684\u3010\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\u3011\u7684\u914d\u7f6e\u9879\u3002", (String)"QtTieServiceImpl_2", (String)"wtc-wtes-mservice", (Object[])new Object[0]));
                    continue block1;
                }
                component.setAssignDate(vo.getAssignDate());
                component.setOwnValueItemId(quotaCycInfo.getEnjoyAttItem());
                component.setUsableValueItemId(quotaCycInfo.getUsableAttItem());
                continue block1;
            }
        }
        LOGGER.debug("invoke componentList end ,cost time is {}", (Object)(System.currentTimeMillis() - starttime));
        return componentList;
    }

    private void dealUserDateWithRule(QTLineDetailComponent component, CircleRestVo vo, QuotaCycInfo quotaCycInfo, Map<String, Object> initParams) {
        if (null != quotaCycInfo.getQtUseConfig()) {
            Date useEndDate;
            QTUseConfig qtUseConfig = quotaCycInfo.getQtUseConfig();
            QTDateConfigTypeEnum qtDateConfigTypeEnum = qtUseConfig.getUseStartDate();
            Date useStartDate = QTDateConfigTypeEnum.QT_DATE_START == qtDateConfigTypeEnum ? component.getGenStartDate() : component.getGenEndDate();
            QTDateConfigTypeEnum qtEndDateConfigTypeEnum = qtUseConfig.getUseEndDate();
            Date date = useEndDate = QTDateConfigTypeEnum.QT_DATE_START == qtEndDateConfigTypeEnum ? component.getGenStartDate() : component.getGenEndDate();
            if (qtUseConfig.getStartDelay().booleanValue() && qtUseConfig.getsDelay() != 0) {
                useStartDate = this.dealDelayDate(useStartDate, qtUseConfig.getStartFloatUnit(), qtUseConfig.getsDelay());
            }
            if (qtUseConfig.getEndDelay().booleanValue() && qtUseConfig.geteDelay() != 0) {
                useEndDate = this.dealDelayDate(useEndDate, qtUseConfig.getEndFloatUnit(), qtUseConfig.geteDelay());
            }
            List expectRefDateIdList = Stream.of(qtUseConfig.getStartLimit(), qtUseConfig.getEndLimit()).filter(ele -> ele != 0L).collect(Collectors.toList());
            AttFileCabinet attFileCabinet = (AttFileCabinet)initParams.get("ATT_FILE");
            AttFileModel attFileModel = attFileCabinet.getByAttPersonIdAndDate(component.getAttPersonId(), WTCDateUtils.toLocalDate((Date)component.getGenStartDate()));
            AttendPersonData attendPersonData = (AttendPersonData)initParams.get("ATT_PERINFO");
            AttendPersonModel byBidAndDate = attendPersonData.getByBidAndDate(attFileModel, WTCDateUtils.toLocalDate((Date)component.getGenStartDate()));
            Map refDateMap = RefDateUtils.getRefDateMap((AttendPersonModel)byBidAndDate, (AttFileModel)attFileModel, (long)component.getAttPersonId(), expectRefDateIdList, (LocalDate)WTCDateUtils.toLocalDate((Date)vo.getEndDate()), initParams);
            Date startSpeDate = (Date)refDateMap.get(qtUseConfig.getStartLimit());
            useStartDate = startSpeDate != null && startSpeDate.after(useStartDate) ? startSpeDate : useStartDate;
            Date endSpeDate = (Date)refDateMap.get(qtUseConfig.getEndLimit());
            useEndDate = endSpeDate != null && endSpeDate.before(useEndDate) ? endSpeDate : useEndDate;
            component.setUseStartDate(useStartDate);
            component.setUseEndDate(useEndDate);
        } else {
            component.setUseStartDate(vo.getStartDate());
            component.setUseEndDate(vo.getEndDate());
        }
    }

    private Date dealDelayDate(Date useDate, QTFloatUnitEnum qtFloatUnitEnum, int delay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(useDate);
        int dateUnit = QTFloatUnitEnum.NATURAL_DAY == qtFloatUnitEnum ? 5 : 2;
        calendar.add(dateUnit, delay);
        return calendar.getTime();
    }

    private Map<String, Object> loadInitParams(List<QuotaParamInitializer> initialises, QuotaInitParamRequest initRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>(initialises.size());
        for (QuotaParamInitializer initializer : initialises) {
            QuotaInitParamResult initResult = null;
            QuotaParamInitializer currentInitializer = initializer;
            try {
                initResult = initializer.init(initRequest);
            }
            catch (QuotaParamInitException exception) {
                LOGGER.warn("{}\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38{}", (Object)initializer.category(), (Object)exception);
            }
            if (null == initResult || !initResult.hasParams()) continue;
            params.put(initializer.category(), initResult.getInitData());
        }
        return params;
    }

    private Map<String, Object> loadInitParams(List<QuotaParamInitializer> initialises, QuotaRequest tieRequest, List<AttPersonRange> attSubjects, Map<String, Object> initParams) {
        if (CollectionUtils.isEmpty(initialises)) {
            LogUtils.warning((Log)LOGGER, (ErrorCode)TieEngineErrorCodes.getNonParamInitializer(), (Object[])new Object[0]);
            return Collections.emptyMap();
        }
        LocalDate initStartDate = tieRequest.getStartDate();
        LocalDate initEndDate = tieRequest.getEndDate();
        for (AttPersonRange attSubject : attSubjects) {
            if (null == initStartDate || initStartDate.isAfter(WTCDateUtils.toLocalDate((Date)attSubject.getStartDate()))) {
                initStartDate = WTCDateUtils.toLocalDate((Date)attSubject.getStartDate());
            }
            if (null != initEndDate && !initEndDate.isBefore(WTCDateUtils.toLocalDate((Date)attSubject.getEndDate()))) continue;
            initEndDate = WTCDateUtils.toLocalDate((Date)attSubject.getEndDate());
        }
        WTCAssert.nonNull((Object)initStartDate, (String)"initStartDate");
        WTCAssert.nonNull((Object)initEndDate, (String)"initEndDate");
        QuotaInitParamRequest initRequest = new QuotaInitParamRequest(tieRequest.getAttPersonIds(), initStartDate.plusDays(-2L), initEndDate.plusDays(2L), tieRequest, attSubjects);
        initRequest.putInitParams(initParams);
        initRequest.setExtAttribute("KEY_CALL_BY", (Object)"CALL_BY_MS_FOR_INSERT_QT_DETAIL");
        return this.loadInitParams(initialises, initRequest);
    }

    private QuotaRequestStd getQtTieRequestByComponent(List<QTLineDetailComponent> componentList) {
        QuotaRequestStd quotaRequestStd = new QuotaRequestStd();
        quotaRequestStd.setTest(false);
        quotaRequestStd.setSubTaskId(0L);
        quotaRequestStd.setTaskId(0L);
        quotaRequestStd.setShardingIndex(0);
        quotaRequestStd.setVersion("TEMP_VERSION");
        quotaRequestStd.setAccountMode("C");
        Date startDate = null;
        Date endDate = null;
        HashSet<Long> qtTypeSet = new HashSet<Long>(16);
        HashSet<Long> personIds = new HashSet<Long>(16);
        HashSet<Long> boIds = new HashSet<Long>(16);
        for (QTLineDetailComponent component : componentList) {
            if (startDate == null || startDate.after(component.getGenStartDate())) {
                startDate = component.getGenStartDate();
            }
            if (endDate == null || endDate.before(component.getGenStartDate())) {
                endDate = component.getGenStartDate();
            }
            qtTypeSet.add(component.getQtTypeId());
            personIds.add(component.getAttPersonId());
            boIds.add(component.getAttFileBoId());
        }
        quotaRequestStd.setStartDate(startDate == null ? null : startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        quotaRequestStd.setEndDate(endDate == null ? null : endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        quotaRequestStd.setSaveEvaluationDetail(false);
        quotaRequestStd.setPlanId(0L);
        quotaRequestStd.setCreateTime(LocalDateTime.now());
        quotaRequestStd.setCreateUserId(0L);
        quotaRequestStd.setRegQtTypeIds(new ArrayList(qtTypeSet));
        quotaRequestStd.setDyQtTypeIds(Collections.emptyList());
        quotaRequestStd.setCheckAuth(false);
        quotaRequestStd.setAttPersonIds(new ArrayList(personIds));
        quotaRequestStd.setAttFileBoIds(new ArrayList(boIds));
        return quotaRequestStd;
    }

    private List<AttPersonRange> dealAttPersonRangeByList(List<QTLineDetailComponent> componentList) {
        ArrayList<AttPersonRange> rangeList = new ArrayList<AttPersonRange>(16);
        HashMap rangeMap = Maps.newHashMapWithExpectedSize((int)16);
        for (QTLineDetailComponent qTLineDetailComponent : componentList) {
            if (qTLineDetailComponent.getGenStartDate() == null) continue;
            AttPersonRange attPersonRange = (AttPersonRange)rangeMap.get(qTLineDetailComponent.getAttPersonId());
            if (null == attPersonRange) {
                attPersonRange = new AttPersonRange();
                attPersonRange.setStartDate(qTLineDetailComponent.getGenStartDate());
                attPersonRange.setEndDate(qTLineDetailComponent.getGenStartDate());
                attPersonRange.setPersonId(Long.valueOf(qTLineDetailComponent.getAttPersonId()));
                attPersonRange.setAttFileBaseBoId(Long.valueOf(qTLineDetailComponent.getAttFileBoId()));
                HashSet<Long> attFileSet = new HashSet<Long>();
                attFileSet.add(qTLineDetailComponent.getAttFileBoId());
                ArrayList<AttFileInfo> attFileInfos = new ArrayList<AttFileInfo>();
                AttFileInfo attFileInfo = new AttFileInfo();
                attFileInfo.setPersonId(Long.valueOf(qTLineDetailComponent.getAttPersonId()));
                attFileInfo.setAttFileBaseBoId(Long.valueOf(qTLineDetailComponent.getAttFileBoId()));
                attFileInfo.setStartDate(qTLineDetailComponent.getGenStartDate());
                attFileInfo.setEndDate(qTLineDetailComponent.getGenStartDate());
                attFileInfos.add(attFileInfo);
                attPersonRange.setAttFileBoIdList(attFileSet);
                attPersonRange.setAttFileInfoList(attFileInfos);
            } else {
                if (attPersonRange.getStartDate().after(qTLineDetailComponent.getGenStartDate())) {
                    attPersonRange.setStartDate(qTLineDetailComponent.getGenStartDate());
                } else {
                    attPersonRange.setAttFileBaseBoId(Long.valueOf(qTLineDetailComponent.getAttFileBoId()));
                }
                if (attPersonRange.getEndDate().before(qTLineDetailComponent.getGenStartDate())) {
                    attPersonRange.setEndDate(qTLineDetailComponent.getGenStartDate());
                }
                AttFileInfo attFileInfo = new AttFileInfo();
                attFileInfo.setPersonId(Long.valueOf(qTLineDetailComponent.getAttPersonId()));
                attFileInfo.setAttFileBaseBoId(Long.valueOf(qTLineDetailComponent.getAttFileBoId()));
                attFileInfo.setStartDate(qTLineDetailComponent.getGenStartDate());
                attFileInfo.setEndDate(qTLineDetailComponent.getGenStartDate());
                attPersonRange.getAttFileBoIdList().add(qTLineDetailComponent.getAttFileBoId());
                attPersonRange.getAttFileInfoList().add(attFileInfo);
            }
            rangeMap.put(attPersonRange.getPersonId(), attPersonRange);
        }
        for (Map.Entry entry : rangeMap.entrySet()) {
            rangeList.add((AttPersonRange)entry.getValue());
        }
        return rangeList;
    }
}

