/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.mservice;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.model.TimeInterval;
import kd.wtc.wtbs.common.model.TimeIntervalResult;
import kd.wtc.wtbs.common.model.evaluation.Shift;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.AbstractSplitTimeBucket;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.RawPara;
import kd.wtc.wtes.business.executor.rlra.pairtime.core.SplitStrategyFactory;
import kd.wtc.wtes.business.model.Roster;
import kd.wtc.wtes.business.std.chain.TieContextStd;
import kd.wtc.wtes.business.std.datanode.TimeBucket;
import kd.wtc.wtes.business.util.ShiftSwitchUtil;
import kd.wtc.wtes.mservice.api.IShiftSplitService;

public class ShiftSplitServiceImpl
implements IShiftSplitService {
    private static final Log logger = LogFactory.getLog(ShiftSplitServiceImpl.class);

    public List<TimeIntervalResult> shiftSplitSimple(TimeInterval timeInterval) {
        Date rosterDate = timeInterval.getRosterDate();
        logger.debug("timeIntervalShift {}", (Object)timeInterval.getShiftSpec());
        AbstractSplitTimeBucket splitTimeBucket = SplitStrategyFactory.getSplitStrategy(null, (String)"4", (boolean)false);
        RawPara rawPara = new RawPara(rosterDate, null, Collections.emptyList(), "4");
        rawPara.setTimeInterval(timeInterval);
        Roster roster = ShiftSwitchUtil.toRoster((Shift)timeInterval.getShiftSpec(), (LocalDate)WTCDateUtils.toLocalDate((Date)timeInterval.getRosterDate()));
        rawPara.setRoster(roster);
        List timeBuckets = splitTimeBucket.calculateForBillTrial(new TieContextStd(null), rawPara);
        ArrayList<TimeIntervalResult> resultList = new ArrayList<TimeIntervalResult>(10);
        for (TimeBucket timeBucket : timeBuckets) {
            TimeIntervalResult timeIntervalResult = new TimeIntervalResult();
            timeIntervalResult.setDateType(timeInterval.getDateType());
            timeIntervalResult.setRosterDate(timeInterval.getRosterDate());
            timeIntervalResult.setShiftSpec(timeInterval.getShiftSpec());
            timeIntervalResult.setIntervalStartDate(WTCDateUtils.toDate((LocalDateTime)timeBucket.getStartTime()));
            timeIntervalResult.setIntervalEndDate(WTCDateUtils.toDate((LocalDateTime)timeBucket.getEndTime()));
            timeIntervalResult.setShiftTimeBucketProperty(timeBucket.getShiftTimeBucketProperty().code);
            timeIntervalResult.setTimeBucketPosition(timeBucket.getTimeBucketPosition().code);
            logger.debug("StartTime={},EndTime={},ShiftTimeBucketProperty={},TimeBucketPosition={}", new Object[]{timeBucket.getStartTime(), timeBucket.getEndTime(), timeBucket.getShiftTimeBucketProperty().code, timeBucket.getTimeBucketPosition().code});
            resultList.add(timeIntervalResult);
        }
        return resultList;
    }
}

