/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.mservice;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.subject.AttPlainSubject;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtbs.business.task.sharding.WTCShardingTask;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtes.business.engine.TieEngineServiceImpl;
import kd.wtc.wtes.business.std.TieRequestStd;
import kd.wtc.wtes.mservice.api.ITieService;

public class TieServiceImpl
implements ITieService {
    private static final Log LOGGER = LogFactory.getLog(TieServiceImpl.class);

    public void submitTieEngine(WTCTaskDispatchRequest request) {
        LOGGER.debug("receive dispatch request\uff1a{}", (Object)request);
        TieRequestStd tieRequestStd = this.getTieRequest(request);
        TieEngineServiceImpl tieEngineService = new TieEngineServiceImpl();
        tieEngineService.submitTieRequest(tieRequestStd);
    }

    public void syncSubmitTieEngine(WTCTaskParam taskParams) {
        TieRequestStd tieRequestByTask = this.getTieRequestByTask(taskParams);
        TieEngineServiceImpl tieEngineService = new TieEngineServiceImpl();
        tieEngineService.submitSyncTieRequest(tieRequestByTask);
    }

    private TieRequestStd getTieRequestByTask(WTCTaskParam taskParams) {
        TieRequestStd tieRequestStd = new TieRequestStd();
        tieRequestStd.setVersion(taskParams.getTaskVersion());
        tieRequestStd.setTest(taskParams.isTrialTask());
        tieRequestStd.setTaskId(taskParams.getMainTaskId());
        tieRequestStd.setSubTaskId(taskParams.getTaskId());
        tieRequestStd.setShardingIndex(taskParams.getShardingIndex());
        Date startDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("startDate")), (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = WTCDateUtils.str2Date((String)String.valueOf(taskParams.getParam("endDate")), (String)"yyyy-MM-dd HH:mm:ss");
        tieRequestStd.setStartDate(startDate == null ? null : startDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        tieRequestStd.setEndDate(endDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        tieRequestStd.setPlanId(taskParams.getParam("planId") == null ? 0L : Long.parseLong(taskParams.getParam("planId").toString()));
        Object param = taskParams.getParam("saveStep");
        tieRequestStd.setSaveEvaluationDetail(((Boolean)param).booleanValue());
        Object checkAuth = taskParams.getParam("checkAuth");
        if (null != checkAuth) {
            tieRequestStd.setCheckAuth(((Boolean)checkAuth).booleanValue());
        }
        tieRequestStd.setCreateTime(LocalDateTime.now());
        tieRequestStd.setCreateUserId(taskParams.getCreatorId());
        this.buildTaskSharding(tieRequestStd, taskParams.getTaskShardingDetails());
        return tieRequestStd;
    }

    private void buildTaskSharding(TieRequestStd tieRequestStd, List taskShardingDetails) {
        List shareDetails = taskShardingDetails;
        Set personIds = shareDetails.stream().map(shardingDetail -> shardingDetail.getAttPersonId()).collect(Collectors.toSet());
        Set BoIds = shareDetails.stream().map(shardingDetail -> shardingDetail.getAttFileBoId()).collect(Collectors.toSet());
        tieRequestStd.setAttPlainSubject(shareDetails.stream().map(this::buildAttSubject).collect(Collectors.toList()));
        tieRequestStd.setAttPersonIds(new ArrayList(personIds));
        tieRequestStd.setAttFileBoIds(new ArrayList(BoIds));
    }

    private TieRequestStd getTieRequest(WTCTaskDispatchRequest request) {
        WTCTaskRequestStd taskRequest = (WTCTaskRequestStd)request.getTaskRequest();
        WTCShardingTask shardingTask = request.getShardingTask();
        TieRequestStd tieRequestStd = new TieRequestStd();
        tieRequestStd.setVersion(taskRequest.getVersion());
        tieRequestStd.setTest(taskRequest.isTrial());
        tieRequestStd.setTaskId(taskRequest.getTaskId());
        tieRequestStd.setSubTaskId(shardingTask.getSubTaskId());
        tieRequestStd.setShardingIndex(shardingTask.getIndex());
        tieRequestStd.setStartDate(taskRequest.getStartDate() == null ? null : taskRequest.getStartDate().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        tieRequestStd.setEndDate(taskRequest.getEndDate().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        Object param = taskRequest.getParam("saveStep");
        tieRequestStd.setSaveEvaluationDetail(((Boolean)param).booleanValue());
        tieRequestStd.setPlanId(taskRequest.getParam("planId") == null ? 0L : Long.parseLong(taskRequest.getParam("planId").toString()));
        tieRequestStd.setCreateUserId(taskRequest.getCreatorId());
        RequestContext.get().setUserId(taskRequest.getCreatorId() + "");
        tieRequestStd.setCreateTime(LocalDateTime.now());
        this.buildTaskSharding(tieRequestStd, shardingTask.getTaskShardingDetails());
        return tieRequestStd;
    }

    private AttPlainSubject buildAttSubject(WTCTaskCalShardingDetail shardingDetail) {
        AttPlainSubject subject = new AttPlainSubject();
        subject.setAttPersonId(shardingDetail.getAttPersonId());
        subject.setAttFileBoid(shardingDetail.getAttFileBoId());
        return subject;
    }
}

