/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.mservice.taskconsumer;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.caltask.common.WTCCalSubTaskEntity;
import kd.wtc.wtbs.business.helper.WTCTaskServiceHelper;
import kd.wtc.wtbs.business.task.common.WTCSubTaskEntity;
import kd.wtc.wtbs.business.task.common.WTCSubTaskStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.concurrencyctrl.TaskConcurrencyCtrlHelper;
import kd.wtc.wtbs.business.task.executor.WTCShardingAbleTask;
import kd.wtc.wtbs.business.task.executor.WTCTaskParam;
import kd.wtc.wtes.mservice.TieServiceImpl;

public class TieTaskConsumer
extends WTCShardingAbleTask {
    public void execute(RequestContext requestContext, WTCTaskParam taskParams) {
        TieServiceImpl tieEngineService = new TieServiceImpl();
        tieEngineService.syncSubmitTieEngine(taskParams);
        WTCShardingAbleTask.WTCShardingTaskHelper.reportProgress((long)taskParams.getTaskId(), (int)100);
    }

    protected boolean onBizCodeError(WTCTaskParam taskParam, Throwable throwable) {
        String errMsg = "Engine accident error:" + throwable.getMessage();
        QFilter countingStatus = new QFilter("taskdetailstate", "=", (Object)WTCTaskDetailStatus.ACCOUNTING.code);
        List wtcCalTaskDetailEntities = WTCTaskServiceHelper.batchLoadTaskDetailByTaskIdAndSubTaskId((String)"wtte_tie", (long)taskParam.getMainTaskId(), (long)taskParam.getTaskId(), (QFilter)countingStatus);
        HashSet attPersonIdSet = new HashSet();
        wtcCalTaskDetailEntities.forEach(detail -> {
            attPersonIdSet.add(detail.getAttPersonId());
            detail.setExInfo(errMsg);
            detail.setTaskDetailState(WTCTaskDetailStatus.FAIL);
        });
        WTCTaskServiceHelper.batchUpdateTaskDetailInfoBySubTaskIdAndAttFileBoId((List)wtcCalTaskDetailEntities, (String)"wtte_tie");
        WTCCalSubTaskEntity subTask = WTCTaskServiceHelper.loadSubTaskById((String)taskParam.getTaskCategory(), (long)taskParam.getTaskId());
        subTask.setFailedAttFile(subTask.getFailedAttFile() + wtcCalTaskDetailEntities.size());
        subTask.setFailedAttPerson(subTask.getFailedAttPerson() + attPersonIdSet.size());
        subTask.setRunAttFile(subTask.getSucceedAttFile() + subTask.getFailedAttFile());
        subTask.setRunAttPerson(subTask.getSucceedAttPerson() + subTask.getFailedAttPerson());
        subTask.setSubTaskStatus(WTCSubTaskStatus.ERROR);
        WTCTaskServiceHelper.updateTaskSub((String)taskParam.getTaskCategory(), (WTCSubTaskEntity)subTask);
        TaskConcurrencyCtrlHelper.getInstance().deleteBySubTaskIds(taskParam.getTaskCategory(), Collections.singletonList(taskParam.getTaskId()));
        return true;
    }
}

