/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.pairtime;

import java.util.Date;
import kd.wtc.wtes.common.enums.BillNonPlanEnum;
import kd.wtc.wtes.common.pairtime.SourceCode;
import kd.wtc.wtes.common.pairtime.TimePointSource;

public class AbstractCardPoint {
    public static final int BEFORE_DUTY = 1;
    public static final int ONDUTY_SUPPOSED_1 = 2;
    public static final int ONDUTY_SUPPOSED_2 = 3;
    public static final int IN_DUTY_IN = 4;
    public static final int IN_DUTY_MORNING_IN = 5;
    public static final int IN_DUTY_AFTERNOON_IN = 6;
    public static final int IN_DUTY_OUT = 7;
    public static final int IN_DUTY_MORNING_OUT = 8;
    public static final int IN_DUTY_AFTERNOON_OUT = 9;
    public static final int OFFDUTY_SUPPOSED_1 = 10;
    public static final int OFFDUTY_SUPPOSED_2 = 11;
    public static final int IN_REST_1 = 12;
    public static final int IN_REST_2 = 13;
    public static final int ON_REST_START = 14;
    public static final int ON_REST_END = 15;
    public static final int AFTER_DUTY = 16;
    public static final int CORE_TIME_START = 17;
    public static final int CORE_TIME_END = 18;
    public static final int ONDUTY_SUPPOSED_EQ_EFFECTIVE = 19;
    public static final int ONDUTY_EFFECTIVE_AND_SUPPOSED = 41;
    public static final int OFFDUTY_SUPPOSED_EQ_EFFECTIVE = 20;
    public static final int OFFDUTY_EFFECTIVE_AND_SUPPOSED = 42;
    public static final int ONDUTY_EFFECTIVE_BEFORE = 21;
    public static final int ONDUTY_EFFECTIVE_AFTER = 22;
    public static final int OFFDUTY_EFFECTIVE_BEFORE = 23;
    public static final int OFFDUTY_EFFECTIVE_AFTER = 24;
    public static final int ONDUTY_NORMAL_OFFDUTY_SUPPLE = 25;
    public static final int OFFDUTY_NORMAL_ONDUTY_SUPPLE = 26;
    public static final int OT_BILL_START = 27;
    public static final int OT_BILL_END = 28;
    public static final int OFF_EFFECTIVE_START = 29;
    public static final int OFF_EFFECTIVE_START_NON_OFF_DUTY = 48;
    public static final int OFF_EFFECTIVE_END = 30;
    public static final int VA_BILL_START = 31;
    public static final int VA_BILL_END = 32;
    public static final int TL_BILL_START = 33;
    public static final int TL_BILL_END = 34;
    public static final int IN_ABSENT_BEFORE_START = 35;
    public static final int IN_ABSENT_BETWEEN = 36;
    public static final int IN_ABSENT_EQ_START = 37;
    public static final int OUT_ABSENT_EQ_END = 38;
    public static final int OUT_ABSENT_AFTER_END = 39;
    public static final int OUT_ABSENT_BETWEEN = 40;
    public static final int OVER_TIME_START = 43;
    public static final int OVER_TIME_END = 44;
    public static final int NON_TIME_OT = 45;
    public static final int NON_TIME_VA = 46;
    public static final int NON_TIME_BT = 47;
    public static final int WORK_TIME_START = 49;
    public static final int WORK_TIME_END = 50;
    private int pointType;
    private Date timePoint;
    private AbstractCardPoint pairOfOtherOne;
    private long billId;
    private long billEntryId;
    private long billType;
    private Long billTime;
    private BillNonPlanEnum billNonPlan;
    private TimePointSource source;
    private int inCardTag = 0;
    public static final int NONE = 0;
    public static final int IN_CARD = 1;
    public static final int OUT_CARD = 2;

    public String toString() {
        return "AbstractCardPoint{pointType=" + this.pointType + ", timePoint=" + this.timePoint + ", sourceCode=" + (Object)((Object)this.source.getSourceCode()) + '}';
    }

    public AbstractCardPoint() {
    }

    public AbstractCardPoint(int pointType, Date timePoint, SourceCode sourceCode) {
        this.pointType = pointType;
        this.timePoint = timePoint;
        this.source = new TimePointSource(sourceCode);
    }

    public AbstractCardPoint(int pointType, Date otBillStartDate, SourceCode sourceCode, AbstractCardPoint pairOfOtherOne) {
        this(pointType, otBillStartDate, sourceCode);
        this.pairOfOtherOne = pairOfOtherOne;
    }

    public AbstractCardPoint(int pointType, Date timePoint, SourceCode sourceCode, Long otbillid) {
        this(pointType, timePoint, sourceCode);
        this.billId = otbillid;
    }

    public AbstractCardPoint(int pointType, Date timePoint, SourceCode sourceCode, int inCardTag) {
        this(pointType, timePoint, sourceCode);
        this.inCardTag = inCardTag;
    }

    public AbstractCardPoint(int pointType, Date timePoint, SourceCode sourceCode, AbstractCardPoint pairOfOtherOne, long otbillid) {
        this(pointType, timePoint, sourceCode, pairOfOtherOne);
        this.billId = otbillid;
    }

    public int getPointType() {
        return this.pointType;
    }

    public void setPointType(int pointType) {
        this.pointType = pointType;
    }

    public Date getTimePoint() {
        return this.timePoint;
    }

    public void setTimePoint(Date timePoint) {
        this.timePoint = timePoint;
    }

    public TimePointSource getSource() {
        return this.source;
    }

    public void setSource(TimePointSource source) {
        this.source = source;
    }

    public AbstractCardPoint getPairOfOtherOne() {
        return this.pairOfOtherOne;
    }

    public void setPairOfOtherOne(AbstractCardPoint pairOfOtherOne) {
        this.pairOfOtherOne = pairOfOtherOne;
    }

    public long getBillId() {
        return this.billId;
    }

    public void setBillId(long billId) {
        this.billId = billId;
    }

    public long getBillEntryId() {
        return this.billEntryId;
    }

    public void setBillEntryId(long billEntryId) {
        this.billEntryId = billEntryId;
    }

    public int getInCardTag() {
        return this.inCardTag;
    }

    public void setInCardTag(int inCardTag) {
        this.inCardTag = inCardTag;
    }

    public long getBillType() {
        return this.billType;
    }

    public void setBillType(long billType) {
        this.billType = billType;
    }

    public Long getBillTime() {
        return this.billTime;
    }

    public void setBillTime(Long billTime) {
        this.billTime = billTime;
    }

    public BillNonPlanEnum getBillNonPlan() {
        return this.billNonPlan;
    }

    public void setBillNonPlan(BillNonPlanEnum billNonPlan) {
        this.billNonPlan = billNonPlan;
    }

    public void mergeSourceCode(AbstractCardPoint cardPoint) {
        cardPoint.setSource(this.source.merge(cardPoint.getSource()));
    }

    public void mergeBillId(AbstractCardPoint endPoint) {
        if (this.billId == 0L && endPoint.billId != 0L) {
            this.billId = endPoint.billId;
        }
    }

    public void merge(AbstractCardPoint endPoint) {
        this.mergeSourceCode(endPoint);
        this.mergeBillId(endPoint);
    }
}

