/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.pairtime;

import java.util.HashMap;
import java.util.Map;
import kd.wtc.wtbs.common.MultiLangEnumBridge;

public enum SourceCode {
    NONE("50", new MultiLangEnumBridge("\u4e0d\u5b58\u5728", "SourceCode_0", "wtc-wtes-common"), 0),
    EFFECT_CARD("10", new MultiLangEnumBridge("\u5361\u70b9", "SourceCode_1", "wtc-wtes-common"), 1),
    SHIFT_CARD("20", new MultiLangEnumBridge("\u73ed\u6b21", "SourceCode_2", "wtc-wtes-common"), 2),
    BILL("30", new MultiLangEnumBridge("\u5355\u636e", "SourceCode_3", "wtc-wtes-common"), 4),
    TIME_AFFILIATION("250", new MultiLangEnumBridge("\u65e5\u671f\u5f52\u5c5e", "SourceCode_4", "wtc-wtes-common"), 32),
    CARD_SUPPOSED_IN("90", new MultiLangEnumBridge("\u4e0a\u73ed\u5e94\u6253\u5361", "SourceCode_5", "wtc-wtes-common"), 8),
    CARD_SUPPOSED_OUT("100", new MultiLangEnumBridge("\u4e0b\u73ed\u5e94\u6253\u5361", "SourceCode_6", "wtc-wtes-common"), 16),
    SHIFT_AND_IN("110", new MultiLangEnumBridge("\u4e0a\u73ed\u5e94\u6253\u5361", "SourceCode_5", "wtc-wtes-common"), 10),
    SHIFT_AND_OUT("120", new MultiLangEnumBridge("\u4e0b\u73ed\u5e94\u6253\u5361", "SourceCode_6", "wtc-wtes-common"), 18),
    CARD_AND_SHIFT("40", new MultiLangEnumBridge("\u5361\u70b9,\u73ed\u6b21", "SourceCode_7", "wtc-wtes-common"), 3),
    CARD_AND_BILL("60", new MultiLangEnumBridge("\u5361\u70b9,\u5355\u636e", "SourceCode_8", "wtc-wtes-common"), 5),
    CARD_AND_IN("130", new MultiLangEnumBridge("\u5361\u70b9,\u4e0a\u73ed\u5e94\u6253\u5361", "SourceCode_9", "wtc-wtes-common"), 9),
    CARD_AND_OUT("140", new MultiLangEnumBridge("\u5361\u70b9,\u4e0b\u73ed\u5e94\u6253\u5361", "SourceCode_10", "wtc-wtes-common"), 17),
    BILL_AND_SHIFT("70", new MultiLangEnumBridge("\u5355\u636e,\u73ed\u6b21", "SourceCode_11", "wtc-wtes-common"), 6),
    BILL_AND_IN("150", new MultiLangEnumBridge("\u5355\u636e,\u4e0a\u73ed\u5e94\u6253\u5361", "SourceCode_12", "wtc-wtes-common"), 12),
    BILL_AND_OUT("160", new MultiLangEnumBridge("\u5355\u636e,\u4e0b\u73ed\u5e94\u6253\u5361", "SourceCode_13", "wtc-wtes-common"), 20),
    CARD_AND_SHIFT_AND_BILL("80", new MultiLangEnumBridge("\u5361\u70b9,\u73ed\u6b21,\u5355\u636e", "SourceCode_14", "wtc-wtes-common"), 7),
    CARD_AND_SHIFT_AND_IN("170", new MultiLangEnumBridge("\u5361\u70b9,\u4e0a\u73ed\u5e94\u6253\u5361", "SourceCode_9", "wtc-wtes-common"), 11),
    CARD_AND_SHIFT_AND_OUT("180", new MultiLangEnumBridge("\u5361\u70b9,\u4e0b\u73ed\u5e94\u6253\u5361", "SourceCode_10", "wtc-wtes-common"), 19),
    CARD_AND_IN_AND_BILL("190", new MultiLangEnumBridge("\u5361\u70b9,\u4e0a\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_15", "wtc-wtes-common"), 13),
    CARD_AND_OUT_AND_BILL("200", new MultiLangEnumBridge("\u5361\u70b9,\u4e0b\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_16", "wtc-wtes-common"), 21),
    SHIFT_AND_IN_AND_BILL("210", new MultiLangEnumBridge("\u4e0a\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_17", "wtc-wtes-common"), 14),
    SHIFT_AND_OUT_AND_BILL("220", new MultiLangEnumBridge("\u4e0b\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_18", "wtc-wtes-common"), 22),
    CARD_AND_SHIFT_AND_IN_AND_BILL("230", new MultiLangEnumBridge("\u5361\u70b9,\u4e0a\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_15", "wtc-wtes-common"), 15),
    CARD_AND_SHIFT_AND_OUT_AND_BILL("240", new MultiLangEnumBridge("\u5361\u70b9,\u4e0b\u73ed\u5e94\u6253\u5361,\u5355\u636e", "SourceCode_16", "wtc-wtes-common"), 23);

    private final int status;
    private final String number;
    private MultiLangEnumBridge name;
    private static final Map<Integer, SourceCode> STATUS_MAP;

    private SourceCode(String number, MultiLangEnumBridge name, int status) {
        this.number = number;
        this.name = name;
        this.status = status;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public Integer getStatus() {
        return this.status;
    }

    public SourceCode merge(SourceCode sourceCode) {
        Integer temp = this.status | sourceCode.getStatus();
        return STATUS_MAP.get(temp);
    }

    public boolean hasStatus(SourceCode sourceCode) {
        int flag = this.getStatus() & sourceCode.getStatus();
        return flag == sourceCode.getStatus();
    }

    public boolean isCardSupposedIn() {
        return this.hasStatus(CARD_SUPPOSED_IN);
    }

    public boolean isCardSupposedOut() {
        return this.hasStatus(CARD_SUPPOSED_OUT);
    }

    static {
        STATUS_MAP = new HashMap<Integer, SourceCode>();
        for (int i = 0; i < SourceCode.values().length; ++i) {
            SourceCode value = SourceCode.values()[i];
            STATUS_MAP.put(value.status, value);
        }
    }
}

