/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import kd.wtc.wtes.common.lang.NotNull;
import kd.wtc.wtes.common.util.ConcurrentHashSet;
import kd.wtc.wtes.common.util.ILabel;
import kd.wtc.wtes.common.util.UnRemovableIterator;

public class LabelSet<T extends ILabel>
extends ConcurrentHashSet<T> {
    private static final long serialVersionUID = 6241381642560574748L;

    public LabelSet() {
    }

    public LabelSet(int size) {
        super(size);
    }

    public LabelSet(Collection<? extends T> labels) {
        super(labels);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new UnRemovableIterator(super.iterator());
    }

    public static <T extends ILabel> LabelSet<T> empty() {
        return new LabelSet<T>();
    }

    public static <T extends ILabel> LabelSet<T> singleton(T label) {
        LabelSet<T> labelSet = new LabelSet<T>();
        labelSet.add(label);
        return labelSet;
    }

    public String getValue(String key) {
        for (ILabel next : this) {
            if (!next.keyEqual(key)) continue;
            return next.getValue();
        }
        return "";
    }

    @Override
    public boolean add(T label) {
        Objects.requireNonNull(label, "label could not be null");
        return super.add(label);
    }

    public boolean containsKey(String key) {
        for (ILabel type : this) {
            if (!type.keyEqual(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnyKey(Collection<String> keys) {
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllKey(Collection<String> keys) {
        for (String key : keys) {
            if (this.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAny(Collection<? extends ILabel> labels) {
        for (ILabel iLabel : labels) {
            if (!this.contains(iLabel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object obj) {
        return super.remove(obj);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        throw new UnsupportedOperationException();
    }
}

