/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.temptable.pk.PKTempTableHint;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonHisResult;
import kd.wtc.wtbs.common.helper.WTCAppContextHelper;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.service.IAttPersonInfoService;
import kd.wtc.wtes.business.service.impl.AttPersonInfoServiceImpl;
import kd.wtc.wtes.business.util.WtesHRBaseTimeWatchUtil;
import kd.wtc.wtes.common.lang.WtesBizException;

public class SummaryDataProvider {
    private static final Log LOGGER = LogFactory.getLog(SummaryDataProvider.class);
    private static final String ATTITEM_TYPE_DETAIL = "1";
    private static final String ATTITEM_TYPE_DETAIL_SUM = "2";
    private static final String ATTITEM_TYPE_SUM = "3";
    private static final String[] SELECTS = new String[]{"attmain.id", "attmain.personid", "attmain.attperattperiodid", "attmain.attperattperiodpk", "attmain.perattperiodid", "attmain.orgid", "attitemtype", "attitemid", "valuelong", "attmain.perperiodbegindate", "attmain.perperiodenddate", "attitemvid", "owndate", "attmain.jobvid", "attmain.companyvid", "attmain.departmentvid", "attmain.positionvid", "attmain.managescopevid", "attmain.affiliateadminorgvid", "attmain.reckoner", "attmain.attfileid", "attmain.attfilevid"};
    private static final String MAIN_SEL_PROPS = Arrays.stream(SELECTS).filter(field -> field.startsWith("attmain.")).map(field -> field.replaceFirst("attmain.", "")).collect(Collectors.joining(","));
    private static final String DETAIL_SEL_PROPS = "attmain," + Arrays.stream(SELECTS).filter(field -> !field.startsWith("attmain.")).collect(Collectors.joining(","));
    private final HRBaseServiceHelper attDetailRecordService = WtesHRBaseTimeWatchUtil.create(SummaryDataProvider.class.getName() + "." + "wtdtd_attrecorddetail", "wtdtd_attrecorddetail");
    private final HRBaseServiceHelper attRecordService = WtesHRBaseTimeWatchUtil.create(SummaryDataProvider.class.getName() + "." + "wtdtd_attrecordbase", "wtdtd_attrecordbase");
    private List<DynamicObject> sumAttRecords;
    private AttendPersonData attendPersonData;
    private Set<String> personAttPeriods;
    private Set<Long> fileBoids;
    private Set<Long> personIds;
    private Date attRecordStartDate;
    private Date attRecordEndDate;
    private LocalDate personStartDate;
    private LocalDate personEndDate;

    private Tuple<Date, Date> getStartAndEndDate(Set<String> periodSets) {
        LOGGER.debug("getStartAndEndDate periodSets.size={}", (Object)periodSets.size());
        HashSet<String> dateSet = new HashSet<String>(2);
        for (String attPeriodId : periodSets) {
            String[] periodArr = attPeriodId.split("_");
            if (periodArr.length < 4) continue;
            String startDateStr = periodArr[2];
            String endDateStr = periodArr[3];
            dateSet.add(startDateStr);
            dateSet.add(endDateStr);
        }
        if (dateSet.size() == 0) {
            throw new WtesBizException("personattperiod is empty or data format bad.");
        }
        ArrayList dateStrList = new ArrayList(dateSet);
        List dates = dateStrList.stream().map(s -> {
            Date date = WTCDateUtils.str2Date((String)s, (String)"yyyy-MM-dd");
            if (date == null) {
                throw new WtesBizException("personattperiod bad date format: " + s);
            }
            return date;
        }).sorted(Comparator.comparingLong(Date::getTime)).collect(Collectors.toList());
        return new Tuple(dates.get(0), dates.get(dates.size() - 1));
    }

    public void prepareQueryParams(AttPeriodTable attPeriodTable, List<AttPeriodSummaryRequest> attPeriodList) {
        LOGGER.debug("prepareQueryParams start, attPeriodList.size: {}", (Object)attPeriodList.size());
        this.fileBoids = new HashSet<Long>(attPeriodList.size());
        this.personIds = new HashSet<Long>(attPeriodList.size());
        this.personAttPeriods = new HashSet<String>(attPeriodList.size());
        for (AttPeriodSummaryRequest attPeriodSummaryRequest : attPeriodList) {
            List<String> attPeriodIds = attPeriodSummaryRequest.getAttPeriodIds();
            if (WTCCollections.isNotEmpty(attPeriodIds)) {
                this.personAttPeriods.addAll(attPeriodIds);
            }
            this.fileBoids.addAll(attPeriodSummaryRequest.getAttFileBoId());
            this.personIds.add(attPeriodSummaryRequest.getAttPersonId());
        }
        Tuple<Date, Date> startAndEndDate = this.getStartAndEndDate(this.personAttPeriods);
        this.attRecordStartDate = (Date)startAndEndDate.getKey();
        this.attRecordEndDate = (Date)startAndEndDate.getValue();
        this.personStartDate = attPeriodTable.getMinAttPeriodBeginDate();
        this.personEndDate = attPeriodTable.getMaxAttPeriodEndDate();
        LOGGER.debug("prepareQueryParams attRecordStartDate: {}, attRecordEndDate: {}, personStartDate: {}, personEndDate:{}", new Object[]{this.attRecordStartDate, this.attRecordEndDate, this.personStartDate, this.personEndDate});
    }

    private List<DynamicObject> queryAttRecordbak() {
        LOGGER.debug("queryAttRecord start, fileBoids.size: {}", (Object)this.fileBoids.size());
        if (this.fileBoids.size() == 0) {
            return new ArrayList<DynamicObject>(16);
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("attmain.attfileid", "in", this.fileBoids), new QFilter("attmain.owndate", ">=", (Object)this.attRecordStartDate), new QFilter("attmain.owndate", "<=", (Object)this.attRecordEndDate), new QFilter("attitemid.itemtype", "in", Arrays.asList(ATTITEM_TYPE_DETAIL_SUM, ATTITEM_TYPE_SUM)), new QFilter("owndate", ">=", (Object)this.attRecordStartDate), new QFilter("owndate", "<=", (Object)this.attRecordEndDate)};
        DataSet dataSet = this.attDetailRecordService.queryDataSet(this.getClass().getName() + ".wtcPeriodDataRefresh", String.join((CharSequence)",", SELECTS), qFilters);
        ArrayList dynamicObjectList = Lists.newArrayListWithExpectedSize((int)16);
        Field[] fields = dataSet.getRowMeta().getFields();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            DynamicObject deatilAttTotalDy = this.rowToDeatilAttTotal(row, fields);
            String personAttPeriod = deatilAttTotalDy.getString("attmain.attperattperiodid");
            if (personAttPeriod == null || !this.personAttPeriods.contains(personAttPeriod)) continue;
            dynamicObjectList.add(deatilAttTotalDy);
        }
        LOGGER.debug("queryAttRecord end, dynamicObjectList.size: {}", (Object)dynamicObjectList.size());
        return dynamicObjectList;
    }

    public List<DynamicObject> queryAttRecord() {
        LOGGER.debug("queryAttRecord.start.fileBoids.size:{}", (Object)this.fileBoids.size());
        QFilter[] mainQFilters = new QFilter[]{new QFilter("attfileid", "in", this.fileBoids), new QFilter("owndate", ">=", (Object)this.attRecordStartDate), new QFilter("owndate", "<=", (Object)this.attRecordEndDate)};
        DynamicObject[] attMainDys = this.attRecordService.queryOriginalArray(MAIN_SEL_PROPS, mainQFilters, "id");
        List mainIdColl = Arrays.stream(attMainDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter[] detailQFilters = new QFilter[]{new QFilter("attmain", "in", mainIdColl), new QFilter("attitemid.itemtype", "in", Arrays.asList(ATTITEM_TYPE_DETAIL_SUM, ATTITEM_TYPE_SUM)), new QFilter("owndate", ">=", (Object)this.attRecordStartDate), new QFilter("owndate", "<=", (Object)this.attRecordEndDate)};
        DynamicObject[] attDetailDys = this.attDetailRecordService.queryOriginalArray(DETAIL_SEL_PROPS, detailQFilters, "attmain");
        ArrayList attRecordDetailDys = Lists.newArrayListWithExpectedSize((int)attDetailDys.length);
        if (attDetailDys.length == 0) {
            return attRecordDetailDys;
        }
        DataEntityPropertyCollection properties = attDetailDys[0].getDataEntityType().getProperties();
        int index = 0;
        for (DynamicObject attDetailDy : attDetailDys) {
            while (index < attMainDys.length && attMainDys[index].getLong("id") != attDetailDy.getLong("attmain")) {
                ++index;
            }
            if (index >= attMainDys.length) break;
            String personAttPeriod = attMainDys[index].getString("attperattperiodid");
            if (!this.personAttPeriods.contains(personAttPeriod)) continue;
            DynamicObject attRecordDetailDy = this.attDetailRecordService.generateEmptyDynamicObject();
            for (IDataEntityProperty property : properties) {
                attRecordDetailDy.set(property.getName(), property.getValue((Object)attDetailDy));
            }
            attRecordDetailDy.set("attmain", (Object)attMainDys[index]);
            attRecordDetailDys.add(attRecordDetailDy);
        }
        LOGGER.debug("queryAttRecord.result.size: {}", (Object)attRecordDetailDys.size());
        return attRecordDetailDys;
    }

    private DynamicObject rowToDeatilAttTotal(Row row, Field[] fields) {
        DynamicObject deatilAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecorddetail");
        if (fields == null || fields.length == 0) {
            return deatilAttTotalDy;
        }
        DynamicObject mainAttTotalDy = BusinessDataServiceHelper.newDynamicObject((String)"wtdtd_attrecordbase");
        for (Field field : fields) {
            String name = field.getName();
            String[] nameSplit = name.split("\\.");
            if (nameSplit != null && nameSplit.length > 1) {
                mainAttTotalDy.set(nameSplit[1], row.get(name));
                continue;
            }
            deatilAttTotalDy.set(name, row.get(name));
        }
        deatilAttTotalDy.set("attmain", (Object)mainAttTotalDy);
        return deatilAttTotalDy;
    }

    private void prepareSumAttRecord() {
        try {
            PKTempTableHint.threshold((int)200);
            this.sumAttRecords = Collections.unmodifiableList(this.queryAttRecord());
        }
        finally {
            PKTempTableHint tmpHint = PKTempTableHint.get();
            if (tmpHint != null) {
                tmpHint.close();
            }
        }
        LOGGER.debug("prepareSumAttRecord , sumAttRecords size:{} ", (Object)this.sumAttRecords.size());
    }

    public List<DynamicObject> getSumAttRecords() {
        if (this.sumAttRecords == null) {
            this.prepareSumAttRecord();
        }
        return this.sumAttRecords;
    }

    public AttendPersonData getPersonData() {
        if (this.attendPersonData == null) {
            LOGGER.debug("getPersonData start query, personStartDate: {}, personEndDate: {}, personIds.size: {}", new Object[]{this.personStartDate, this.personEndDate, this.personIds.size()});
            IAttPersonInfoService attPersonInfoService = (IAttPersonInfoService)WTCAppContextHelper.getBean(AttPersonInfoServiceImpl.class);
            AttendPersonHisResult attendPersonHisResult = attPersonInfoService.getAttendPersonModelResult(Lists.newArrayList(this.personIds), this.personStartDate, this.personEndDate);
            this.attendPersonData = AttendPersonData.of(attendPersonHisResult);
            LOGGER.debug("getPersonData end query");
        }
        return this.attendPersonData;
    }
}

