/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.attperiod.chain;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.attperiod.AttPeriodSummaryRequest;
import kd.wtc.wtes.business.attperiod.SchemeWrapper;
import kd.wtc.wtes.business.attperiod.SummaryDataProvider;
import kd.wtc.wtes.business.core.TieMessage;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.engine.TieEngineCallbackEvent;
import kd.wtc.wtes.business.core.exporter.ITieExporter;
import kd.wtc.wtes.business.core.scheme.TiePhaseConfig;
import kd.wtc.wtes.business.core.scheme.TieScheme;
import kd.wtc.wtes.business.core.scheme.TieStepConfig;
import kd.wtc.wtes.business.model.AccountPlanData;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.model.AttFileModel;
import kd.wtc.wtes.business.model.AttItemSpec;
import kd.wtc.wtes.business.model.AttItemSpecData;
import kd.wtc.wtes.business.model.AttPeriodTable;
import kd.wtc.wtes.business.model.attendperson.AttendPersonData;
import kd.wtc.wtes.business.model.attendperson.AttendPersonModel;
import kd.wtc.wtes.business.model.attrecordadjust.AttRecordTrimData;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtp.business.formula.adapt.FormulaService;

public class TieAttPeriodContext {
    private static final Log LOGGER = LogFactory.getLog(TieAttPeriodContext.class);
    private final TieEngineCallbackEvent callbackEvent;
    private Map<Long, List<PerAttPeriod>> perAttPeriodMap;
    private Map<Long, PerAttPeriod> perAttPeriodPrimaryIdMap;
    private Map<String, PerAttPeriod> perAttPeriodIdMap;
    private List<AttPeriodSummaryRequest> summaryRequests;
    private List<AttSubject> realAttSubject;
    private AttPeriodTable attPeriodTable;
    private Map<Long, Date> deathNameList;
    private Map<SchemeWrapper, List<AttPeriodSummaryRequest>> periodSchemeMap;

    public TieAttPeriodContext(TieEngineCallbackEvent callbackEvent) {
        this.callbackEvent = callbackEvent;
        this.initPeriods();
        this.initDeathNameList();
        this.initPeriodScheme();
    }

    private void initPeriods() {
        this.attPeriodTable = (AttPeriodTable)this.callbackEvent.getEngine().getInitParams().get("ATT_PERIOD");
        List<AttSubject> attSubjects = this.callbackEvent.getEngine().getAttSubjects();
        Map attSubjectMap = attSubjects.stream().collect(Collectors.toMap(AttSubject::getAttPersonId, Function.identity(), (key1, key2) -> key2));
        List involvedAttPersonIds = attSubjects.stream().map(AttSubject::getAttPersonId).distinct().collect(Collectors.toList());
        AccountPlanData accountPlanData = (AccountPlanData)this.callbackEvent.getEngine().getInitParams().get("ACCOUNT_PLAN");
        this.summaryRequests = Lists.newArrayListWithExpectedSize((int)involvedAttPersonIds.size());
        this.realAttSubject = Lists.newArrayListWithExpectedSize((int)involvedAttPersonIds.size());
        this.perAttPeriodMap = Maps.newHashMapWithExpectedSize((int)involvedAttPersonIds.size());
        this.perAttPeriodPrimaryIdMap = this.attPeriodTable.getPerAttPeriodMap().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(PerAttPeriod::getPrimaryId, Function.identity(), (key1, key2) -> key2));
        this.perAttPeriodIdMap = this.attPeriodTable.getPerAttPeriodMap().values().stream().flatMap(Collection::stream).collect(Collectors.toMap(PerAttPeriod::getId, Function.identity(), (key1, key2) -> key2));
        for (Long attPersonId : involvedAttPersonIds) {
            AttPeriodSummaryRequest summaryRequest = new AttPeriodSummaryRequest();
            AttSubject attSubject = (AttSubject)attSubjectMap.get(attPersonId);
            List<PerAttPeriod> perAttPeriodList = this.attPeriodTable.getPerAttPeriodList(attPersonId);
            if (WTCCollections.isEmpty(perAttPeriodList)) {
                LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_isnull_attPersonId_{}", (Object)attPersonId);
                continue;
            }
            Date startDate = WTCDateUtils.toDate((LocalDate)attSubject.getStartDate());
            Date endDate = WTCDateUtils.toDate((LocalDate)attSubject.getEndDate());
            List<PerAttPeriod> filerList = perAttPeriodList.stream().filter(period -> period.getPerAttBeginDate().getTime() <= endDate.getTime() && period.getPerAttEndDate().getTime() >= startDate.getTime()).collect(Collectors.toList());
            if (WTCCollections.isEmpty(filerList)) {
                LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_filerList_isnull_attPersonId_{}_startDate{}_endDate_{}", new Object[]{attPersonId, startDate, endDate});
                continue;
            }
            this.perAttPeriodMap.put(attPersonId, filerList);
            List<String> attPeriodIds = filerList.stream().map(PerAttPeriod::getId).collect(Collectors.toList());
            LOGGER.debug("AttPeriodSummaryCallback_PerAttPeriod_startDate_{}_endDate_{}_attPeriodIds_{}", new Object[]{startDate, endDate, attPeriodIds});
            Set<Long> fileBoIdSet = filerList.stream().map(PerAttPeriod::getFileBoId).collect(Collectors.toSet());
            Map<String, PerAttPeriod> perAttPeriodMap = perAttPeriodList.stream().collect(Collectors.toMap(PerAttPeriod::getId, Function.identity(), (key1, key2) -> key2));
            summaryRequest.setAttFileBoId(fileBoIdSet);
            summaryRequest.setAttPersonId(attPersonId);
            summaryRequest.setAttPeriodIds(attPeriodIds);
            summaryRequest.setPerAttPeriodMap(perAttPeriodMap);
            summaryRequest.setAttPeriodIdToSchemeMap(this.generalAttPeriodIdToSchemeMap(filerList, accountPlanData));
            this.summaryRequests.add(summaryRequest);
            this.realAttSubject.add(attSubject);
        }
    }

    protected Map<String, SchemeWrapper> generalAttPeriodIdToSchemeMap(List<PerAttPeriod> perAttPeriodList, AccountPlanData planData) {
        HashMap<String, SchemeWrapper> result = new HashMap<String, SchemeWrapper>(perAttPeriodList.size());
        for (PerAttPeriod perAttPeriod : perAttPeriodList) {
            LocalDate localDate = WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
            TieScheme versionByDate = planData.getTieSchemeByTotalAndDate(localDate);
            if (versionByDate == null) continue;
            result.put(perAttPeriod.getId(), new SchemeWrapper(versionByDate, localDate));
        }
        return result;
    }

    private void initDeathNameList() {
        ITieExporter exporter = this.callbackEvent.getEngine().getExporter();
        List errorBoList = exporter.getResult().stream().filter(entity -> entity.getTaskDetailState() == WTCTaskDetailStatus.FAIL).collect(Collectors.toList());
        this.deathNameList = new HashMap<Long, Date>(errorBoList.size());
        for (WTCCalTaskDetailEntity errorBo : errorBoList) {
            this.deathNameList.put(errorBo.getAttPersonId(), null);
        }
        LOGGER.debug("AttPeriodSummaryCallback find DeathNameList size={}, detail={}", (Object)this.deathNameList.size(), this.deathNameList);
    }

    private void initPeriodScheme() {
        HashMap schemeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap schemeToAttPeriodIdMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AttPeriodSummaryRequest summaryRequest : this.getSummaryRequests()) {
            SchemeWrapper schemeWrapper;
            Map<String, SchemeWrapper> attPeriodIdToSchemeMap = summaryRequest.getAttPeriodIdToSchemeMap();
            for (Map.Entry<String, SchemeWrapper> entry : attPeriodIdToSchemeMap.entrySet()) {
                String attPeriodId = entry.getKey();
                schemeWrapper = entry.getValue();
                Set AttPeriodIdSet = schemeToAttPeriodIdMap.computeIfAbsent(schemeWrapper, ob -> new HashSet());
                AttPeriodIdSet.add(attPeriodId);
            }
            for (Map.Entry<String, SchemeWrapper> entry : schemeToAttPeriodIdMap.entrySet()) {
                AttPeriodSummaryRequest attPeriodSummaryRequest = new AttPeriodSummaryRequest();
                attPeriodSummaryRequest.setAttPersonId(summaryRequest.getAttPersonId());
                attPeriodSummaryRequest.setAttFileBoId(summaryRequest.getAttFileBoId());
                attPeriodSummaryRequest.setPerAttPeriodMap(summaryRequest.getPerAttPeriodMap());
                attPeriodSummaryRequest.setAttPeriodIds(new ArrayList<String>((Collection)((Object)entry.getValue())));
                schemeWrapper = (SchemeWrapper)((Object)entry.getKey());
                List attPeriodSummaryRequests = schemeMap.computeIfAbsent(schemeWrapper, ob -> new ArrayList());
                attPeriodSummaryRequests.add(attPeriodSummaryRequest);
            }
        }
        SummaryDataProvider summaryDataProvider = this.getSummaryDataProvider();
        if (summaryDataProvider != null) {
            ArrayList<AttPeriodSummaryRequest> providerList = new ArrayList<AttPeriodSummaryRequest>(schemeMap.size());
            for (List value : schemeMap.values()) {
                providerList.addAll(value);
            }
            summaryDataProvider.prepareQueryParams(this.getAttPeriodTable(), providerList);
        }
        this.periodSchemeMap = this.mergeScheme(schemeMap);
    }

    private Map<SchemeWrapper, List<AttPeriodSummaryRequest>> mergeScheme(Map<SchemeWrapper, List<AttPeriodSummaryRequest>> schemeMap) {
        HashMap mergedSchemeMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<SchemeWrapper, List<AttPeriodSummaryRequest>> tieSchemeListEntry : schemeMap.entrySet()) {
            SchemeWrapper schemeWrapper = tieSchemeListEntry.getKey();
            List<AttPeriodSummaryRequest> attPeriodSummaryRequestList = tieSchemeListEntry.getValue();
            SchemeWrapper wrapper = (SchemeWrapper)map.get((Object)schemeWrapper.getTieScheme());
            if (wrapper == null) {
                mergedSchemeMap.put(schemeWrapper, attPeriodSummaryRequestList);
                map.put(schemeWrapper.getTieScheme(), schemeWrapper);
                continue;
            }
            if (!this.compareSchemeWrapper(schemeWrapper, wrapper)) continue;
            List attPeriodSummaryRequestList1 = (List)mergedSchemeMap.get(wrapper);
            attPeriodSummaryRequestList1.addAll((Collection)tieSchemeListEntry.getValue());
        }
        return mergedSchemeMap;
    }

    private boolean compareSchemeWrapper(SchemeWrapper schemeWrapper, SchemeWrapper wrapper) {
        TieScheme tieScheme = wrapper.getTieScheme();
        LocalDate localDate1 = wrapper.getLocalDate();
        LocalDate localDate2 = schemeWrapper.getLocalDate();
        List<TiePhaseConfig> phaseProperties = tieScheme.getPhaseProperties();
        List phasePeriodSum = phaseProperties.stream().filter(ob -> ob.getNumber().equals("PHASE_PRRIOD_SUM")).collect(Collectors.toList());
        for (TiePhaseConfig tiePhaseConfig : phasePeriodSum) {
            List<TieStepConfig> stepConfigs2;
            List<TieStepConfig> stepConfigs1 = tiePhaseConfig.getStepConfigsByDate(localDate1);
            if (stepConfigs1.equals(stepConfigs2 = tiePhaseConfig.getStepConfigsByDate(localDate2))) continue;
            return false;
        }
        return true;
    }

    public Map<Long, List<PerAttPeriod>> getPerAttPeriodMap() {
        return this.perAttPeriodMap;
    }

    public List<AttPeriodSummaryRequest> getSummaryRequests() {
        return this.summaryRequests;
    }

    public List<AttSubject> getRealAttSubject() {
        return this.realAttSubject;
    }

    public String getVersion() {
        return this.callbackEvent.getRequest().getVersion();
    }

    public AttPeriodTable getAttPeriodTable() {
        return this.attPeriodTable;
    }

    public Map<Long, Date> getDeathNameList() {
        return this.deathNameList;
    }

    public SummaryDataProvider getSummaryDataProvider() {
        return this.callbackEvent.getSummaryDataProvider();
    }

    public Map<SchemeWrapper, List<AttPeriodSummaryRequest>> getPeriodSchemeMap() {
        return this.periodSchemeMap;
    }

    public AttItemSpecData getAttItemSpecData() {
        return (AttItemSpecData)this.callbackEvent.getInitParams().get("ATT_ITEM_SPEC");
    }

    public AttRecordTrimData getAttRecordTrimData() {
        return (AttRecordTrimData)this.callbackEvent.getInitParams().get("ATT_RECORD_TRIM");
    }

    public AttendPersonData getAttendPersonData() {
        return (AttendPersonData)((Object)this.callbackEvent.getInitParams().get("ATT_PERINFO"));
    }

    public TieRequest getRequest() {
        return this.callbackEvent.getRequest();
    }

    public AttFileCabinet getAttFileCabinet() {
        return (AttFileCabinet)this.callbackEvent.getInitParams().get("ATT_FILE");
    }

    public RuleEngineMetaData getRuleEngineMetaData() {
        return (RuleEngineMetaData)this.callbackEvent.getInitParams().get("RULE_ENGINE");
    }

    public List<TieMessage> getTieMessages() {
        return this.callbackEvent.getTieMessages();
    }

    public PerAttPeriod getPerAttPeriodByPrimaryId(Long primaryId) {
        return this.perAttPeriodPrimaryIdMap.get(primaryId);
    }

    public AttendPersonModel getAttendPersonByPerAttPeriodId(Long primaryId) {
        PerAttPeriod perAttPeriod = this.getPerAttPeriodByPrimaryId(primaryId);
        if (null == perAttPeriod) {
            LOGGER.warn("TieAttPeriodContext_getAttendPersonByPerAttPeriodId_not_find_PerAttPeriod_{}", (Object)primaryId);
            return null;
        }
        AttFileModel attFileModel = this.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
        if (null == attFileModel) {
            LOGGER.warn("TieAttPeriodContext_getAttendPersonByPerAttPeriodId_not_find_attFile_={},perAttPeriod={}", (Object)primaryId, (Object)perAttPeriod);
            return null;
        }
        return this.getAttendPersonData().getByBidAndDate(attFileModel, this.getPeriodData(perAttPeriod, attFileModel));
    }

    public AttFileModel getAttFileByPerAttPeriodId(Long primaryId) {
        PerAttPeriod perAttPeriod = this.getPerAttPeriodByPrimaryId(primaryId);
        if (null == perAttPeriod) {
            LOGGER.warn("TieAttPeriodContext_getAttFileByPerAttPeriodId_not_find_PerAttPeriod_{}", (Object)primaryId);
            return null;
        }
        return this.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
    }

    public List<PerAttPeriod> getPerAttPeriodList() {
        return this.perAttPeriodMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public LocalDate getPeriodData(PerAttPeriod perAttPeriod, AttFileModel attFileModel) {
        return WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinDate((Date)perAttPeriod.getPerAttEndDate(), (Date)WTCDateUtils.toDate((LocalDate)attFileModel.getTimeSeqInfo().getBlsed())));
    }

    public AttItemSpec getAttItemSpec(Long bid, Long primaryId) {
        PerAttPeriod perAttPeriod = this.getPerAttPeriodByPrimaryId(primaryId);
        if (null == perAttPeriod) {
            LOGGER.warn("TieAttPeriodContext_getAttItemSpec_not_find_PerAttPeriod_{}", (Object)primaryId);
            return null;
        }
        AttFileModel attFileModel = this.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
        if (null == attFileModel) {
            LOGGER.warn("TieAttPeriodContext_getAttItemSpec_not_find_attFile_={},perAttPeriod={}", (Object)primaryId, (Object)perAttPeriod);
            return null;
        }
        return this.getAttItemSpecData().getByBidAndDate(bid, this.getPeriodData(perAttPeriod, attFileModel));
    }

    public Map<String, Object> getInitParams() {
        return this.callbackEvent.getInitParams();
    }

    public FormulaService getFormulaService() {
        return this.callbackEvent.getFormulaService();
    }

    public Map<String, PerAttPeriod> getPerAttPeriodIdMap() {
        return this.perAttPeriodIdMap;
    }

    public AttFileModel getAttFileModelById(long personId, long attFileId) {
        AttFileCabinet attFileCabinet = this.getAttFileCabinet();
        return attFileCabinet.getByAttPersonIdAndDate(personId, attFileId);
    }

    public AttendPersonModel getAttendPersonModel(AttFileModel attFileModel, LocalDate inDate) {
        return this.getAttendPersonData().getByBidAndDate(attFileModel, inDate);
    }

    public LocalDate getPeriodData(PerAttPeriod perAttPeriod) {
        AttFileModel attFileModel = this.getAttFileModelById(perAttPeriod.getPersonId(), perAttPeriod.getFileId());
        if (null == attFileModel) {
            return WTCDateUtils.toLocalDate((Date)perAttPeriod.getPerAttEndDate());
        }
        return WTCDateUtils.toLocalDate((Date)WTCDateUtils.getMinDate((Date)perAttPeriod.getPerAttEndDate(), (Date)WTCDateUtils.toDate((LocalDate)attFileModel.getTimeSeqInfo().getBlsed())));
    }
}

