/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtes.business.bill.BillAccountingLineExporterStdImpl;
import kd.wtc.wtes.business.core.TieMsgLevel;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.TieState;
import kd.wtc.wtes.business.core.exporter.ITieLineExporter;
import kd.wtc.wtes.business.model.TieEngineState;
import kd.wtc.wtes.business.model.TieLineState;
import kd.wtc.wtes.business.std.AbstractTieExporter;

public class BillAccountingExporterStdImpl
extends AbstractTieExporter {
    private final StringBuffer alarmsBuffer = new StringBuffer();
    private final Map<Long, String> personErrorMsg = new ConcurrentHashMap<Long, String>(16);
    private final Map<Long, String> attFileBoErrorMsg = new ConcurrentHashMap<Long, String>(16);

    @Override
    protected void finishOneSubject(AttSubject attSubject) {
    }

    @Override
    protected void errorOneSubject(AttSubject attSubject) {
        List attFileBos = attSubject.getAttFileBos();
        for (AttSubject.AttFileBo attFileBo : attFileBos) {
            this.attFileBoErrorMsg.put(attFileBo.getAttFileBoid(), this.personErrorMsg.get(attFileBo.getAttSubject().getAttPersonId()));
        }
    }

    @Override
    protected void afterStateChanged(TieState oldState, TieState newState) {
    }

    @Override
    public void pushSubjectErrorMsg(Long attPersonId, String msg) {
        this.personErrorMsg.put(attPersonId, msg);
    }

    @Override
    public TieEngineState getEngineState() {
        return null;
    }

    @Override
    public void addCacheLine(TieLineState tieLineState, TieState newState) {
    }

    @Override
    public void setTieRequest(TieRequest request) {
    }

    @Override
    public void setAttSubjects(List<AttSubject> attSubjects) {
    }

    @Override
    public ITieLineExporter newLineExporter(AttSubject attSubject) {
        return new BillAccountingLineExporterStdImpl(this, attSubject);
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getLastTieDateMap() {
        return null;
    }

    @Override
    public Map<AttSubject.AttFileBo, LocalDate> getErrorDateMap() {
        return null;
    }

    @Override
    public void updateSubErrorResult(Set<Long> personIds, String errorMsg) {
    }

    @Override
    public void alarm(TieMsgLevel msgLevel, String msg) {
        if (TieMsgLevel.ERROR == msgLevel) {
            this.alarmsBuffer.append((Object)msgLevel).append(':').append(msg).append(';');
        }
    }

    public Map<Long, String> getAttFileBoErrorMsg() {
        return this.attFileBoErrorMsg;
    }

    public String getGlobalErrorMsg() {
        return this.alarmsBuffer.toString();
    }
}

