/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.bill.AttfileLimitScope;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtes.business.model.AttFileCabinet;
import kd.wtc.wtes.business.ruleengine.RuleEngineMetaData;
import kd.wtc.wtes.common.lang.Nullable;
import kd.wtc.wtes.common.lang.WtesBizException;

public class BillAccountingResult {
    private final Map<String, Object> initParams;
    private Map<Long, String> errorMsgMap;
    private LocalDate realStartDate;
    private LocalDate realEndDate;
    Map<Long, BillApply> billApplyResMap;

    public BillAccountingResult(Map<String, Object> initParams, Map<Long, BillApply> billApplyResMap) {
        this.initParams = initParams;
        this.billApplyResMap = new HashMap<Long, BillApply>(billApplyResMap);
    }

    public Map<String, Object> getInitParams() {
        return this.initParams;
    }

    public Map<Long, String> getErrorMsgMap() {
        return this.errorMsgMap;
    }

    public void setErrorMsgMap(Map<Long, String> errorMsgMap) {
        this.errorMsgMap = errorMsgMap;
    }

    @Nullable
    public <V> V getInitParam(String key) {
        return (V)this.getInitParams().get(key);
    }

    private <V> V getInitParamMust(String key, Class<V> paramType) {
        Object value = this.getInitParams().get(key);
        if (value == null) {
            throw new WtesBizException("Could not find [" + key + "] in init params");
        }
        if (!paramType.isInstance(value)) {
            throw new WtesBizException("Param type mismatch, expected: " + paramType.getName() + ",actual:" + value.getClass().getName() + ",the param key is: " + key);
        }
        return paramType.cast(value);
    }

    public AttFileCabinet getAttFileCabinet() {
        return this.getInitParamMust("ATT_FILE", AttFileCabinet.class);
    }

    public Map<Long, AttfileLimitScope> getLimitScopeMap() {
        return (Map)this.getInitParam("LIMIT_SCOPE");
    }

    public RuleEngineMetaData getRuleEngineData() {
        return this.getInitParamMust("RULE_ENGINE", RuleEngineMetaData.class);
    }

    public LocalDate getRealStartDate() {
        return this.realStartDate;
    }

    public LocalDate getRealEndDate() {
        return this.realEndDate;
    }

    public void setRealRange(List<AttSubject> attSubjects) {
        if (attSubjects.isEmpty()) {
            return;
        }
        this.realStartDate = attSubjects.get(0).getStartDate();
        this.realEndDate = attSubjects.get(0).getEndDate();
    }

    public Map<Long, BillApply> getBillApplyResMap() {
        return this.billApplyResMap;
    }

    public void setBillApplyResMap(Map<Long, BillApply> billApplyResMap) {
        this.billApplyResMap = billApplyResMap;
    }
}

