/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.util.List;
import java.util.Map;
import kd.bos.exception.KDBizException;
import kd.wtc.wtbs.business.subject.AttSubject;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtes.business.bill.BillAccountingExporterStdImpl;
import kd.wtc.wtes.business.bill.BillAccountingResult;
import kd.wtc.wtes.business.core.TieRequest;
import kd.wtc.wtes.business.core.engine.TieEngine;
import kd.wtc.wtes.business.drouter.BillAccountingDataPackageRouterFactory;
import kd.wtc.wtes.business.engine.TieEngineConfigs;
import kd.wtc.wtes.business.engine.TieEngineServiceSupport;
import kd.wtc.wtes.business.model.quotacal.va.QuotaCalBatchReq;
import kd.wtc.wtes.business.std.datanode.TieDataNodeStd;

public class BillAccountingService {
    public BillAccountingResult submit(TieRequest request) {
        return this.submit(request, null);
    }

    public BillAccountingResult submit(TieRequest request, QuotaCalBatchReq req) {
        TieEngine<TieDataNodeStd> tieEngine = TieEngineServiceSupport.buildTieEngine(TieEngineConfigs.BILL_ACCOUNTING_CONFIG, request);
        tieEngine.run();
        Map<String, Object> initParams = tieEngine.getInitParams();
        BillAccountingDataPackageRouterFactory dataPackageRouterFactory = (BillAccountingDataPackageRouterFactory)tieEngine.getDataPackageRouterFactory();
        BillAccountingExporterStdImpl exporter = (BillAccountingExporterStdImpl)tieEngine.getExporter();
        String globalErrorMsg = exporter.getGlobalErrorMsg();
        List<AttSubject> attSubjects = tieEngine.getAttSubjects();
        if (globalErrorMsg.length() > 0 && !attSubjects.isEmpty()) {
            throw new KDBizException(globalErrorMsg);
        }
        Map<Long, String> attFileBoErrorMsg = exporter.getAttFileBoErrorMsg();
        Map<Long, BillApply> billApplyResMap = dataPackageRouterFactory.getBillApplyResMap();
        BillAccountingResult billAccountingResult = new BillAccountingResult(initParams, billApplyResMap);
        billAccountingResult.setErrorMsgMap(attFileBoErrorMsg);
        billAccountingResult.setRealRange(attSubjects);
        dataPackageRouterFactory.clear();
        return billAccountingResult;
    }
}

