/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtes.business.bill;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.caltask.common.WTCCalTaskDetailEntity;
import kd.wtc.wtbs.business.caltask.common.WTCTaskRequestStd;
import kd.wtc.wtbs.business.helper.WTCTaskInstanceHelper;
import kd.wtc.wtbs.business.subject.AttPlainSubject;
import kd.wtc.wtbs.business.task.WTCTaskObjectFactory;
import kd.wtc.wtbs.business.task.base.BootTaskRes;
import kd.wtc.wtbs.business.task.base.WTCDistributeTaskHelper;
import kd.wtc.wtbs.business.task.base.biz.QTTieTaskStatusCallBack;
import kd.wtc.wtbs.business.task.common.WTCSource;
import kd.wtc.wtbs.business.task.common.WTCTaskDetailStatus;
import kd.wtc.wtbs.business.task.common.WTCTaskStateTransfer;
import kd.wtc.wtbs.business.task.common.WTCTaskStatus;
import kd.wtc.wtbs.business.task.dispatch.WTCTaskDispatchRequest;
import kd.wtc.wtbs.business.task.repository.std.WTCCalTaskRepository;
import kd.wtc.wtbs.business.task.sharding.std.WTCTaskCalShardingDetail;
import kd.wtc.wtbs.business.util.QTAccountModeHelper;
import kd.wtc.wtbs.business.util.accountplan.AccountPlanUtil;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.deduction.BillApply;
import kd.wtc.wtbs.common.deduction.BillApplyEntry;
import kd.wtc.wtbs.common.model.DateRange;
import kd.wtc.wtbs.common.util.SystemParamQueryUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtes.business.quota.engine.QuotaEngineServiceImpl;
import kd.wtc.wtes.business.quota.std.QuotaRequestStd;

public class BillIncCalHelper {
    private static final Log log = LogFactory.getLog(BillIncCalHelper.class);

    private static DateRange getSelectedDateRange(BillApply bill) {
        Date start = null;
        Date end = null;
        for (BillApplyEntry entry : bill.getEntryEntities()) {
            if (start == null || entry.getStartDate().before(start)) {
                start = entry.getStartDate();
            }
            if (end != null && !entry.getEndDate().after(end)) continue;
            end = entry.getEndDate();
        }
        return DateRange.range(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BootTaskRes runTaskForBill(BillApply bill) {
        BootTaskRes bootTaskRes;
        long taskId;
        WTCTaskStatus taskStatus;
        block17: {
            BootTaskRes callBack3;
            block16: {
                BootTaskRes bootTaskRes2;
                block15: {
                    BootTaskRes bootTaskRes3;
                    block14: {
                        BootTaskRes res = new BootTaskRes();
                        taskStatus = null;
                        taskId = 0L;
                        try {
                            WTCTaskRequestStd taskRequest = BillIncCalHelper.genReq(bill);
                            BillIncCalHelper.newAndSaveCalResult(taskRequest);
                            res.setRequestTaskId(taskRequest.getTaskId());
                            taskId = taskRequest.getTaskId();
                            List subTaskDispatchRequestList = WTCDistributeTaskHelper.shardingSaveAndSlimReqStd((WTCTaskRequestStd)taskRequest);
                            if (subTaskDispatchRequestList.isEmpty()) {
                                res.markSysError("can not sharding");
                                BootTaskRes bootTaskRes4 = res;
                                return bootTaskRes4;
                            }
                            WTCTaskDispatchRequest subTaskReq = (WTCTaskDispatchRequest)subTaskDispatchRequestList.get(0);
                            WTCTaskObjectFactory objectFactory = WTCTaskInstanceHelper.getObjectFactory((String)"wtte_qttie");
                            WTCCalTaskRepository repository = (WTCCalTaskRepository)objectFactory.getRepository();
                            List detailList = repository.batchLoadTaskDetailByTaskIdAndSubTaskId(taskId, subTaskReq.getShardingTask().getSubTaskId(), null);
                            List<Object> shardingDetailList = detailList.stream().map(detail -> repository.getWTCCalTaskConverter().convert2ShardingDetail(detail)).collect(Collectors.toList());
                            if (detailList.stream().noneMatch(ele -> ele.getAttFileBoId() == bill.getAttFileBoId())) {
                                res.markSysError("sharding detail store fail");
                                bootTaskRes3 = res;
                                if (taskStatus == null) return bootTaskRes3;
                                break block14;
                            }
                            QuotaRequestStd tieRequestByTask = BillIncCalHelper.getQtTieRequestByTask(taskRequest, subTaskReq, shardingDetailList);
                            QuotaEngineServiceImpl tieEngineService = new QuotaEngineServiceImpl();
                            tieEngineService.submitSyncQuotaRequest(tieRequestByTask);
                            taskStatus = WTCTaskStatus.ALL_FINISHED;
                            detailList = repository.batchLoadTaskDetailByTaskIdAndSubTaskId(taskId, subTaskReq.getShardingTask().getSubTaskId(), null);
                            WTCCalTaskDetailEntity detail2 = detailList.stream().filter(ele -> ele.getAttFileBoId() == bill.getAttFileBoId()).findFirst().orElse(null);
                            if (detail2 == null) {
                                res.markSysError("after cal, sharding detail lose");
                                taskStatus = WTCTaskStatus.ALL_ERROR;
                                bootTaskRes2 = res;
                                if (taskStatus == null) return bootTaskRes2;
                                break block15;
                            }
                            if (WTCTaskDetailStatus.NOT_ACCOUNT == detail2.getTaskDetailState() || WTCTaskDetailStatus.FAIL == detail2.getTaskDetailState()) {
                                String exInfo = detail2.getExInfo();
                                res.markBizError(exInfo);
                                taskStatus = WTCTaskStatus.ALL_ERROR;
                                callBack3 = res;
                                if (taskStatus == null) return callBack3;
                                break block16;
                            }
                            bootTaskRes = res;
                            if (taskStatus == null) return bootTaskRes;
                            break block17;
                        }
                        catch (Exception exp) {
                            log.warn("runTaskForBill fail:", (Throwable)exp);
                            res.markSysError(exp.getMessage());
                            BootTaskRes bootTaskRes5 = res;
                            return bootTaskRes5;
                        }
                    }
                    WTCTaskStateTransfer.transferToSpecialState((Long)taskId, taskStatus, (String)"wtte_qttie");
                    QTTieTaskStatusCallBack callBack2 = new QTTieTaskStatusCallBack();
                    callBack2.statusChangeCallBack(QTAccountModeHelper.getDeductChainDao(), Long.valueOf(taskId), taskStatus, "wtte_qttie");
                    return bootTaskRes3;
                }
                WTCTaskStateTransfer.transferToSpecialState((Long)taskId, (WTCTaskStatus)taskStatus, (String)"wtte_qttie");
                QTTieTaskStatusCallBack callBack3 = new QTTieTaskStatusCallBack();
                callBack3.statusChangeCallBack(QTAccountModeHelper.getDeductChainDao(), Long.valueOf(taskId), taskStatus, "wtte_qttie");
                return bootTaskRes2;
            }
            WTCTaskStateTransfer.transferToSpecialState((Long)taskId, (WTCTaskStatus)taskStatus, (String)"wtte_qttie");
            QTTieTaskStatusCallBack callBack4 = new QTTieTaskStatusCallBack();
            callBack4.statusChangeCallBack(QTAccountModeHelper.getDeductChainDao(), Long.valueOf(taskId), taskStatus, "wtte_qttie");
            return callBack3;
        }
        WTCTaskStateTransfer.transferToSpecialState((Long)taskId, (WTCTaskStatus)taskStatus, (String)"wtte_qttie");
        QTTieTaskStatusCallBack callBack = new QTTieTaskStatusCallBack();
        callBack.statusChangeCallBack(QTAccountModeHelper.getDeductChainDao(), Long.valueOf(taskId), taskStatus, "wtte_qttie");
        return bootTaskRes;
        finally {
            if (taskStatus != null) {
                WTCTaskStateTransfer.transferToSpecialState((Long)taskId, taskStatus, (String)"wtte_qttie");
                QTTieTaskStatusCallBack callBack5 = new QTTieTaskStatusCallBack();
                callBack5.statusChangeCallBack(QTAccountModeHelper.getDeductChainDao(), Long.valueOf(taskId), taskStatus, "wtte_qttie");
            }
        }
    }

    private static void newAndSaveCalResult(WTCTaskRequestStd taskRequest) {
        DynamicObject resultObject = BillIncCalHelper.genQtCalResultDy(taskRequest);
        QTAccountModeHelper.getDeductChainDao().saveOne(resultObject);
    }

    public static WTCTaskRequestStd genReq(BillApply bill) {
        DateRange selectedDateRange = BillIncCalHelper.getSelectedDateRange(bill);
        long attFileVId = bill.getAttFileVId();
        DynamicObject file = AttFileQueryServiceImpl.getInstance().queryOneAttFile(null, (Object)attFileVId);
        List personInfoList = WTCCollections.modifiableList((Object[])new Map[]{HRAuthUtil.getAuthFieldByAttFileDyn((DynamicObject)file)});
        long taskId = DB.genGlobalLongId();
        WTCTaskRequestStd request = new WTCTaskRequestStd();
        request.setAppId("wtte");
        request.setTaskId(taskId);
        request.setTrial(false);
        request.setSource(WTCSource.SCHEDULE.getCode());
        request.setTaskId(taskId);
        request.setVersion(bill.getBillNo());
        request.setDesc(bill.getBillNo());
        request.setCreatorId(RequestContext.get().getCurrUserId());
        request.setCategory("wtte_qttie");
        request.setStartDate(selectedDateRange.getBegin());
        request.setEndDate(selectedDateRange.getEnd());
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
        paramMap.put("number", taskId);
        paramMap.put("name", ResManager.loadKDString((String)"\u5b9a\u989d\u6838\u7b97", (String)"QTCalculateService_0", (String)"wtc-wtes-business", (Object[])new Object[0]));
        paramMap.put("saveStep", Boolean.FALSE);
        paramMap.put("planId", AccountPlanUtil.queryQuotaDefaultDeductPlanId());
        paramMap.put("tiePlanId", AccountPlanUtil.queryDefaultPlanId());
        long tiePlanId = SystemParamQueryUtil.getDefaultTiePlanId();
        if (0L != tiePlanId) {
            paramMap.put("tiePlanId", tiePlanId);
        }
        paramMap.put("accountmode", "B");
        paramMap.put("qttype", WTCCollections.modifiableEmptyList());
        paramMap.put("dyqttype", WTCCollections.modifiableEmptyList());
        paramMap.put("computingBillId", bill.getId());
        request.setParams((Map)paramMap);
        request.setDetail(personInfoList);
        return request;
    }

    private static Date eraseMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private static DynamicObject genQtCalResultDy(WTCTaskRequestStd req) {
        DynamicObject resultObject = QTAccountModeHelper.getEmptyDynByAccountMode((String)"B");
        resultObject.set("computingbillid", req.getParam("computingBillId"));
        resultObject.set("qttype", req.getParam("qttype"));
        resultObject.set("dyqttype", req.getParam("dyqttype"));
        resultObject.set("savestep", req.getParam("saveStep"));
        resultObject.set("org", (Object)RequestContext.get().getOrgId());
        resultObject.set("planid", req.getParam("planId"));
        resultObject.set("tieplanid", req.getParam("tiePlanId"));
        resultObject.set("desc", (Object)req.getDesc());
        resultObject.set("creator", (Object)req.getCreatorId());
        resultObject.set("createtime", (Object)new Date());
        resultObject.set("taskid", (Object)req.getTaskId());
        resultObject.set("id", (Object)req.getTaskId());
        resultObject.set("begindate", (Object)req.getStartDate());
        resultObject.set("enddate", (Object)BillIncCalHelper.eraseMillis(req.getEndDate()));
        resultObject.set("version", (Object)req.getVersion());
        DataEntityPropertyCollection propertyCollection = resultObject.getDataEntityType().getProperties();
        MulBasedataProp mulBasedataProp = (MulBasedataProp)propertyCollection.get((Object)"qttype");
        DynamicObjectType mulType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        DynamicObjectCollection qtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : (List)req.getParam("qttype")) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            qtTypes.add((Object)dynamicObject);
        }
        resultObject.set("qttype", (Object)qtTypes);
        DynamicObjectCollection dyQtTypes = new DynamicObjectCollection();
        for (Long qtTypeId : (List)req.getParam("dyqttype")) {
            DynamicObject dynamicObject = new DynamicObject(mulType);
            dynamicObject.set("fbasedataid_id", (Object)qtTypeId);
            dyQtTypes.add((Object)dynamicObject);
        }
        resultObject.set("dyqttype", (Object)dyQtTypes);
        return resultObject;
    }

    private static QuotaRequestStd getQtTieRequestByTask(WTCTaskRequestStd taskRequest, WTCTaskDispatchRequest subTaskReq, List<Object> shardingDetailList) {
        Object checkAuth;
        QuotaRequestStd quotaRequestStd = new QuotaRequestStd();
        quotaRequestStd.setTest(taskRequest.isTrial());
        quotaRequestStd.setSubTaskId(subTaskReq.getShardingTask().getSubTaskId());
        quotaRequestStd.setTaskId(taskRequest.getTaskId());
        quotaRequestStd.setShardingIndex(subTaskReq.getShardingTask().getIndex());
        quotaRequestStd.setVersion(taskRequest.getVersion());
        quotaRequestStd.setStartDate(taskRequest.getStartDate().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        quotaRequestStd.setEndDate(taskRequest.getEndDate().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate());
        quotaRequestStd.setSaveEvaluationDetail((Boolean)taskRequest.getParam("saveStep"));
        quotaRequestStd.setPlanId(taskRequest.getParam("planId") == null ? 0L : Long.parseLong(taskRequest.getParam("planId").toString()));
        quotaRequestStd.setTiePlanId(taskRequest.getParam("tiePlanId") == null ? 0L : Long.parseLong(taskRequest.getParam("tiePlanId").toString()));
        quotaRequestStd.setCreateTime(LocalDateTime.now());
        quotaRequestStd.setCreateUserId(taskRequest.getCreatorId());
        quotaRequestStd.setRegQtTypeIds((List)taskRequest.getParam("qttype"));
        quotaRequestStd.setDyQtTypeIds((List)taskRequest.getParam("dyqttype"));
        quotaRequestStd.setAccountMode((String)taskRequest.getParam("accountmode"));
        Object computingBillId = taskRequest.getParam("computingBillId");
        if (computingBillId != null) {
            quotaRequestStd.setComputingBillId(Long.parseLong(computingBillId.toString()));
        }
        if (null != (checkAuth = taskRequest.getParam("checkAuth"))) {
            quotaRequestStd.setCheckAuth((Boolean)checkAuth);
        }
        BillIncCalHelper.buildTaskSharding(quotaRequestStd, shardingDetailList);
        return quotaRequestStd;
    }

    private static void buildTaskSharding(QuotaRequestStd tieRequestStd, List taskShardingDetails) {
        List shareDetails = taskShardingDetails;
        Set personIds = shareDetails.stream().map(WTCTaskCalShardingDetail::getAttPersonId).collect(Collectors.toSet());
        tieRequestStd.setAttPersonIds(new ArrayList<Long>(personIds));
        Set BoIds = shareDetails.stream().map(WTCTaskCalShardingDetail::getAttFileBoId).collect(Collectors.toSet());
        tieRequestStd.setAttFileBoIds(new ArrayList<Long>(BoIds));
        tieRequestStd.setAttPlainSubject(shareDetails.stream().map(BillIncCalHelper::buildAttSubject).collect(Collectors.toList()));
    }

    private static AttPlainSubject buildAttSubject(WTCTaskCalShardingDetail shardingDetail) {
        AttPlainSubject subject = new AttPlainSubject();
        subject.setAttPersonId(shardingDetail.getAttPersonId());
        subject.setAttFileBoid(shardingDetail.getAttFileBoId());
        return subject;
    }

    private static String getNeedQueryColumn() {
        return WTCStringUtils.joinOnComma((String[])new String[]{"id", "boid", "attperson.id", "atttag.id", "empposorgrel.id", "empposorgrel.position.id", "empposorgrel.job.id", "cmpemp.managingscope.id", "empposorgrel.company.id", "empposorgrel.adminorg.id", "attperson.agreedlocation.id", "org.id", "affiliateadminorg.id", "empgroup.id", "dependency.id", "dependencytype.id", "workplace.id", "atttag.attendstatus", "bsed", "bsled"});
    }
}

